/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.property;

import java.util.ArrayList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceLoggerComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.BasePropertySource;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class TraceLoggerPropertySource
extends BasePropertySource {
    public static final String TRACE_LOGGER_NAME_PROPERTY_ID = "trace.logger.name";
    public static final String TRACE_LOGGER_LOGLEVEL_PROPERTY_ID = "trace.logger.loglevel";
    public static final String TRACE_LOGGER_STATE_PROPERTY_ID = "trace.logger.state";
    public static final String TRACE_LOGGER_NAME_PROPERTY_NAME = Messages.TraceControl_LoggerNamePropertyName;
    public static final String TRACE_LOGGER_LOGLEVEL_PROPERTY_NAME = Messages.TraceControl_LogLevelPropertyName;
    public static final String TRACE_LOGGER_STATE_PROPERTY_NAME = Messages.TraceControl_StatePropertyName;
    protected final TraceLoggerComponent fLogger;

    public TraceLoggerPropertySource(TraceLoggerComponent component) {
        this.fLogger = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<ReadOnlyTextPropertyDescriptor> list = new ArrayList<ReadOnlyTextPropertyDescriptor>();
        list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_LOGGER_NAME_PROPERTY_ID, TRACE_LOGGER_NAME_PROPERTY_NAME));
        list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_LOGGER_STATE_PROPERTY_ID, TRACE_LOGGER_STATE_PROPERTY_NAME));
        if (!this.fLogger.getLogLevel().equals(TraceJulLogLevel.LEVEL_UNKNOWN) || !this.fLogger.getLogLevel().equals(TraceLog4jLogLevel.LEVEL_UNKNOWN)) {
            list.add(new ReadOnlyTextPropertyDescriptor((Object)TRACE_LOGGER_LOGLEVEL_PROPERTY_ID, TRACE_LOGGER_LOGLEVEL_PROPERTY_NAME));
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (TRACE_LOGGER_NAME_PROPERTY_ID.equals(id)) {
            return this.fLogger.getName();
        }
        if (TRACE_LOGGER_LOGLEVEL_PROPERTY_ID.equals(id)) {
            StringBuffer buffer = new StringBuffer();
            if (this.fLogger.getLogLevelType().equals((Object)LogLevelType.LOGLEVEL_ALL)) {
                buffer.append(this.fLogger.getLogLevelType().getShortName());
            } else {
                buffer.append(this.fLogger.getLogLevelType().getShortName()).append(" ");
                buffer.append(this.fLogger.getLogLevel().getInName());
            }
            return buffer.toString();
        }
        if (TRACE_LOGGER_STATE_PROPERTY_ID.equals(id)) {
            return this.fLogger.getState().name();
        }
        return null;
    }
}

