/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.P2ImportExport;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FConstants;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FParser;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FWriter;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class ImportExportImpl
implements P2ImportExport {
    public static final int IGNORE_LOCAL_REPOSITORY = 1;
    public static final int CANNOT_FIND_REPOSITORY = 2;
    private IProvisioningAgent agent = null;

    public void bind(IProvisioningAgent agt) {
        this.agent = agt;
    }

    public void unbind(IProvisioningAgent agt) {
        if (this.agent == agt) {
            this.agent = null;
        }
    }

    @Override
    public List<IUDetail> importP2F(InputStream input) throws IOException {
        P2FParser parser = new P2FParser(Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext(), "org.eclipse.equinox.p2.ui.importexport");
        parser.parse(input);
        return parser.getIUs();
    }

    @Override
    public IStatus exportP2F(OutputStream output, IInstallableUnit[] ius, boolean allowEntriesWithoutRepo, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Replicator_ExportJobName, (int)1000);
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI[] uris = repoManager.getKnownRepositories(18);
        ArrayList<IMetadataRepository> repos = new ArrayList<IMetadataRepository>(uris.length);
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            try {
                IMetadataRepository repo = repoManager.loadRepository(uri, (IProgressMonitor)subMonitor.newChild(500 / uris.length, 7));
                repos.add(repo);
            }
            catch (ProvisionException provisionException) {}
            ++n2;
        }
        subMonitor.setWorkRemaining(500);
        ArrayList<IUDetail> rootsToExport = new ArrayList<IUDetail>(ius.length);
        SubMonitor sub2 = subMonitor.newChild(450, 7);
        sub2.setWorkRemaining(ius.length * 100);
        MultiStatus queryRepoResult = new MultiStatus("org.eclipse.equinox.p2.ui.importexport", 0, null, null);
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n3 = ius.length;
        int n4 = 0;
        while (n4 < n3) {
            IInstallableUnit iu = iInstallableUnitArray[n4];
            ArrayList<URI> referredRepos = new ArrayList<URI>(1);
            if (sub2.isCanceled()) {
                throw new OperationCanceledException();
            }
            SubMonitor sub3 = sub2.newChild(100);
            sub3.setWorkRemaining(repos.size() * 100);
            for (IMetadataRepository repo : repos) {
                IQueryResult result = repo.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, true)), (IProgressMonitor)sub3.newChild(100));
                if (result.isEmpty()) continue;
                referredRepos.add(repo.getLocation());
            }
            sub3.setWorkRemaining(1).worked(1);
            if (referredRepos.size() != 0 || referredRepos.size() == 0 && allowEntriesWithoutRepo) {
                IUDetail iuToExport = new IUDetail(iu, referredRepos);
                rootsToExport.add(iuToExport);
            } else if (this.isContainedInLocalRepo(iu)) {
                queryRepoResult.add((IStatus)new Status(1, "org.eclipse.equinox.p2.ui.importexport", 1, NLS.bind((String)Messages.Replicator_InstallFromLocal, (Object)iu.getProperty("org.eclipse.equinox.p2.name", Locale.getDefault().toString())), null));
            } else {
                queryRepoResult.add((IStatus)new Status(2, "org.eclipse.equinox.p2.ui.importexport", 2, NLS.bind((String)Messages.Replicator_NotFoundInRepository, (Object)iu.getProperty("org.eclipse.equinox.p2.name", Locale.getDefault().toString())), null));
            }
            ++n4;
        }
        subMonitor.setWorkRemaining(50);
        IStatus status = this.exportP2F(output, rootsToExport, (IProgressMonitor)subMonitor);
        if (status.isOK() && queryRepoResult.isOK()) {
            return status;
        }
        return new MultiStatus("org.eclipse.equinox.p2.ui.importexport", 0, new IStatus[]{queryRepoResult, status}, null, null);
    }

    private boolean isContainedInLocalRepo(IInstallableUnit iu) {
        URI[] uris;
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI[] uRIArray = uris = repoManager.getKnownRepositories(6);
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            try {
                IMetadataRepository repo = repoManager.loadRepository(uri, null);
                if (!repo.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, true)), null).isEmpty()) {
                    return true;
                }
            }
            catch (ProvisionException provisionException) {}
            ++n2;
        }
        return false;
    }

    @Override
    public IStatus exportP2F(OutputStream output, List<IUDetail> ius, IProgressMonitor monitor) {
        SubMonitor sub;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Replicator_SaveJobName, (int)100)).isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            P2FWriter writer = new P2FWriter(output, new XMLWriter.ProcessingInstruction[]{XMLWriter.ProcessingInstruction.makeTargetVersionInstruction((String)"p2f", (Version)P2FConstants.CURRENT_VERSION)});
            writer.write(ius);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            sub.worked(100);
        }
    }
}

