/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.model;

import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public enum ProcessStatus {
    UNKNOWN(StateValues.PROCESS_STATUS_UNKNOWN_VALUE),
    WAIT_FORK(StateValues.PROCESS_STATUS_WAIT_FORK_VALUE),
    WAIT_CPU(StateValues.PROCESS_STATUS_WAIT_FOR_CPU_VALUE),
    EXIT(StateValues.PROCESS_STATUS_UNKNOWN_VALUE),
    ZOMBIE(StateValues.PROCESS_STATUS_UNKNOWN_VALUE),
    WAIT_BLOCKED(StateValues.PROCESS_STATUS_WAIT_BLOCKED_VALUE),
    RUN(StateValues.PROCESS_STATUS_RUN_USERMODE_VALUE),
    NOT_ALIVE((ITmfStateValue)TmfStateValue.nullValue()),
    RUN_SYTEMCALL(StateValues.PROCESS_STATUS_RUN_SYSCALL_VALUE),
    INTERRUPTED(StateValues.PROCESS_STATUS_INTERRUPTED_VALUE),
    WAIT_UNKNOWN(StateValues.PROCESS_STATUS_WAIT_UNKNOWN_VALUE);

    private final ITmfStateValue fValue;

    private ProcessStatus(ITmfStateValue value) {
        this.fValue = value;
    }

    public ITmfStateValue getStateValue() {
        return this.fValue;
    }

    public static ProcessStatus getStatusFromStatedump(long status) {
        switch (Long.valueOf(status).intValue()) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return WAIT_FORK;
            }
            case 2: {
                return WAIT_CPU;
            }
            case 3: {
                return EXIT;
            }
            case 4: {
                return ZOMBIE;
            }
            case 5: {
                return WAIT_UNKNOWN;
            }
            case 6: {
                return RUN;
            }
            case 7: {
                return NOT_ALIVE;
            }
        }
        return UNKNOWN;
    }

    public static ProcessStatus getStatusFromStateValue(ITmfStateValue sv) {
        ProcessStatus[] processStatusArray = ProcessStatus.values();
        int n = processStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessStatus e = processStatusArray[n2];
            if (e.getStateValue().equals(sv)) {
                return e;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    private static boolean isDead(int state) {
        return (state & 0x40) != 0;
    }

    private static boolean isWaiting(int state) {
        return (state & 3) != 0;
    }

    private static boolean isRunning(int state) {
        return state == 0;
    }

    public static ProcessStatus getStatusFromKernelState(Long prevState) {
        int state = (int)(prevState & 0x3FFL);
        if (ProcessStatus.isRunning(state)) {
            return WAIT_CPU;
        }
        if (ProcessStatus.isWaiting(state)) {
            return WAIT_BLOCKED;
        }
        if (ProcessStatus.isDead(state)) {
            return NOT_ALIVE;
        }
        return WAIT_UNKNOWN;
    }
}

