/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.jface.action.IAction;

public class RemoveAllTerminatedAction
extends AbstractRemoveAllActionDelegate
implements ILaunchesListener2 {
    @Override
    protected boolean isEnabled() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches != null) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch.isTerminated()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void removeTerminatedLaunches(ILaunch[] elements) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>();
        ILaunch[] iLaunchArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch.isTerminated()) {
                removed.add(launch);
            }
            ++n2;
        }
        if (!removed.isEmpty()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            manager.removeLaunches(removed.toArray(new ILaunch[removed.size()]));
        }
    }

    @Override
    protected void initialize() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        IAction action = this.getAction();
        if (action != null && action.isEnabled()) {
            this.update();
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.update();
    }

    public void run(IAction action) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        RemoveAllTerminatedAction.removeTerminatedLaunches(launches);
    }
}

