/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.mapping.ResourceVariantFileRevision;
import org.eclipse.team.internal.ui.StorageTypedElement;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.ui.IEditorInput;

public class RemoteResourceTypedElement
extends StorageTypedElement {
    private IResourceVariant remote;

    public RemoteResourceTypedElement(IResourceVariant remote, String encoding) {
        super(encoding);
        Assert.isNotNull((Object)remote);
        this.remote = remote;
    }

    public String getName() {
        return this.remote.getName();
    }

    @Override
    public String getType() {
        if (this.remote.isContainer()) {
            return "FOLDER";
        }
        return super.getType();
    }

    @Override
    protected IStorage fetchContents(IProgressMonitor monitor) throws TeamException {
        return this.remote.getStorage(monitor);
    }

    @Override
    public IEditorInput getDocumentKey(Object element) {
        if (element == this && this.getBufferedStorage() != null) {
            return new FileRevisionEditorInput(new ResourceVariantFileRevision(this.remote), this.getBufferedStorage(), this.getLocalEncoding());
        }
        return null;
    }
}

