/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast.cpp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPInheritance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class SemanticQueries {
    private static final String OPERATOR_EQ = "operator =";

    public static boolean isCopyOrMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveKind.COPY_OR_MOVE);
    }

    public static boolean isMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveKind.MOVE);
    }

    public static boolean isCopyConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveKind.COPY);
    }

    public static boolean isCopyAssignmentOperator(ICPPMethod method) {
        return SemanticQueries.isAssignmentOperator(method, CopyOrMoveKind.COPY);
    }

    public static boolean isCopyOrMoveAssignmentOperator(ICPPMethod method) {
        return SemanticQueries.isAssignmentOperator(method, CopyOrMoveKind.COPY_OR_MOVE);
    }

    public static boolean isMoveAssignmentOperator(ICPPMethod method) {
        return SemanticQueries.isAssignmentOperator(method, CopyOrMoveKind.MOVE);
    }

    private static boolean isAssignmentOperator(ICPPMethod method, CopyOrMoveKind kind) {
        if (!OPERATOR_EQ.equals(method.getName())) {
            return false;
        }
        if (method instanceof ICPPFunctionTemplate) {
            return false;
        }
        if (!SemanticQueries.isCallableWithNumberOfArguments(method, 1)) {
            return false;
        }
        IType firstArgumentType = method.getType().getParameterTypes()[0];
        if (!((firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 1)) instanceof ICPPReferenceType) && kind == CopyOrMoveKind.MOVE) {
            return false;
        }
        if (firstArgumentType instanceof ICPPReferenceType) {
            if (kind == CopyOrMoveKind.MOVE && !((ICPPReferenceType)firstArgumentType).isRValueReference()) {
                return false;
            }
            if (kind == CopyOrMoveKind.COPY && ((ICPPReferenceType)firstArgumentType).isRValueReference()) {
                return false;
            }
        }
        firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 12);
        ICPPClassType classType = method.getClassOwner();
        if (classType instanceof ICPPClassTemplate) {
            classType = CPPTemplates.createDeferredInstance((ICPPClassTemplate)classType);
        }
        return firstArgumentType.isSameType(classType);
    }

    private static boolean isCopyOrMoveConstructor(ICPPConstructor constructor, CopyOrMoveKind kind) {
        if (constructor instanceof ICPPFunctionTemplate) {
            return false;
        }
        if (!SemanticQueries.isCallableWithNumberOfArguments(constructor, 1)) {
            return false;
        }
        IType firstArgumentType = constructor.getType().getParameterTypes()[0];
        if (!((firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 1)) instanceof ICPPReferenceType)) {
            return false;
        }
        ICPPReferenceType firstArgReferenceType = (ICPPReferenceType)firstArgumentType;
        boolean isRvalue = firstArgReferenceType.isRValueReference();
        if (isRvalue && kind == CopyOrMoveKind.COPY) {
            return false;
        }
        if (!isRvalue && kind == CopyOrMoveKind.MOVE) {
            return false;
        }
        firstArgumentType = firstArgReferenceType.getType();
        firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 8);
        ICPPClassType classType = constructor.getClassOwner();
        if (classType instanceof ICPPClassTemplate) {
            classType = CPPTemplates.createDeferredInstance((ICPPClassTemplate)classType);
        }
        return firstArgumentType.isSameType(classType);
    }

    private static boolean isCallableWithNumberOfArguments(ICPPFunction function, int numArguments) {
        return function.getParameters().length >= numArguments && function.getRequiredArgumentCount() <= numArguments;
    }

    public static ICPPMethod[] getPureVirtualMethods(ICPPClassType classType) {
        CPPInheritance.FinalOverriderMap finalOverriderMap = CPPInheritance.getFinalOverriderMap(classType);
        ArrayList<ICPPMethod> pureVirtualMethods = new ArrayList<ICPPMethod>();
        for (ICPPMethod method : finalOverriderMap.getMap().keySet()) {
            if (!method.isPureVirtual()) continue;
            Map<Integer, List<ICPPMethod>> finalOverriders = finalOverriderMap.getMap().get(method);
            for (Integer subobjectNumber : finalOverriders.keySet()) {
                List<ICPPMethod> overridersForSubobject = finalOverriders.get(subobjectNumber);
                if (overridersForSubobject.size() != 1 || overridersForSubobject.get(0) != method) continue;
                pureVirtualMethods.add(method);
            }
        }
        return pureVirtualMethods.toArray(new ICPPMethod[pureVirtualMethods.size()]);
    }

    @Deprecated
    public static ICPPMethod[] getPureVirtualMethods(ICPPClassType classType, IASTNode point) {
        return SemanticQueries.getPureVirtualMethods(classType);
    }

    public static boolean isUnknownBuiltin(IProblemBinding binding, IASTNode node) {
        boolean isBuiltin;
        char[] name = binding.getNameCharArray();
        boolean bl = isBuiltin = binding.getID() == 1 && CharArrayUtils.startsWith(name, "__builtin_");
        if (isBuiltin) {
            IASTTranslationUnit tu;
            if (node != null && (tu = node.getTranslationUnit()) instanceof ASTTranslationUnit) {
                return !((ASTTranslationUnit)tu).isKnownBuiltin(name);
            }
            return true;
        }
        return false;
    }

    private static enum CopyOrMoveKind {
        COPY,
        MOVE,
        COPY_OR_MOVE;

    }
}

