/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.widgets.timegraph.model;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;

public class TimeLineEvent
extends TimeEvent {
    private final List<@Nullable Long> fValues;
    private String fLabel = null;

    public TimeLineEvent(ITimeGraphEntry entry, long time) {
        this(entry, time, new ArrayList<Long>());
    }

    public TimeLineEvent(ITimeGraphEntry entry, long time, List<@Nullable Long> values) {
        super(entry, time, 0L);
        this.fValues = values;
    }

    public void addValue(@Nullable Long value) {
        this.fValues.add(value);
        this.fLabel = null;
    }

    @Override
    public String getLabel() {
        String label = this.fLabel;
        if (label == null) {
            StringJoiner sj = new StringJoiner(", ");
            this.getValues().forEach(value -> {
                StringJoiner stringJoiner2 = sj.add(value == null ? String.valueOf(value) : NumberFormat.getNumberInstance(Locale.getDefault()).format(value));
            });
            this.fLabel = label = sj.toString();
        }
        return label;
    }

    public List<Long> getValues() {
        return Collections.unmodifiableList(this.fValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fValues);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof TimeLineEvent) {
            TimeLineEvent lineEvent = (TimeLineEvent)obj;
            return Objects.equals(this.getValues(), lineEvent.getValues());
        }
        return false;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " time=" + this.fTime + " value=[" + this.getLabel() + ']';
    }
}

