/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.FlameDefaultPalette;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.core.Activator;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackEntryModel;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.Messages;
import org.eclipse.tracecompass.internal.tmf.core.analysis.callsite.CallsiteAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CallStackDataProvider
extends AbstractTimeGraphDataProvider<CallStackAnalysis, CallStackEntryModel>
implements IOutputStyleProvider {
    private static final String ADDRESS_FORMAT = "0x%x";
    public static final @NonNull String ID = "org.eclipse.tracecompass.internal.analysis.profiling.callstack.provider.CallStackDataProvider";
    private static final int UNKNOWN_TID = -1;
    private final Map<Integer, Integer> fQuarkToPid = new HashMap<Integer, Integer>();
    private final @NonNull Collection<@NonNull ISymbolProvider> fProviders = new ArrayList<ISymbolProvider>();
    private final LoadingCache<TimePidNameValue, @Nullable String> fTimeEventNames = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<TimePidNameValue, String>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable String load(TimePidNameValue value) {
            Object nameValue = value.getNameValue();
            Long address = null;
            String name = null;
            if (nameValue instanceof String) {
                name = (String)nameValue;
                try {
                    address = Long.parseLong(name, 16);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (nameValue instanceof Integer) {
                Integer intValue = (Integer)nameValue;
                name = "0x" + Integer.toUnsignedString(intValue, 16);
                address = intValue.longValue();
            } else if (nameValue instanceof Long) {
                address = (long)((Long)nameValue);
                name = "0x" + Long.toUnsignedString(address, 16);
            }
            if (address != null) {
                Collection collection = CallStackDataProvider.this.fProviders;
                synchronized (collection) {
                    name = SymbolProviderUtils.getSymbolText((Collection)CallStackDataProvider.this.fProviders, (int)value.getPid(), (long)value.getTime(), (long)address);
                }
            }
            return name;
        }
    });

    public CallStackDataProvider(@NonNull ITmfTrace trace, @NonNull CallStackAnalysis module) {
        super(trace, (TmfStateSystemAnalysisModule)module);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected TmfTreeModel<@NonNull CallStackEntryModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        this.resetFunctionNames(monitor);
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        ImmutableList.Builder builder = ImmutableList.builder();
        long traceId = this.getId(-1);
        builder.add((Object)new CallStackEntryModel(traceId, -1L, Collections.singletonList(this.getTrace().getName()), start, end, -2, -1));
        List processQuarks = ss.getQuarks(((CallStackAnalysis)this.getAnalysisModule()).getProcessesPattern());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#fetchTree", (int)processQuarks.size());
        @NonNull List fullStart = ss.queryFullState(start);
        @NonNull List fullEnd = ss.queryFullState(end);
        Iterator iterator = processQuarks.iterator();
        while (iterator.hasNext()) {
            int processQuark = (Integer)iterator.next();
            long threadParentId = traceId;
            int pid = -1;
            if (processQuark != -1) {
                threadParentId = this.getId(processQuark);
                String processName = ss.getAttributeName(processQuark);
                Object processValue = ((ITmfStateInterval)fullEnd.get(processQuark)).getValue();
                pid = CallStackDataProvider.getThreadProcessId(processName, processValue);
                builder.add((Object)new CallStackEntryModel(threadParentId, traceId, Collections.singletonList(processName), start, end, -1, pid));
            }
            List threadQuarks = ss.getQuarks(processQuark, ((CallStackAnalysis)this.getAnalysisModule()).getThreadsPattern());
            Iterator iterator2 = threadQuarks.iterator();
            while (iterator2.hasNext()) {
                int threadQuark = (Integer)iterator2.next();
                int callStackQuark = ss.optQuarkRelative(threadQuark, new String[]{"CallStack"});
                if (callStackQuark == -2 || callStackQuark >= fullStart.size() || threadQuark >= fullStart.size()) continue;
                String threadName = ss.getAttributeName(threadQuark);
                long callStackParent = threadParentId;
                if (threadQuark != processQuark) {
                    CallStackEntryModel thread = this.createThread(ss, start, end, threadQuark, threadParentId, callStackQuark, fullStart, fullEnd);
                    callStackParent = thread.getId();
                    builder.add((Object)thread);
                }
                List callStackAttributes = ss.getSubAttributes(callStackQuark, false);
                this.createStackEntries(callStackAttributes, start, end, pid, threadName, callStackParent, (ImmutableList.Builder<CallStackEntryModel>)builder);
            }
            subMonitor.worked(1);
        }
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private CallStackEntryModel createThread(ITmfStateSystem ss, long start, long end, int threadQuark, long processId, int callStackQuark, List<ITmfStateInterval> fullStart, List<ITmfStateInterval> fullEnd) {
        String threadName = ss.getAttributeName(threadQuark);
        long threadEnd = end + 1L;
        ITmfStateInterval endInterval = fullEnd.get(callStackQuark);
        if (endInterval.getValue() == null && endInterval.getStartTime() != ss.getStartTime()) {
            threadEnd = endInterval.getStartTime();
        }
        Object threadStateValue = fullEnd.get(threadQuark).getValue();
        int threadId = CallStackDataProvider.getThreadProcessId(threadName, threadStateValue);
        ITmfStateInterval startInterval = fullStart.get(callStackQuark);
        long threadStart = startInterval.getValue() == null ? Long.min(startInterval.getEndTime() + 1L, end) : start;
        return new CallStackEntryModel(this.getId(threadQuark), processId, Collections.singletonList(threadName), threadStart, threadEnd, 0, threadId);
    }

    private void createStackEntries(List<Integer> callStackAttributes, long start, long end, int pid, String threadName, long callStackParent, ImmutableList.Builder<CallStackEntryModel> builder) {
        int level = 1;
        for (int stackLevelQuark : callStackAttributes) {
            long id = this.getId(stackLevelQuark);
            builder.add((Object)new CallStackEntryModel(id, callStackParent, Collections.singletonList(threadName), start, end, level, pid));
            this.fQuarkToPid.put(stackLevelQuark, pid);
            ++level;
        }
    }

    private static int getThreadProcessId(String name, @Nullable Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected TimeGraphModel getRowModel(ITmfStateSystem ss, @NonNull Map<@NonNull String, @NonNull Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return null;
        }
        @NonNull @NonNull Map entries = this.getSelectedEntries(filter);
        if (entries.size() == 1 && filter.getTimesRequested().length == 2) {
            Map.Entry<@NonNull Long, @NonNull Integer> entry = entries.entrySet().iterator().next();
            if (filter.getStart() == Long.MIN_VALUE) {
                return new TimeGraphModel(CallStackDataProvider.getFollowEvent(ss, entry, filter.getEnd(), false));
            }
            if (filter.getEnd() == Long.MAX_VALUE) {
                return new TimeGraphModel(CallStackDataProvider.getFollowEvent(ss, entry, filter.getStart(), true));
            }
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#fetchRowModel", (int)2);
        ArrayListMultimap intervals = ArrayListMultimap.create();
        Collection times = CallStackDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (subMonitor.isCanceled()) {
                return null;
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        subMonitor.worked(1);
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<@NonNull TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (subMonitor.isCanceled()) {
                return null;
            }
            List states = intervals.get((Object)((Integer)entry.getValue()));
            Long key = Objects.requireNonNull((Long)entry.getKey());
            ArrayList<ITimeGraphState> eventList = new ArrayList<ITimeGraphState>(states.size());
            states.forEach(state -> {
                ITimeGraphState timeGraphState = this.createTimeGraphState((ITmfStateInterval)state);
                this.applyFilterAndAddState(eventList, timeGraphState, key, predicates, monitor);
            });
            eventList.sort(Comparator.comparingLong(ITimeElement::getStartTime));
            rows.add(new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        subMonitor.worked(1);
        return new TimeGraphModel(rows);
    }

    private ITimeGraphState createTimeGraphState(ITmfStateInterval interval) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        Object value = interval.getValue();
        Integer pid = this.fQuarkToPid.get(interval.getAttribute());
        if (value != null && pid != null) {
            String name = (String)this.fTimeEventNames.getUnchecked((Object)new TimePidNameValue(pid, interval.getValue(), interval.getStartTime()));
            Object key = name == null ? value : name;
            return new TimeGraphState(startTime, duration, name, FlameDefaultPalette.getStyleFor(key));
        }
        return new TimeGraphState(startTime, duration, Integer.MIN_VALUE);
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public String getId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public void resetFunctionNames(@Nullable IProgressMonitor monitor) {
        this.fTimeEventNames.invalidateAll();
        Collection<ISymbolProvider> collection = this.fProviders;
        synchronized (collection) {
            @NonNull Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(this.getTrace());
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#resetFunctionNames", (int)symbolProviders.size());
            this.fProviders.clear();
            for (ISymbolProvider symbolProvider : symbolProviders) {
                this.fProviders.add(symbolProvider);
                symbolProvider.loadConfiguration((IProgressMonitor)sub);
                sub.worked(1);
            }
        }
    }

    private static List<ITimeGraphRowModel> getFollowEvent(ITmfStateSystem ss, Map.Entry<Long, Integer> entry, long time, boolean forward) throws StateSystemDisposedException {
        Object object;
        int parentQuark = ss.getParentAttributeQuark(entry.getValue().intValue());
        ITmfStateInterval current = ss.querySingleState(Long.max(ss.getStartTime(), Long.min(time, ss.getCurrentEndTime())), parentQuark);
        ITmfStateInterval interval = null;
        if (forward && current.getEndTime() + 1L <= ss.getCurrentEndTime()) {
            interval = ss.querySingleState(current.getEndTime() + 1L, parentQuark);
        } else if (!forward && current.getStartTime() - 1L >= ss.getStartTime()) {
            interval = ss.querySingleState(current.getStartTime() - 1L, parentQuark);
        }
        if (interval != null && interval.getValue() instanceof Number && (object = interval.getValue()) instanceof Number) {
            int value = ((Number)object).intValue();
            TimeGraphState state = new TimeGraphState(interval.getStartTime(), interval.getEndTime() - interval.getStartTime(), value);
            TimeGraphRowModel row = new TimeGraphRowModel(entry.getKey().longValue(), Collections.singletonList(state));
            return Collections.singletonList(row);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        CallStackAnalysis analysis = (CallStackAnalysis)this.getAnalysisModule();
        HashMap<String, String> tooltips = new HashMap<String, String>();
        @NonNull List selected = DataProviderParameterUtils.extractSelectedItems(parameters);
        @NonNull List times = DataProviderParameterUtils.extractTimeRequested(parameters);
        if (selected != null && times != null) {
            @NonNull @NonNull Map md = this.getSelectedEntries(selected);
            ITmfTrace trace = this.getTrace();
            for (Long time : times) {
                for (Map.Entry entry : md.entrySet()) {
                    Long result = analysis.resolveDeviceId((Integer)entry.getValue(), time);
                    if (result != null) {
                        String deviceId = String.valueOf(result);
                        String deviceType = analysis.resolveDeviceType((Integer)entry.getValue(), time);
                        tooltips.put(deviceType, deviceId);
                        @NonNull Iterable csas = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallsiteAnalysis.class);
                        for (CallsiteAnalysis csa : csas) {
                            @NonNull List res = csa.getCallsites(String.valueOf(trace.getUUID()), deviceType, deviceId, time.longValue());
                            if (res.isEmpty()) continue;
                            tooltips.put(TmfStrings.source(), String.valueOf(res.get(0)));
                        }
                        return new TmfModelResponse(tooltips, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                    }
                    ITmfStateSystem stateSystem = analysis.getStateSystem();
                    if (stateSystem == null) continue;
                    try {
                        @NonNull Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
                        ITmfStateInterval interval = stateSystem.querySingleState(Objects.requireNonNull(time).longValue(), Objects.requireNonNull((Integer)entry.getValue()).intValue());
                        Object value = interval.getValue();
                        if (value instanceof Number) {
                            long longValue = ((Number)value).longValue();
                            for (ISymbolProvider provider : symbolProviders) {
                                TmfResolvedSymbol symbol = provider.getSymbol(longValue);
                                if (symbol == null) continue;
                                tooltips.put(Messages.CallStackDataProvider_toolTipState, symbol.getSymbolName());
                                tooltips.put(Messages.CallStackDataProvider_toolTipAddress, String.format(ADDRESS_FORMAT, symbol.getBaseAddress()));
                                break;
                            }
                            tooltips.computeIfAbsent(Messages.CallStackDataProvider_toolTipState, unused -> String.format(ADDRESS_FORMAT, longValue));
                            continue;
                        }
                        if (value == null) continue;
                        tooltips.put(Messages.CallStackDataProvider_toolTipState, interval.getValueString());
                    }
                    catch (StateSystemDisposedException e) {
                        Activator.getInstance().logError("State System Disposed", (Throwable)e);
                    }
                }
            }
        }
        return new TmfModelResponse(tooltips, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    protected boolean isCacheable() {
        return true;
    }

    public @NonNull TmfModelResponse<@NonNull OutputStyleModel> fetchStyle(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(FlameDefaultPalette.getStyles()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private static final class TimePidNameValue {
        private final long fTime;
        private final int fPid;
        private final Object fNameValue;

        public TimePidNameValue(int pid, Object nameValue, long time) {
            this.fTime = time;
            this.fPid = pid;
            this.fNameValue = nameValue;
        }

        public long getTime() {
            return this.fTime;
        }

        public int getPid() {
            return this.fPid;
        }

        public Object getNameValue() {
            return this.fNameValue;
        }

        public int hashCode() {
            return Objects.hash(this.fNameValue, this.fPid, this.fTime);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimePidNameValue other = (TimePidNameValue)obj;
            return Objects.equals(this.fNameValue, other.fNameValue) && this.fPid == other.fPid && this.fTime == other.fTime;
        }
    }
}

