/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.service;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISnapshotInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IUstProviderInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.shells.LTTngToolsFileShell;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.logging.ControlCommandLogger;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences.ControlPreferences;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LttngVersion;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LTTngControlServiceTest {
    private static final String DIRECTORY = "testfiles";
    private static final String TEST_STREAM = "LTTngServiceTest.cfg";
    private static final String SCEN_LTTNG_NOT_INSTALLED = "LttngNotInstalled";
    protected static final String SCEN_LTTNG_VERSION = "LttngVersion";
    protected static final String SCEN_LTTNG_VERSION_WITH_PROMPT = "LttngVersionWithPrompt";
    private static final String SCEN_LTTNG_UNSUPPORTED_VERSION = "LttngUnsupportedVersion";
    private static final String SCEN_LTTNG_NO_VERSION = "LttngNoVersion";
    protected static final String SCEN_LTTNG_COMPILED_VERSION = "LttngVersionCompiled";
    private static final String SCEN_NO_SESSION_AVAILABLE = "NoSessionAvailable";
    private static final String SCEN_GET_SESSION_NAMES1 = "GetSessionNames1";
    private static final String SCEN_GET_SESSION_WITH_GROUP = "GetSessionWithTracingGroup";
    private static final String SCEN_GET_SESSION_NAME_NOT_EXIST = "GetSessionNameNotExist";
    private static final String SCEN_GET_SESSION_NAME_NOT_EXIST_VERBOSE = "GetSessionNameNotExistVerbose";
    protected static final String SCEN_GET_SESSION_GARBAGE_OUT = "GetSessionGarbageOut";
    private static final String SCEN_GET_SESSION1 = "GetSession1";
    private static final String SCEN_GET_SESSION_WITH_LIVE = "GetSessionWithLiveInterval";
    private static final String SCEN_GET_KERNEL_PROVIDER1 = "GetKernelProvider1";
    private static final String SCEN_LIST_WITH_NO_KERNEL1 = "ListWithNoKernel1";
    private static final String SCEN_LIST_WITH_NO_KERNEL2 = "ListWithNoKernel2";
    private static final String SCEN_LIST_WITH_NO_KERNEL_VERBOSE = "ListWithNoKernelVerbose";
    private static final String SCEN_GET_UST_PROVIDER1 = "GetUstProvider1";
    private static final String SCEN_GET_UST_PROVIDER2 = "GetUstProvider2";
    private static final String SCEN_GET_UST_PROVIDER3 = "GetUstProvider3";
    private static final String SCEN_LIST_WITH_NO_UST1 = "ListWithNoUst1";
    private static final String SCEN_LIST_WITH_NO_UST2 = "ListWithNoUst2";
    private static final String SCEN_LIST_WITH_NO_UST3 = "ListWithNoUst3";
    private static final String SCEN_LIST_WITH_NO_UST_VERBOSE = "ListWithNoUstVerbose";
    private static final String SCEN_CREATE_SESSION1 = "CreateSession1";
    private static final String SCEN_CREATE_SESSION_WITH_PROMPT = "CreateSessionWithPrompt";
    private static final String SCEN_CREATE_SESSION_VARIANTS = "CreateSessionVariants";
    private static final String SCEN_DESTROY_SESSION1 = "DestroySession1";
    private static final String SCEN_DESTROY_SESSION_VERBOSE = "DestroySessionVerbose";
    private static final String SCEN_CHANNEL_HANDLING = "ChannelHandling";
    private static final String SCEN_EVENT_HANDLING = "EventHandling";
    private static final String SCEN_EVENT_EXCLUDED = "EventExcluded";
    private static final String SCEN_CONTEXT_HANDLING = "ContextHandling";
    private static final String SCEN_CONTEXT_ERROR_HANDLING = "ContextErrorHandling";
    private static final String SCEN_CREATE_SESSION_2_1 = "CreateSessionLttng2.1";
    private static final String SCEN_CREATE_SESSION_VERBOSE_2_1 = "CreateSessionLttngVerbose2.1";
    private static final String SCEN_CREATE_SNAPSHOT_SESSION = "CreateSessionSnapshot";
    private static final String SCEN_CREATE_SNAPSHOT_SESSION_2_5 = "CreateSessionSnapshot2.5";
    private static final String SCEN_CREATE_STREAMED_SNAPSHOT_SESSION = "CreateSessionStreamedSnapshot";
    private static final String SCEN_CREATE_SNAPSHOT_SESSION_ERRORS = "CreateSessionSnapshotErrors";
    protected static final String SCEN_CREATE_LIVE_SESSION = "CreateSessionLive";
    private static final String SCEN_CREATE_LIVE_SESSION_ERRORS = "CreateSessionLiveErrors";
    private static final String SCEN_SESSION_PROFILES = "SessionProfile";
    private String fTestfile;
    protected final @NonNull LTTngToolsFileShell fShell = new LTTngToolsFileShell();
    protected ILttngControlService fService;

    @Before
    public void setUp() throws Exception {
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path(String.valueOf(this.getTestDirectory()) + File.separator + this.getTestStream()), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestfile = testfile.getAbsolutePath();
        this.fShell.loadScenarioFile(this.fTestfile);
        this.fService = this.getControlService();
        if (this.fService == null) {
            throw new Exception("Unable to obtain a valid ControlService");
        }
        ControlPreferences.getInstance().init(Activator.getDefault().getPreferenceStore());
    }

    protected String getTestDirectory() {
        return DIRECTORY;
    }

    protected ILttngControlService getControlService() {
        return new LTTngControlService((ICommandShell)this.fShell);
    }

    public @NonNull LTTngToolsFileShell getShell() {
        return this.fShell;
    }

    protected String getTestStream() {
        return TEST_STREAM;
    }

    @After
    public void tearDown() {
        LTTngControlServiceTest.disableVerbose();
        ControlPreferences.getInstance().dispose();
    }

    @Test
    public void testVersion() {
        try {
            this.fShell.setScenario(SCEN_LTTNG_VERSION);
            ILttngControlService service = LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
            Assert.assertNotNull((Object)service);
            Assert.assertEquals((Object)"2.1.0", (Object)service.getVersionString());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exeption thrown " + (Object)((Object)e)));
        }
    }

    @Test
    public void testVersionWithPrompt() {
        try {
            this.fShell.setScenario(SCEN_LTTNG_VERSION_WITH_PROMPT);
            ILttngControlService service = LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
            Assert.assertNotNull((Object)service);
            Assert.assertEquals((Object)"2.0.0", (Object)service.getVersionString());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exeption thrown " + (Object)((Object)e)));
        }
    }

    @Test(expected=ExecutionException.class)
    public void testUnsupportedVersion() throws ExecutionException {
        this.fShell.setScenario(SCEN_LTTNG_UNSUPPORTED_VERSION);
        LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
    }

    @Test
    public void testNoVersion() {
        try {
            this.fShell.setScenario(SCEN_LTTNG_NO_VERSION);
            LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
            Assert.fail((String)"No exeption thrown");
        }
        catch (ExecutionException executionException) {}
    }

    @Test
    public void testVersionCompiled() {
        try {
            this.fShell.setScenario(SCEN_LTTNG_COMPILED_VERSION);
            ILttngControlService service = LTTngControlServiceFactory.getLttngControlService((ICommandShell)this.fShell);
            Assert.assertNotNull((Object)service);
            Assert.assertEquals((Object)"2.5.0", (Object)service.getVersionString());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Exeption thrown " + (Object)((Object)e)));
        }
    }

    @Test
    public void testLttngNotInstalled() {
        try {
            this.fShell.setScenario(SCEN_LTTNG_NOT_INSTALLED);
            this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"No exeption thrown");
        }
        catch (ExecutionException executionException) {}
    }

    @Test
    public void testGetSessionNames1() {
        try {
            this.fShell.setScenario(SCEN_NO_SESSION_AVAILABLE);
            List result = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)0L, (long)result.size());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetSessionNames2() {
        try {
            this.fShell.setScenario(SCEN_GET_SESSION_NAMES1);
            List result = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"mysession1", result.get(0));
            Assert.assertEquals((Object)"mysession", result.get(1));
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetSessionNamesWithTracingGroup() {
        try {
            this.fShell.setScenario(SCEN_GET_SESSION_WITH_GROUP);
            ControlPreferences.getInstance().getPreferenceStore().setValue("trace.control.tracing.group", "group");
            List result = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"mysession1", result.get(0));
            Assert.assertEquals((Object)"mysession", result.get(1));
            ControlCommandLogger.init((String)ControlPreferences.getInstance().getLogfilePath(), (boolean)false);
            ControlPreferences.getInstance().getPreferenceStore().setValue("trace.control.tracing.group", "tracing");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetSessionNotExist() {
        try {
            this.fShell.setScenario(SCEN_GET_SESSION_NAME_NOT_EXIST);
            this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"No exeption thrown");
        }
        catch (ExecutionException executionException) {}
    }

    @Test
    public void testGetSessionNotExistVerbose() {
        try {
            try {
                LTTngControlServiceTest.enableVerbose();
                this.fShell.setScenario(SCEN_GET_SESSION_NAME_NOT_EXIST_VERBOSE);
                this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
                Assert.fail((String)"No exeption thrown");
            }
            catch (ExecutionException executionException) {
                LTTngControlServiceTest.disableVerbose();
            }
        }
        finally {
            LTTngControlServiceTest.disableVerbose();
        }
    }

    @Test
    public void testGetSessionNameGarbage() {
        try {
            this.fShell.setScenario(SCEN_GET_SESSION_GARBAGE_OUT);
            List result = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)0L, (long)result.size());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetSession1() {
        try {
            this.fShell.setScenario(SCEN_GET_SESSION1);
            ISessionInfo session = this.fService.getSession("mysession", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((Object)"mysession", (Object)session.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120129-084256", (Object)session.getSessionPath());
            Assert.assertEquals((Object)TraceSessionState.ACTIVE, (Object)session.getSessionState());
            IDomainInfo[] domains = session.getDomains();
            Assert.assertNotNull((Object)domains);
            Assert.assertEquals((long)2L, (long)domains.length);
            Assert.assertEquals((Object)"Kernel", (Object)domains[0].getName());
            IChannelInfo[] channels = domains[0].getChannels();
            Assert.assertNotNull((Object)channels);
            Assert.assertEquals((long)2L, (long)channels.length);
            Assert.assertEquals((Object)"channel0", (Object)channels[0].getName());
            Assert.assertEquals((long)4L, (long)channels[0].getNumberOfSubBuffers());
            Assert.assertEquals((Object)"splice()", (Object)channels[0].getOutputType().getInName());
            Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channels[0].getOutputType());
            Assert.assertEquals((Object)false, (Object)channels[0].isOverwriteMode());
            Assert.assertEquals((long)200L, (long)channels[0].getReadTimer());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channels[0].getState());
            Assert.assertEquals((long)262144L, (long)channels[0].getSubBufferSize());
            Assert.assertEquals((long)0L, (long)channels[0].getSwitchTimer());
            IEventInfo[] channel0Events = channels[0].getEvents();
            Assert.assertNotNull((Object)channel0Events);
            Assert.assertEquals((long)2L, (long)channel0Events.length);
            Assert.assertEquals((Object)"block_rq_remap", (Object)channel0Events[0].getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)channel0Events[0].getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)channel0Events[0].getEventType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel0Events[0].getState());
            Assert.assertEquals((Object)"block_bio_remap", (Object)channel0Events[1].getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)channel0Events[1].getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)channel0Events[1].getEventType());
            Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)channel0Events[1].getState());
            Assert.assertEquals((Object)"channel1", (Object)channels[1].getName());
            Assert.assertEquals((long)4L, (long)channels[1].getNumberOfSubBuffers());
            Assert.assertEquals((Object)"splice()", (Object)channels[1].getOutputType().getInName());
            Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channels[1].getOutputType());
            Assert.assertEquals((Object)true, (Object)channels[1].isOverwriteMode());
            Assert.assertEquals((long)400L, (long)channels[1].getReadTimer());
            Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)channels[1].getState());
            Assert.assertEquals((long)524288L, (long)channels[1].getSubBufferSize());
            Assert.assertEquals((long)100L, (long)channels[1].getSwitchTimer());
            IEventInfo[] channel1Events = channels[1].getEvents();
            Assert.assertEquals((long)0L, (long)channel1Events.length);
            Assert.assertEquals((Object)"UST global", (Object)domains[1].getName());
            IChannelInfo[] ustChannels = domains[1].getChannels();
            Assert.assertEquals((Object)"mychannel1", (Object)ustChannels[0].getName());
            Assert.assertEquals((long)8L, (long)ustChannels[0].getNumberOfSubBuffers());
            Assert.assertEquals((Object)"mmap()", (Object)ustChannels[0].getOutputType().getInName());
            Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)ustChannels[0].getOutputType());
            Assert.assertEquals((Object)true, (Object)ustChannels[0].isOverwriteMode());
            Assert.assertEquals((long)100L, (long)ustChannels[0].getReadTimer());
            Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)ustChannels[0].getState());
            Assert.assertEquals((long)8192L, (long)ustChannels[0].getSubBufferSize());
            Assert.assertEquals((long)200L, (long)ustChannels[0].getSwitchTimer());
            IEventInfo[] ustEvents = ustChannels[0].getEvents();
            Assert.assertEquals((long)0L, (long)ustEvents.length);
            Assert.assertEquals((Object)"channel0", (Object)ustChannels[1].getName());
            Assert.assertEquals((long)4L, (long)ustChannels[1].getNumberOfSubBuffers());
            Assert.assertEquals((Object)"mmap()", (Object)ustChannels[1].getOutputType().getInName());
            Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)ustChannels[1].getOutputType());
            Assert.assertEquals((Object)false, (Object)ustChannels[1].isOverwriteMode());
            Assert.assertEquals((long)200L, (long)ustChannels[1].getReadTimer());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)ustChannels[1].getState());
            Assert.assertEquals((long)4096L, (long)ustChannels[1].getSubBufferSize());
            Assert.assertEquals((long)0L, (long)ustChannels[1].getSwitchTimer());
            ustEvents = ustChannels[1].getEvents();
            Assert.assertEquals((long)2L, (long)ustEvents.length);
            Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)ustEvents[0].getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_LINE, (Object)ustEvents[0].getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)ustEvents[0].getEventType());
            Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)ustEvents[0].getState());
            Assert.assertEquals((Object)"*", (Object)ustEvents[1].getName());
            Assert.assertEquals((Object)this.getAllEventTraceLogLevel(), (Object)ustEvents[1].getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)ustEvents[1].getEventType());
            Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)ustEvents[1].getState());
            session = this.fService.getSession("mysession1", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((Object)"mysession1", (Object)session.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession1-20120203-133225", (Object)session.getSessionPath());
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
            domains = session.getDomains();
            Assert.assertNotNull((Object)domains);
            Assert.assertEquals((long)0L, (long)domains.length);
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    @Ignore
    public void testGetSessionWithLive() {
        try {
            this.fShell.setScenario(SCEN_GET_SESSION_WITH_LIVE);
            ISessionInfo session = this.fService.getSession("mysession", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((Object)"mysession", (Object)session.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120129-084256", (Object)session.getSessionPath());
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
            Assert.assertFalse((boolean)session.isLive());
            session = this.fService.getSession("mysession1", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((Object)"mysession1", (Object)session.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession1-20120129-084256", (Object)session.getSessionPath());
            Assert.assertEquals((Object)TraceSessionState.ACTIVE, (Object)session.getSessionState());
            Assert.assertFalse((boolean)session.isLive());
            session = this.fService.getSession("mysession2", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((Object)"mysession2", (Object)session.getName());
            Assert.assertEquals((Object)"tcp4://172.0.0.1:5342/ [data: 5343]", (Object)session.getSessionPath());
            Assert.assertEquals((Object)"net://127.0.0.1", (Object)session.getLiveUrl());
            Assert.assertEquals((Object)5344, (Object)session.getLivePort());
            Assert.assertEquals((long)1000000L, (long)session.getLiveDelay());
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
            Assert.assertTrue((boolean)session.isLive());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    protected TraceLogLevel getAllEventTraceLogLevel() {
        return TraceLogLevel.LEVEL_UNKNOWN;
    }

    public void testGetKernelProvider() {
        try {
            this.fShell.setScenario(SCEN_GET_KERNEL_PROVIDER1);
            List events = this.fService.getKernelProvider((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)events);
            Assert.assertEquals((long)3L, (long)events.size());
            IBaseEventInfo baseEventInfo = (IBaseEventInfo)events.get(0);
            Assert.assertNotNull((Object)baseEventInfo);
            Assert.assertEquals((Object)"sched_kthread_stop", (Object)baseEventInfo.getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)baseEventInfo.getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
            baseEventInfo = (IBaseEventInfo)events.get(1);
            Assert.assertEquals((Object)"sched_kthread_stop_ret", (Object)baseEventInfo.getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)baseEventInfo.getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
            baseEventInfo = (IBaseEventInfo)events.get(2);
            Assert.assertEquals((Object)"sched_wakeup_new", (Object)baseEventInfo.getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)baseEventInfo.getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetKernelProviderNoKernel1() {
        try {
            this.fShell.setScenario(SCEN_LIST_WITH_NO_KERNEL1);
            List events = this.fService.getKernelProvider((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)events);
            Assert.assertEquals((long)0L, (long)events.size());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetKernelProviderNoKernel2() {
        try {
            this.fShell.setScenario(SCEN_LIST_WITH_NO_KERNEL2);
            List events = this.fService.getKernelProvider((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)events);
            Assert.assertEquals((long)0L, (long)events.size());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetKernelProviderNoKernelVerbose() {
        try {
            try {
                LTTngControlServiceTest.enableVerbose();
                this.fShell.setScenario(SCEN_LIST_WITH_NO_KERNEL_VERBOSE);
                List events = this.fService.getKernelProvider((IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((Object)events);
                Assert.assertEquals((long)0L, (long)events.size());
            }
            catch (ExecutionException e) {
                Assert.fail((String)e.toString());
                LTTngControlServiceTest.disableVerbose();
            }
        }
        finally {
            LTTngControlServiceTest.disableVerbose();
        }
    }

    @Test
    public void testGetUstProvider() {
        try {
            this.fShell.setScenario(SCEN_GET_UST_PROVIDER1);
            List providers = this.fService.getUstProvider();
            Assert.assertNotNull((Object)providers);
            Assert.assertEquals((long)2L, (long)providers.size());
            Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello", (Object)((IUstProviderInfo)providers.get(0)).getName());
            Assert.assertEquals((long)9379L, (long)((IUstProviderInfo)providers.get(0)).getPid());
            IBaseEventInfo[] events = ((IUstProviderInfo)providers.get(0)).getEvents();
            Assert.assertNotNull((Object)events);
            Assert.assertEquals((long)2L, (long)events.length);
            IBaseEventInfo baseEventInfo = events[0];
            Assert.assertNotNull((Object)baseEventInfo);
            Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)baseEventInfo.getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_MODULE, (Object)baseEventInfo.getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
            baseEventInfo = events[1];
            Assert.assertEquals((Object)"ust_tests_hello:tptest", (Object)baseEventInfo.getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_INFO, (Object)baseEventInfo.getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
            Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello", (Object)((IUstProviderInfo)providers.get(1)).getName());
            Assert.assertEquals((long)4852L, (long)((IUstProviderInfo)providers.get(1)).getPid());
            events = ((IUstProviderInfo)providers.get(1)).getEvents();
            Assert.assertNotNull((Object)events);
            Assert.assertEquals((long)2L, (long)events.length);
            baseEventInfo = events[0];
            Assert.assertNotNull((Object)baseEventInfo);
            Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)baseEventInfo.getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_WARNING, (Object)baseEventInfo.getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
            baseEventInfo = events[1];
            Assert.assertEquals((Object)"ust_tests_hello:tptest", (Object)baseEventInfo.getName());
            Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_FUNCTION, (Object)baseEventInfo.getLogLevel());
            Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testUstProvider2() {
        try {
            this.fShell.setScenario(SCEN_GET_UST_PROVIDER2);
            List providers = this.fService.getUstProvider();
            Assert.assertNotNull((Object)providers);
            Assert.assertEquals((long)0L, (long)providers.size());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetUstProvider3() {
        try {
            this.fShell.setScenario(SCEN_GET_UST_PROVIDER3);
            ((LTTngControlService)this.fService).setVersion("2.1.0");
            List providers = this.fService.getUstProvider();
            Assert.assertNotNull((Object)providers);
            Assert.assertEquals((long)2L, (long)providers.size());
            Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello", (Object)((IUstProviderInfo)providers.get(0)).getName());
            Assert.assertEquals((long)9379L, (long)((IUstProviderInfo)providers.get(0)).getPid());
            IBaseEventInfo[] events = ((IUstProviderInfo)providers.get(0)).getEvents();
            Assert.assertNotNull((Object)events);
            Assert.assertEquals((long)2L, (long)events.length);
            IBaseEventInfo baseEventInfo = events[0];
            Assert.assertNotNull((Object)baseEventInfo);
            IFieldInfo[] fields = baseEventInfo.getFields();
            Assert.assertNotNull((Object)fields);
            Assert.assertEquals((long)0L, (long)fields.length);
            baseEventInfo = events[1];
            fields = baseEventInfo.getFields();
            Assert.assertNotNull((Object)fields);
            Assert.assertEquals((long)3L, (long)fields.length);
            Assert.assertEquals((Object)"doublefield", (Object)fields[0].getName());
            Assert.assertEquals((Object)"float", (Object)fields[0].getFieldType());
            Assert.assertEquals((Object)"floatfield", (Object)fields[1].getName());
            Assert.assertEquals((Object)"float", (Object)fields[1].getFieldType());
            Assert.assertEquals((Object)"stringfield", (Object)fields[2].getName());
            Assert.assertEquals((Object)"string", (Object)fields[2].getFieldType());
            Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello", (Object)((IUstProviderInfo)providers.get(1)).getName());
            Assert.assertEquals((long)4852L, (long)((IUstProviderInfo)providers.get(1)).getPid());
            events = ((IUstProviderInfo)providers.get(1)).getEvents();
            Assert.assertNotNull((Object)events);
            Assert.assertEquals((long)2L, (long)events.length);
            baseEventInfo = events[0];
            Assert.assertNotNull((Object)baseEventInfo);
            fields = baseEventInfo.getFields();
            Assert.assertNotNull((Object)fields);
            Assert.assertEquals((long)0L, (long)fields.length);
            baseEventInfo = events[1];
            fields = baseEventInfo.getFields();
            Assert.assertNotNull((Object)fields);
            Assert.assertEquals((long)3L, (long)fields.length);
            Assert.assertEquals((Object)"doublefield", (Object)fields[0].getName());
            Assert.assertEquals((Object)"float", (Object)fields[0].getFieldType());
            Assert.assertEquals((Object)"floatfield", (Object)fields[1].getName());
            Assert.assertEquals((Object)"float", (Object)fields[1].getFieldType());
            Assert.assertEquals((Object)"stringfield", (Object)fields[2].getName());
            Assert.assertEquals((Object)"string", (Object)fields[2].getFieldType());
            ((LTTngControlService)this.fService).setVersion("2.0.0");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetKernelProviderNoUst1() {
        try {
            this.fShell.setScenario(SCEN_LIST_WITH_NO_UST1);
            List providerList = this.fService.getUstProvider((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)providerList);
            Assert.assertEquals((long)0L, (long)providerList.size());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetKernelProviderNoUst2() {
        try {
            ((LTTngControlService)this.fService).setVersion("2.1.0");
            this.fShell.setScenario(SCEN_LIST_WITH_NO_UST2);
            List providerList = this.fService.getUstProvider((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)providerList);
            Assert.assertEquals((long)0L, (long)providerList.size());
            ((LTTngControlService)this.fService).setVersion("2.0.0");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetKernelProviderNoUst3() {
        try {
            ((LTTngControlService)this.fService).setVersion("2.1.0");
            this.fShell.setScenario(SCEN_LIST_WITH_NO_UST3);
            List providerList = this.fService.getUstProvider((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)providerList);
            Assert.assertEquals((long)0L, (long)providerList.size());
            ((LTTngControlService)this.fService).setVersion("2.0.0");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testGetKernelProviderNoUstVerbose() {
        try {
            try {
                LTTngControlServiceTest.enableVerbose();
                ((LTTngControlService)this.fService).setVersion("2.1.0");
                this.fShell.setScenario(SCEN_LIST_WITH_NO_UST_VERBOSE);
                List providerList = this.fService.getUstProvider((IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((Object)providerList);
                Assert.assertEquals((long)0L, (long)providerList.size());
                ((LTTngControlService)this.fService).setVersion("2.0.0");
            }
            catch (ExecutionException e) {
                Assert.fail((String)e.toString());
                LTTngControlServiceTest.disableVerbose();
            }
        }
        finally {
            LTTngControlServiceTest.disableVerbose();
        }
    }

    @Test
    public void testCreateSession() {
        try {
            this.fShell.setScenario(SCEN_CREATE_SESSION1);
            ISessionInfo info = this.fService.createSession((ISessionInfo)new SessionInfo("mysession2"), (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession2", (Object)info.getName());
            Assert.assertNotNull((Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.getSessionPath().contains("mysession2"));
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)info.getSessionState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateSessionWithPrompt() {
        try {
            this.fShell.setScenario(SCEN_CREATE_SESSION_WITH_PROMPT);
            ISessionInfo info = this.fService.createSession((ISessionInfo)new SessionInfo("mysession2"), (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession2", (Object)info.getName());
            Assert.assertNotNull((Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.getSessionPath().contains("mysession2"));
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)info.getSessionState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateSessionVariants() {
        SessionInfo sessionInfo;
        this.fShell.setScenario(SCEN_CREATE_SESSION_VARIANTS);
        try {
            this.fService.createSession((ISessionInfo)new SessionInfo("alreadyExist"), (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"No exeption thrown");
        }
        catch (ExecutionException executionException) {}
        try {
            this.fService.createSession((ISessionInfo)new SessionInfo("wrongName"), (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"No exeption thrown");
        }
        catch (ExecutionException executionException) {}
        try {
            sessionInfo = new SessionInfo("withPath");
            sessionInfo.setSessionPath("/home/user/hallo");
            this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"No exeption thrown");
        }
        catch (ExecutionException executionException) {}
        try {
            ISessionInfo info = this.fService.createSession((ISessionInfo)new SessionInfo("session with spaces"), (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"session with spaces", (Object)info.getName());
            Assert.assertNotNull((Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.getSessionPath().contains("session with spaces"));
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)info.getSessionState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
        try {
            sessionInfo = new SessionInfo("pathWithSpaces");
            sessionInfo.setSessionPath("/home/user/hallo user/here");
            ISessionInfo info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"pathWithSpaces", (Object)info.getName());
            Assert.assertNotNull((Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.getSessionPath().contains("/home/user/hallo user/here"));
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)info.getSessionState());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testDestroySession() {
        try {
            this.fShell.setScenario(SCEN_DESTROY_SESSION1);
            this.fService.destroySession("mysession2", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testDestroySessionVerbose() {
        try {
            try {
                LTTngControlServiceTest.enableVerbose();
                this.fShell.setScenario(SCEN_DESTROY_SESSION_VERBOSE);
                this.fService.destroySession("mysession2", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                Assert.fail((String)e.toString());
                LTTngControlServiceTest.disableVerbose();
            }
        }
        finally {
            LTTngControlServiceTest.disableVerbose();
        }
    }

    @Test
    public void testCreateChannel() {
        try {
            ((LTTngControlService)this.fService).setVersion("2.2.0");
            String sessionName = "mysession2";
            ArrayList<String> list = new ArrayList<String>();
            String kernelChannel0 = "mychannel0";
            String kernelChannel1 = "mychannel1";
            list.add(kernelChannel0);
            list.add(kernelChannel1);
            this.fShell.setScenario(SCEN_CHANNEL_HANDLING);
            ChannelInfo chanInfo = new ChannelInfo("");
            chanInfo.setOverwriteMode(true);
            chanInfo.setSubBufferSize(16384L);
            chanInfo.setReadTimer(100L);
            chanInfo.setSwitchTimer(200L);
            chanInfo.setNumberOfSubBuffers(2);
            chanInfo.setMaxNumberTraceFiles(10);
            chanInfo.setMaxSizeTraceFiles(0L);
            this.fService.enableChannels(sessionName, list, TraceDomainType.KERNEL, (IChannelInfo)chanInfo, (IProgressMonitor)new NullProgressMonitor());
            list.clear();
            list.add("ustChannel");
            chanInfo = new ChannelInfo("");
            chanInfo.setOverwriteMode(true);
            chanInfo.setSubBufferSize(32768L);
            chanInfo.setReadTimer(200L);
            chanInfo.setSwitchTimer(100L);
            chanInfo.setNumberOfSubBuffers(1);
            chanInfo.setMaxNumberTraceFiles(20);
            chanInfo.setMaxSizeTraceFiles(0L);
            this.fService.enableChannels(sessionName, list, TraceDomainType.UST, (IChannelInfo)chanInfo, (IProgressMonitor)new NullProgressMonitor());
            ((LTTngControlService)this.fService).setVersion("2.0.0");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateChannelUIDBuffer() {
        try {
            ((LTTngControlService)this.fService).setVersion("2.2.0");
            String sessionName = "mysession2";
            ArrayList<String> list = new ArrayList<String>();
            String USTChannel = "ustChannel";
            list.add(USTChannel);
            this.fShell.setScenario(SCEN_CHANNEL_HANDLING);
            ChannelInfo chanInfo = new ChannelInfo("");
            chanInfo.setOverwriteMode(true);
            chanInfo.setSubBufferSize(32768L);
            chanInfo.setReadTimer(200L);
            chanInfo.setSwitchTimer(100L);
            chanInfo.setNumberOfSubBuffers(1);
            chanInfo.setMaxNumberTraceFiles(20);
            chanInfo.setMaxSizeTraceFiles(0L);
            chanInfo.setBufferType(BufferType.BUFFER_PER_UID);
            this.fService.enableChannels(sessionName, list, TraceDomainType.UST, (IChannelInfo)chanInfo, (IProgressMonitor)new NullProgressMonitor());
            ((LTTngControlService)this.fService).setVersion("2.0.0");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateChannelPIDBuffer() {
        try {
            ((LTTngControlService)this.fService).setVersion("2.2.0");
            String sessionName = "mysession2";
            ArrayList<String> list = new ArrayList<String>();
            String USTChannel = "ustChannel";
            list.add(USTChannel);
            this.fShell.setScenario(SCEN_CHANNEL_HANDLING);
            ChannelInfo chanInfo = new ChannelInfo("");
            chanInfo.setOverwriteMode(true);
            chanInfo.setSubBufferSize(-1L);
            chanInfo.setReadTimer(-1L);
            chanInfo.setSwitchTimer(-1L);
            chanInfo.setNumberOfSubBuffers(-1);
            chanInfo.setMaxNumberTraceFiles(-1);
            chanInfo.setMaxSizeTraceFiles(-1L);
            chanInfo.setBufferType(BufferType.BUFFER_PER_PID);
            this.fService.enableChannels(sessionName, list, TraceDomainType.UST, (IChannelInfo)chanInfo, (IProgressMonitor)new NullProgressMonitor());
            ((LTTngControlService)this.fService).setVersion("2.0.0");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testDisableChannel() {
        try {
            String sessionName = "mysession2";
            ArrayList<String> list = new ArrayList<String>();
            String kernelChannel0 = "mychannel0";
            String kernelChannel1 = "mychannel1";
            list.add(kernelChannel0);
            list.add(kernelChannel1);
            this.fShell.setScenario(SCEN_CHANNEL_HANDLING);
            this.fService.disableChannels(sessionName, list, TraceDomainType.KERNEL, (IProgressMonitor)new NullProgressMonitor());
            list.clear();
            list.add("ustChannel");
            this.fService.disableChannels(sessionName, list, TraceDomainType.UST, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testEnableChannel() {
        try {
            String sessionName = "mysession2";
            ArrayList<String> list = new ArrayList<String>();
            String kernelChannel0 = "mychannel0";
            String kernelChannel1 = "mychannel1";
            list.add(kernelChannel0);
            list.add(kernelChannel1);
            this.fShell.setScenario(SCEN_CHANNEL_HANDLING);
            this.fService.enableChannels(sessionName, list, TraceDomainType.KERNEL, null, (IProgressMonitor)new NullProgressMonitor());
            list.clear();
            list.add("ustChannel");
            this.fService.enableChannels(sessionName, list, TraceDomainType.UST, null, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testEnableEvents() {
        try {
            String sessionName = "mysession2";
            String channelName = "mychannel";
            ArrayList<String> eventList = new ArrayList<String>();
            ArrayList<String> excludeList = new ArrayList<String>();
            String eventName0 = "block_rq_remap";
            String eventName1 = "block_bio_remap";
            String eventName2 = "softirq_entry";
            String ustEventName0 = "ust_tests_hello:tptest_sighandler";
            String ustEventName1 = "ust_tests_bye:tptest_sighandler";
            String ustEventWildcard = "ust*";
            this.fShell.setScenario(SCEN_EVENT_HANDLING);
            eventList.add(eventName0);
            eventList.add(eventName1);
            eventList.add(eventName2);
            this.fService.enableEvents(sessionName, null, eventList, TraceDomainType.KERNEL, null, null, (IProgressMonitor)new NullProgressMonitor());
            this.fService.enableEvents(sessionName, channelName, null, TraceDomainType.KERNEL, null, null, (IProgressMonitor)new NullProgressMonitor());
            eventList.clear();
            eventList.add(ustEventName0);
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, null, null, (IProgressMonitor)new NullProgressMonitor());
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, "intfield==10", null, (IProgressMonitor)new NullProgressMonitor());
            eventList.clear();
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, null, null, (IProgressMonitor)new NullProgressMonitor());
            this.fService.enableEvents(sessionName, null, ILttngControlService.ALL_EVENTS, TraceDomainType.KERNEL, null, null, (IProgressMonitor)new NullProgressMonitor());
            excludeList.add(ustEventName0);
            this.fService.enableEvents(sessionName, channelName, null, TraceDomainType.UST, null, excludeList, (IProgressMonitor)new NullProgressMonitor());
            excludeList.add(ustEventName1);
            this.fService.enableEvents(sessionName, channelName, null, TraceDomainType.UST, null, excludeList, (IProgressMonitor)new NullProgressMonitor());
            eventList.add(ustEventWildcard);
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, null, excludeList, (IProgressMonitor)new NullProgressMonitor());
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, "ust==\"Challenger\"", excludeList, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testEnableJulLoggers() {
    }

    @Test
    public void testEnableLog4jLoggers() {
    }

    @Test
    public void testEnablePythonLoggers() {
    }

    @Test
    public void testEventExcluded() {
        try {
            String sessionName = "mysession2";
            String channelName = "mychannel";
            ArrayList<String> eventList = new ArrayList<String>();
            ArrayList<String> excludeList = new ArrayList<String>();
            String ustEventName0 = "ust_tests_hello:tptest_sighandler";
            String ustEventName1 = "ust_tests_bye:tptest_sighandler";
            String ustEventWildcard = "ust*";
            @NonNull LttngVersion version = this.fService.getVersion();
            this.fShell.setScenario(SCEN_EVENT_EXCLUDED);
            eventList.add(ustEventWildcard);
            excludeList.add(ustEventName0);
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, null, excludeList, (IProgressMonitor)new NullProgressMonitor());
            @Nullable ISessionInfo session = this.fService.getSession(sessionName, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            IEventInfo eventInfo = session.getDomains()[0].getChannels()[0].getEvents()[0];
            Assert.assertNotNull((Object)eventInfo);
            if (version.getMajor() > 1 && version.getMinor() > 7) {
                Assert.assertTrue((boolean)eventInfo.getExcludedEvents().contains(ustEventName0));
            } else {
                Assert.assertEquals((Object)"has exclusions", (Object)eventInfo.getExcludedEvents());
            }
            excludeList.add(ustEventName1);
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, null, excludeList, (IProgressMonitor)new NullProgressMonitor());
            session = this.fService.getSession(sessionName, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            eventInfo = session.getDomains()[0].getChannels()[0].getEvents()[0];
            Assert.assertNotNull((Object)eventInfo);
            if (version.getMajor() > 1 && version.getMinor() > 7) {
                Assert.assertTrue((boolean)eventInfo.getExcludedEvents().contains(ustEventName0));
                Assert.assertTrue((boolean)eventInfo.getExcludedEvents().contains(ustEventName1));
            } else {
                Assert.assertEquals((Object)"has exclusions", (Object)eventInfo.getExcludedEvents());
            }
            this.fService.enableEvents(sessionName, channelName, eventList, TraceDomainType.UST, "ust==\"Challenger\"", excludeList, (IProgressMonitor)new NullProgressMonitor());
            session = this.fService.getSession(sessionName, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)session);
            eventInfo = session.getDomains()[0].getChannels()[0].getEvents()[0];
            Assert.assertNotNull((Object)eventInfo);
            if (version.getMajor() > 1 && version.getMinor() > 7) {
                Assert.assertTrue((boolean)eventInfo.getExcludedEvents().contains(ustEventName0));
                Assert.assertTrue((boolean)eventInfo.getExcludedEvents().contains(ustEventName1));
            } else {
                Assert.assertEquals((Object)"has exclusions", (Object)eventInfo.getExcludedEvents());
            }
            if (version.getMajor() > 1 && version.getMinor() > 7) {
                Assert.assertTrue((boolean)eventInfo.getFilterExpression().equals("ust==Challenger"));
            } else {
                Assert.assertEquals((Object)"with filter", (Object)eventInfo.getFilterExpression());
            }
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testEnableSyscalls() {
        try {
            String sessionName = "mysession2";
            String channelName = "mychannel";
            ArrayList<String> syscalls = new ArrayList<String>();
            this.fShell.setScenario(SCEN_EVENT_HANDLING);
            this.fService.enableSyscalls(sessionName, null, null, (IProgressMonitor)new NullProgressMonitor());
            this.fService.enableSyscalls(sessionName, channelName, null, (IProgressMonitor)new NullProgressMonitor());
            syscalls.add("close");
            this.fService.enableSyscalls(sessionName, channelName, syscalls, (IProgressMonitor)new NullProgressMonitor());
            syscalls.add("read");
            syscalls.add("write");
            this.fService.enableSyscalls(sessionName, channelName, syscalls, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testDynamicProbe() {
        try {
            String sessionName = "mysession2";
            String channelName = "mychannel";
            String eventName0 = "myevent0";
            String eventName1 = "myevent1";
            String functionProbe = "0xc0101340";
            String dynProbe = "init_post";
            this.fShell.setScenario(SCEN_EVENT_HANDLING);
            this.fService.enableProbe(sessionName, null, eventName0, true, functionProbe, (IProgressMonitor)new NullProgressMonitor());
            this.fService.enableProbe(sessionName, channelName, eventName1, false, dynProbe, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testEnableLogLevel() {
        try {
            String sessionName = "mysession2";
            String channelName = "mychannel";
            String eventName4 = "myevent4";
            String eventName5 = "myevent5";
            this.fShell.setScenario(SCEN_EVENT_HANDLING);
            this.fService.enableLogLevel(sessionName, null, Arrays.asList(eventName4), LogLevelType.LOGLEVEL_ONLY, (ITraceLogLevel)TraceLogLevel.TRACE_DEBUG, null, TraceDomainType.UST, (IProgressMonitor)new NullProgressMonitor());
            this.fService.enableLogLevel(sessionName, channelName, Arrays.asList(eventName5), LogLevelType.LOGLEVEL, (ITraceLogLevel)TraceLogLevel.TRACE_DEBUG_FUNCTION, null, TraceDomainType.UST, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testAddContext() {
        try {
            String sessionName = "mysession2";
            String channelName = "mychannel";
            String eventName = "ust_tests_hello:tptest_sighandler";
            ArrayList<String> contexts = new ArrayList<String>();
            contexts.add("prio");
            contexts.add("pid");
            this.fShell.setScenario(SCEN_CONTEXT_HANDLING);
            List availContexts = this.fService.getContextList((IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)availContexts);
            Assert.assertEquals((long)12L, (long)availContexts.size());
            HashSet<String> expectedContexts = new HashSet<String>();
            expectedContexts.add("pid");
            expectedContexts.add("procname");
            expectedContexts.add("prio");
            expectedContexts.add("nice");
            expectedContexts.add("vpid");
            expectedContexts.add("tid");
            expectedContexts.add("pthread_id");
            expectedContexts.add("vtid");
            expectedContexts.add("ppid");
            expectedContexts.add("vppid");
            expectedContexts.add("perf:cpu-cycles");
            expectedContexts.add("perf:cycles");
            Assert.assertTrue((boolean)expectedContexts.containsAll(availContexts));
            this.fService.addContexts(sessionName, channelName, eventName, TraceDomainType.UST, contexts, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testAddContextFailure() {
        String sessionName = "mysession2";
        String channelName = "mychannel";
        String eventName = "ust_tests_hello:tptest_sighandler";
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.add("prio");
        contexts.add("pid");
        this.fShell.setScenario(SCEN_CONTEXT_ERROR_HANDLING);
        try {
            this.fService.getContextList((IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"No exeption generated");
        }
        catch (ExecutionException executionException) {}
        try {
            this.fService.addContexts(sessionName, channelName, eventName, TraceDomainType.UST, contexts, (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"No exeption generated");
        }
        catch (ExecutionException executionException) {}
    }

    @Test
    public void testCreateSession2_1() {
        try {
            this.fShell.setScenario(SCEN_CREATE_SESSION_2_1);
            SessionInfo sessionInfo = new SessionInfo("mysession");
            sessionInfo.setNetworkUrl("net://172.0.0.1");
            sessionInfo.setStreamedTrace(true);
            ISessionInfo info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession", (Object)info.getName());
            Assert.assertEquals((Object)"net://172.0.0.1", (Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.isStreamedTrace());
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
            sessionInfo = new SessionInfo("mysession");
            sessionInfo.setStreamedTrace(true);
            sessionInfo.setNetworkUrl("file:///tmp");
            info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession", (Object)info.getName());
            Assert.assertEquals((Object)"file:///tmp", (Object)info.getSessionPath());
            Assert.assertTrue((!info.isStreamedTrace() ? 1 : 0) != 0);
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
            sessionInfo = new SessionInfo("mysession");
            sessionInfo.setStreamedTrace(true);
            sessionInfo.setNetworkUrl("file:///tmp");
            info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession", (Object)info.getName());
            Assert.assertEquals((Object)"file:///tmp", (Object)info.getSessionPath());
            Assert.assertTrue((!info.isStreamedTrace() ? 1 : 0) != 0);
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
            sessionInfo = new SessionInfo("mysession");
            sessionInfo.setStreamedTrace(true);
            sessionInfo.setControlUrl("tcp://172.0.0.1");
            sessionInfo.setDataUrl("tcp://172.0.0.1:5343");
            info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession", (Object)info.getName());
            Assert.assertEquals((Object)"", (Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.isStreamedTrace());
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
            sessionInfo = new SessionInfo("mysession");
            sessionInfo.setStreamedTrace(true);
            sessionInfo.setNetworkUrl("net://172.0.0.1:1234:2345");
            info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession", (Object)info.getName());
            Assert.assertEquals((Object)"net://172.0.0.1:1234:2345", (Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.isStreamedTrace());
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
            LTTngControlServiceTest.enableVerbose();
            sessionInfo = new SessionInfo("mysession");
            sessionInfo.setStreamedTrace(true);
            sessionInfo.setNetworkUrl("net://172.0.0.1");
            info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)"mysession", (Object)info.getName());
            Assert.assertEquals((Object)"net://172.0.0.1", (Object)info.getSessionPath());
            Assert.assertTrue((boolean)info.isStreamedTrace());
            LTTngControlServiceTest.disableVerbose();
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateSessionVerbose2_1() {
        try {
            try {
                this.fShell.setScenario(SCEN_CREATE_SESSION_VERBOSE_2_1);
                LTTngControlServiceTest.enableVerbose();
                SessionInfo sessionInfo = new SessionInfo("mysession");
                sessionInfo.setStreamedTrace(true);
                sessionInfo.setNetworkUrl("net://172.0.0.1");
                ISessionInfo info = this.fService.createSession((ISessionInfo)sessionInfo, (IProgressMonitor)new NullProgressMonitor());
                Assert.assertNotNull((Object)info);
                Assert.assertEquals((Object)"mysession", (Object)info.getName());
                Assert.assertEquals((Object)"net://172.0.0.1", (Object)info.getSessionPath());
                Assert.assertTrue((boolean)info.isStreamedTrace());
                this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                Assert.fail((String)e.toString());
                LTTngControlServiceTest.disableVerbose();
            }
        }
        finally {
            LTTngControlServiceTest.disableVerbose();
        }
    }

    @Test
    public void testCreateSnapshotSession() {
        try {
            this.fShell.setScenario(SCEN_CREATE_SNAPSHOT_SESSION);
            SessionInfo params = new SessionInfo("mysession");
            params.setSnapshot(true);
            ISessionInfo sessionInfo = this.fService.createSession((ISessionInfo)params, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)sessionInfo);
            Assert.assertEquals((Object)"mysession", (Object)sessionInfo.getName());
            Assert.assertTrue((boolean)sessionInfo.isSnapshotSession());
            Assert.assertEquals((Object)"", (Object)sessionInfo.getSessionPath());
            Assert.assertTrue((!sessionInfo.isStreamedTrace() ? 1 : 0) != 0);
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)sessionInfo.getSessionState());
            List names = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals(names.get(0), (Object)"mysession");
            ISnapshotInfo snapshotInfo = this.fService.getSnapshotInfo("mysession", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)snapshotInfo);
            Assert.assertEquals((Object)"snapshot-1", (Object)snapshotInfo.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20130913-141651", (Object)snapshotInfo.getSnapshotPath());
            Assert.assertEquals((long)1L, (long)snapshotInfo.getId());
            Assert.assertTrue((!snapshotInfo.isStreamedSnapshot() ? 1 : 0) != 0);
            sessionInfo.setSnapshotInfo(snapshotInfo);
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20130913-141651", (Object)sessionInfo.getSessionPath());
            this.fService.recordSnapshot("mysession", (IProgressMonitor)new NullProgressMonitor());
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateSnapshotSession2_5() {
        try {
            this.fShell.setScenario(SCEN_CREATE_SNAPSHOT_SESSION_2_5);
            SessionInfo params = new SessionInfo("mysession");
            params.setSnapshot(true);
            ISessionInfo sessionInfo = this.fService.createSession((ISessionInfo)params, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)sessionInfo);
            Assert.assertEquals((Object)"mysession", (Object)sessionInfo.getName());
            Assert.assertTrue((boolean)sessionInfo.isSnapshotSession());
            Assert.assertEquals((Object)"", (Object)sessionInfo.getSessionPath());
            Assert.assertTrue((!sessionInfo.isStreamedTrace() ? 1 : 0) != 0);
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)sessionInfo.getSessionState());
            List names = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals(names.get(0), (Object)"mysession");
            ISnapshotInfo snapshotInfo = this.fService.getSnapshotInfo("mysession", (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)snapshotInfo);
            Assert.assertEquals((Object)"snapshot-1", (Object)snapshotInfo.getName());
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20130913-141651", (Object)snapshotInfo.getSnapshotPath());
            Assert.assertEquals((long)1L, (long)snapshotInfo.getId());
            Assert.assertTrue((!snapshotInfo.isStreamedSnapshot() ? 1 : 0) != 0);
            sessionInfo.setSnapshotInfo(snapshotInfo);
            Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20130913-141651", (Object)sessionInfo.getSessionPath());
            this.fService.recordSnapshot("mysession", (IProgressMonitor)new NullProgressMonitor());
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    public void testCreateStreamedSnapshotSession() {
        try {
            this.fShell.setScenario(SCEN_CREATE_STREAMED_SNAPSHOT_SESSION);
            SessionInfo params = new SessionInfo("mysession");
            params.setNetworkUrl("net://172.0.0.1");
            ISessionInfo sessionInfo = this.fService.createSession((ISessionInfo)params, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertNotNull((Object)sessionInfo);
            Assert.assertEquals((Object)"mysession", (Object)sessionInfo.getName());
            Assert.assertTrue((boolean)sessionInfo.isSnapshotSession());
            Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)sessionInfo.getSessionState());
            Assert.assertTrue((boolean)sessionInfo.isStreamedTrace());
            List names = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals(names.get(0), (Object)"mysession");
            ISnapshotInfo snapshotInfo = sessionInfo.getSnapshotInfo();
            Assert.assertNotNull((Object)sessionInfo);
            Assert.assertEquals((Object)"snapshot-2", (Object)snapshotInfo.getName());
            Assert.assertEquals((Object)"net4://172.0.0.1:5342/", (Object)snapshotInfo.getSnapshotPath());
            Assert.assertEquals((long)2L, (long)snapshotInfo.getId());
            Assert.assertTrue((boolean)snapshotInfo.isStreamedSnapshot());
            sessionInfo.setSnapshotInfo(snapshotInfo);
            Assert.assertEquals((Object)"net4://172.0.0.1:5342/", (Object)sessionInfo.getSessionPath());
            this.fService.recordSnapshot("mysession", (IProgressMonitor)new NullProgressMonitor());
            this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testCreateSnapshotSessionErrors() {
        try {
            this.fShell.setScenario(SCEN_CREATE_SNAPSHOT_SESSION_ERRORS);
            List names = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals(names.get(0), (Object)"mysession");
        }
        catch (ExecutionException e) {
            Assert.fail((String)e.toString());
        }
        try {
            this.fService.getSnapshotInfo("blabla", (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"getSnapshoInfo() didn't fail");
        }
        catch (ExecutionException executionException) {}
        try {
            this.fService.recordSnapshot("blabla", (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"getSnapshoInfo() didn't fail");
        }
        catch (ExecutionException executionException) {}
        try {
            this.fService.recordSnapshot("mysession", (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"getSnapshoInfo() didn't fail");
        }
        catch (ExecutionException executionException) {}
    }

    @Test
    @Ignore
    public void testCreateLiveSession() throws ExecutionException {
        this.fShell.setScenario(SCEN_CREATE_LIVE_SESSION);
        SessionInfo params = new SessionInfo("mysession");
        params.setLive(true);
        params.setStreamedTrace(true);
        params.setNetworkUrl("net://127.0.0.1");
        ISessionInfo sessionInfo = this.fService.createSession((ISessionInfo)params, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)sessionInfo);
        Assert.assertEquals((Object)"mysession", (Object)sessionInfo.getName());
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)sessionInfo.getSessionState());
        Assert.assertTrue((boolean)sessionInfo.isStreamedTrace());
        Assert.assertTrue((boolean)sessionInfo.isLive());
        Assert.assertEquals((Object)"net://127.0.0.1", (Object)sessionInfo.getSessionPath());
        List names = this.fService.getSessionNames((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals(names.get(0), (Object)"mysession");
        this.fService.destroySession("mysession", (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    @Ignore
    public void testCreateLiveSessionErrors() {
        SessionInfo parameters;
        try {
            this.fShell.setScenario(SCEN_CREATE_LIVE_SESSION_ERRORS);
            parameters = new SessionInfo("mysession");
            parameters.setLive(true);
            parameters.setSnapshot(true);
            this.fService.createSession((ISessionInfo)parameters, (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"createSession() didn't fail");
        }
        catch (ExecutionException executionException) {}
        try {
            parameters = new SessionInfo("mysession");
            parameters.setNetworkUrl("blah");
            parameters.setLive(true);
            this.fService.createSession((ISessionInfo)parameters, (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"createSession() didn't fail");
        }
        catch (ExecutionException executionException) {}
        try {
            parameters = new SessionInfo("mysession");
            parameters.setControlUrl("net://127.0.0.1");
            parameters.setLive(true);
            this.fService.createSession((ISessionInfo)parameters, (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)"createSession() didn't fail");
        }
        catch (ExecutionException executionException) {}
    }

    @Test
    public void testSessionProfile() {
        this.fShell.setScenario(SCEN_SESSION_PROFILES);
        try {
            this.fService.loadSession("/home/user/.lttng/sessions/mysession.lttng", false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("load session failed: " + (Object)((Object)e)));
        }
        try {
            this.fService.loadSession("/home/user/.lttng/sessions/mysession.lttng", true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("load session failed: " + (Object)((Object)e)));
        }
        try {
            this.fService.saveSession(null, null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("save session failed: " + (Object)((Object)e)));
        }
        try {
            this.fService.saveSession("mysession", null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("save session failed: " + (Object)((Object)e)));
        }
        try {
            this.fService.saveSession("mysession", null, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("save session failed: " + (Object)((Object)e)));
        }
        try {
            this.fService.saveSession("mysession", "/tmp/test", true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            Assert.fail((String)("save session failed: " + (Object)((Object)e)));
        }
    }

    private static void enableVerbose() {
        ControlCommandLogger.init((String)ControlPreferences.getInstance().getLogfilePath(), (boolean)false);
        ControlPreferences.getInstance().getPreferenceStore().setDefault("trace.control.log.commands", true);
        ControlPreferences.getInstance().getPreferenceStore().setDefault("trace.control.verbose.level", "trace.control.verbose.level.vvv");
    }

    private static void disableVerbose() {
        ControlPreferences.getInstance().getPreferenceStore().setDefault("trace.control.log.commands", false);
    }
}

