/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.core;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.MessageInfo;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class ValidatorLauncher {
    private static ValidatorLauncher _launcher;

    private ValidatorLauncher() {
    }

    public static ValidatorLauncher getLauncher() {
        if (_launcher == null) {
            _launcher = new ValidatorLauncher();
        }
        return _launcher;
    }

    public void start(IValidationContext helper, IValidator validator, IReporter reporter) throws ValidationException {
        if (helper == null || validator == null || reporter == null) {
            return;
        }
        if (reporter.isCancelled()) {
            return;
        }
        if (helper.getURIs() == null || helper.getURIs().length == 0) {
            reporter.removeAllMessages(validator);
        }
        if (validator instanceof IValidatorJob) {
            ((IValidatorJob)validator).validateInJob(helper, reporter);
        } else {
            validator.validate(helper, reporter);
        }
        if (validator instanceof IValidatorJob) {
            ValidatorManager mgr = ValidatorManager.getManager();
            List<MessageInfo> list = mgr.getMessages((IValidatorJob)validator);
            for (MessageInfo info : list) {
                try {
                    TaskListUtility.addTask(info.getMessageOwnerId(), info.getResource(), info.getLocation(), info.getMsg().getId(), info.getText(), info.getMsg().getSeverity(), info.getMarkerId(), info.getTargetObjectName(), info.getMsg().getGroupName(), info.getMsg().getOffset(), info.getMsg().getLength());
                }
                catch (CoreException e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
            mgr.clearMessages((IValidatorJob)validator);
        }
    }
}

