/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfLostEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public class CtfTmfEventFactory {
    private static final CtfTmfEventFactory INSTANCE = new CtfTmfEventFactory();
    protected static final String NO_STREAM = "No stream";

    protected CtfTmfEventFactory() {
    }

    public static CtfTmfEventFactory instance() {
        return INSTANCE;
    }

    public CtfTmfEvent createEvent(CtfTmfTrace trace, IEventDefinition eventDef, @Nullable String fileName) {
        String reference;
        IEventDeclaration eventDecl = eventDef.getDeclaration();
        long ts = eventDef.getTimestamp();
        ITmfTimestamp timestamp = trace.createTimestamp(trace.timestampCyclesToNanos(ts));
        int sourceCPU = eventDef.getCPU();
        String string = reference = fileName == null ? NO_STREAM : fileName;
        if (eventDecl.getName().equals("Lost event")) {
            return CtfTmfEventFactory.createLostEvent(trace, eventDef, eventDecl, ts, timestamp, sourceCPU, reference);
        }
        return new CtfTmfEvent(trace, -1L, timestamp, reference, sourceCPU, eventDecl, eventDef);
    }

    protected static CtfTmfEvent createLostEvent(CtfTmfTrace trace, IEventDefinition eventDef, IEventDeclaration eventDecl, long ts, ITmfTimestamp timestamp, int sourceCPU, String fileName) {
        Definition nbLostEventsDef = eventDef.getFields().getDefinition("Lost events");
        Definition durationDef = eventDef.getFields().getDefinition("duration");
        if (!(nbLostEventsDef instanceof IntegerDefinition) || !(durationDef instanceof IntegerDefinition)) {
            return CtfTmfEventFactory.getNullEvent(trace);
        }
        long nbLostEvents = ((IntegerDefinition)nbLostEventsDef).getValue();
        long duration = ((IntegerDefinition)durationDef).getValue();
        ITmfTimestamp timestampEnd = trace.createTimestamp(trace.timestampCyclesToNanos(ts) + trace.timestampCyclesToNanos(duration - trace.getOffset()));
        CtfTmfLostEvent lostEvent = new CtfTmfLostEvent(trace, -1L, fileName, sourceCPU, eventDecl, new TmfTimeRange(timestamp, timestampEnd), nbLostEvents, eventDef);
        return lostEvent;
    }

    public static CtfTmfEvent getNullEvent(CtfTmfTrace trace) {
        return new CtfTmfEvent(trace);
    }
}

