/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.projection;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.projection.IProjectionPosition;

public abstract class AbstractStructuredFoldingPosition
extends Position
implements IProjectionPosition {
    public AbstractStructuredFoldingPosition(int offset, int length) {
        super(offset, length);
    }

    public int computeCaptionOffset(IDocument document) throws BadLocationException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
        int foldEndOffset;
        int foldOffset;
        int startLineNum = document.getLineOfOffset(this.getStartOffset()) + 1;
        IRegion startLine = document.getLineInformation(startLineNum);
        int endLineNum = document.getLineOfOffset(this.getEndOffset()) + 1;
        IRegion endLine = document.getLineInformation(endLineNum);
        AbstractStructuredFoldingPosition abstractStructuredFoldingPosition = this;
        synchronized (abstractStructuredFoldingPosition) {
            foldOffset = startLine.getOffset();
            if (foldOffset < this.offset) {
                this.offset = foldOffset;
            }
            if ((foldEndOffset = endLine.getOffset()) - this.offset > this.length) {
                this.length = foldEndOffset - this.offset;
            }
        }
        return new IRegion[]{new Region(foldOffset, foldEndOffset - foldOffset)};
    }

    protected abstract int getStartOffset();

    protected abstract int getEndOffset();
}

