/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.lami.core;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.tracecompass.common.core.TraceCompassActivator;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.LamiConfigUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisFactoryException;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisFactoryFromConfigFile;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.OnDemandAnalysisManager;

public class Activator
extends TraceCompassActivator {
    private static final String PLUGIN_ID = "org.eclipse.tracecompass.analysis.lami.core";

    public static Activator instance() {
        return (Activator)TraceCompassActivator.getInstance((String)PLUGIN_ID);
    }

    public Activator() {
        super(PLUGIN_ID);
    }

    private void loadUserDefinedAnalyses() {
        Path configDirPath = LamiConfigUtils.getConfigDirPath();
        try {
            List<LamiAnalysis> analyses = LamiAnalysisFactoryFromConfigFile.buildFromConfigDir(configDirPath, true, trace -> true);
            OnDemandAnalysisManager manager = OnDemandAnalysisManager.getInstance();
            analyses.forEach(arg_0 -> ((OnDemandAnalysisManager)manager).registerAnalysis(arg_0));
        }
        catch (LamiAnalysisFactoryException e) {
            this.logWarning("Cannot load user-defined external analyses", e);
        }
    }

    protected void startActions() {
        this.loadUserDefinedAnalyses();
    }

    protected void stopActions() {
    }
}

