/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem.TestValues;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public abstract class StateSystemTest {
    @Rule
    public TestRule timeoutRule = new Timeout(2L, TimeUnit.MINUTES);
    protected static final @NonNull CtfTestTrace testTrace = CtfTestTrace.TRACE2;
    protected static final long startTime = 1331668247314038062L;
    protected static final long endTime = 1331668259054285979L;
    protected static final long interestingTimestamp1 = 1331668248014184527L;
    private static final long NANOSECS_PER_SEC = 1000000000L;
    protected static ITmfStateSystem fixture;

    @Before
    public void setUp() {
        Assert.assertNotNull((Object)fixture);
    }

    @Test
    public void testFullQuery1() {
        try {
            List list = fixture.queryFullState(1331668248014184527L);
            int quark = fixture.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            ITmfStateInterval interval = (ITmfStateInterval)list.get(quark);
            int valueInt = interval.getStateValue().unboxInt();
            Assert.assertEquals((long)1397L, (long)valueInt);
            quark = fixture.getQuarkAbsolute(new String[]{"Threads", "1432", "Exec_name"});
            interval = (ITmfStateInterval)list.get(quark);
            String valueStr = interval.getStateValue().unboxStr();
            Assert.assertEquals((Object)"gdbus", (Object)valueStr);
            quark = fixture.getQuarkAbsolute(new String[]{"Threads", "1432", "System_call"});
            interval = (ITmfStateInterval)list.get(quark);
            valueStr = interval.getStateValue().unboxStr();
            Assert.assertEquals((Object)"poll", (Object)valueStr);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test
    public void testSingleQuery1() {
        long timestamp = 1331668248014184527L;
        try {
            int quark = fixture.getQuarkAbsolute(new String[]{"Threads", "1432", "Exec_name"});
            ITmfStateInterval interval = fixture.querySingleState(timestamp, quark);
            String valueStr = interval.getStateValue().unboxStr();
            Assert.assertEquals((Object)"gdbus", (Object)valueStr);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test
    public void testRangeQuery1() {
        long time1 = 1331668248014184527L;
        long time2 = time1 + 1000000000L;
        ITmfStateSystem ss = fixture;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)time1, (long)time2);
            Assert.assertEquals((long)487L, (long)intervals.size());
            Assert.assertEquals((long)1685L, (long)((ITmfStateInterval)intervals.get(100)).getStateValue().unboxInt());
            Assert.assertEquals((long)1331668248427681372L, (long)((ITmfStateInterval)intervals.get(205)).getEndTime());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test
    public void testRangeQuery2() {
        ITmfStateSystem ss = fixture;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{"CPUs", Integer.toString(0), "IRQs", "1"});
            long ts1 = ss.getStartTime();
            long ts2 = 1331668267314038062L;
            List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)ts1, (long)ts2);
            Assert.assertEquals((long)65L, (long)intervals.size());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test
    public void testRangeQuery3() {
        long time1 = 1331668248014184527L;
        long time2 = time1 + 1000000000L;
        long resolution = 1000000L;
        ITmfStateSystem ss = fixture;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)time1, (long)time2, (long)resolution, null);
            Assert.assertEquals((long)126L, (long)intervals.size());
            Assert.assertEquals((long)1452L, (long)((ITmfStateInterval)intervals.get(50)).getStateValue().unboxInt());
            Assert.assertEquals((long)1331668248815698779L, (long)((ITmfStateInterval)intervals.get(100)).getEndTime());
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test(expected=TimeRangeException.class)
    public void testFullQueryInvalidTime1() throws TimeRangeException, StateSystemDisposedException {
        long ts = 1331668267314038062L;
        fixture.queryFullState(ts);
    }

    @Test(expected=TimeRangeException.class)
    public void testFullQueryInvalidTime2() throws TimeRangeException, StateSystemDisposedException {
        long ts = 1331668227314038062L;
        fixture.queryFullState(ts);
    }

    @Test(expected=TimeRangeException.class)
    public void testSingleQueryInvalidTime1() throws TimeRangeException {
        try {
            int quark = fixture.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            long ts = 1331668267314038062L;
            fixture.querySingleState(ts, quark);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test(expected=TimeRangeException.class)
    public void testSingleQueryInvalidTime2() throws TimeRangeException {
        try {
            int quark = fixture.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            long ts = 1331668227314038062L;
            fixture.querySingleState(ts, quark);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test(expected=TimeRangeException.class)
    public void testRangeQueryInvalidTime1() throws TimeRangeException {
        ITmfStateSystem ss = fixture;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            long ts1 = 1331668227314038062L;
            long ts2 = 1331668248314038062L;
            StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)ts1, (long)ts2);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Assert.fail();
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            Assert.fail();
        }
    }

    @Test(expected=TimeRangeException.class)
    public void testRangeQueryInvalidTime2() throws TimeRangeException {
        ITmfStateSystem ss = fixture;
        Assert.assertNotNull((Object)ss);
        try {
            int quark = ss.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            long ts1 = 1331668246314038062L;
            long ts2 = 1331668267314038062L;
            StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)ts1, (long)ts2);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test(expected=AttributeNotFoundException.class)
    public void testQueryInvalidAttribute() throws AttributeNotFoundException {
        fixture.getQuarkAbsolute(new String[]{"There", "is", "no", "cow", "level"});
    }

    @Test(expected=StateValueTypeException.class)
    public void testQueryInvalidValuetype1() throws StateValueTypeException {
        try {
            List list = fixture.queryFullState(1331668248014184527L);
            int quark = fixture.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            ITmfStateInterval interval = (ITmfStateInterval)list.get(quark);
            interval.getStateValue().unboxStr();
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test(expected=StateValueTypeException.class)
    public void testQueryInvalidValuetype2() throws StateValueTypeException {
        try {
            List list = fixture.queryFullState(1331668248014184527L);
            int quark = fixture.getQuarkAbsolute(new String[]{"Threads", "1432", "Exec_name"});
            ITmfStateInterval interval = (ITmfStateInterval)list.get(quark);
            interval.getStateValue().unboxInt();
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test
    public void testOptQuarkAbsolute() {
        int quark = fixture.optQuarkAbsolute(new String[0]);
        Assert.assertEquals((long)-1L, (long)quark);
        quark = fixture.optQuarkAbsolute(new String[]{"Threads", "1432", "Exec_name"});
        Assert.assertNotEquals((long)-2L, (long)quark);
        Assert.assertEquals((Object)"Exec_name", (Object)fixture.getAttributeName(quark));
        quark = fixture.optQuarkAbsolute(new String[]{"Threads", "1432", "absent"});
        Assert.assertEquals((long)-2L, (long)quark);
        quark = fixture.optQuarkAbsolute(new String[]{"Threads", "absent", "Exec_name"});
        Assert.assertEquals((long)-2L, (long)quark);
        quark = fixture.optQuarkAbsolute(new String[]{"absent", "1432", "Exec_name"});
        Assert.assertEquals((long)-2L, (long)quark);
    }

    @Test
    public void testOptQuarkRelative() {
        int threadsQuark = -2;
        try {
            threadsQuark = fixture.getQuarkAbsolute(new String[]{"Threads"});
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Assert.fail();
        }
        Assert.assertNotEquals((long)-2L, (long)threadsQuark);
        int quark = fixture.optQuarkRelative(threadsQuark, new String[0]);
        Assert.assertEquals((long)threadsQuark, (long)quark);
        quark = fixture.optQuarkRelative(threadsQuark, new String[]{"1432", "Exec_name"});
        Assert.assertNotEquals((long)-2L, (long)quark);
        Assert.assertEquals((Object)"Exec_name", (Object)fixture.getAttributeName(quark));
        quark = fixture.optQuarkRelative(threadsQuark, new String[]{"1432", "absent"});
        Assert.assertEquals((long)-2L, (long)quark);
        quark = fixture.optQuarkRelative(threadsQuark, new String[]{"absent", "Exec_name"});
        Assert.assertEquals((long)-2L, (long)quark);
    }

    @Test
    public void testFullAttributeName() {
        try {
            int quark = fixture.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            String name = fixture.getFullAttributePath(quark);
            Assert.assertEquals((Object)name, (Object)"CPUs/0/Current_thread");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Assert.fail();
        }
    }

    @Test
    public void testGetQuarks_begin() {
        List list = fixture.getQuarks(new String[]{"*", "1577", "Exec_name"});
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testGetQuarks_middle() {
        List list = fixture.getQuarks(new String[]{"Threads", "*", "Exec_name"});
        Assert.assertEquals((long)169L, (long)list.size());
    }

    @Test
    public void testGetQuarks_end() {
        List list = fixture.getQuarks(new String[]{"Threads", "1577", "*"});
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testGetQuarks_middle_end() {
        List list = fixture.getQuarks(new String[]{"Threads", "*", "*"});
        Assert.assertEquals((long)716L, (long)list.size());
    }

    @Test
    public void testGetQuarks_empty() {
        List list = fixture.getQuarks(new String[0]);
        Assert.assertEquals(Arrays.asList(-1), (Object)list);
    }

    @Test
    public void testGetQuarks_relative() {
        int threadsQuark = -2;
        try {
            threadsQuark = fixture.getQuarkAbsolute(new String[]{"Threads"});
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Assert.fail();
        }
        Assert.assertNotEquals((long)-2L, (long)threadsQuark);
        List list = fixture.getQuarks(threadsQuark, new String[]{"*", "Exec_name"});
        Assert.assertEquals((long)169L, (long)list.size());
    }

    @Test
    public void testGetQuarks_relative_up_wildcard() {
        int threadsQuark = -2;
        try {
            threadsQuark = fixture.getQuarkAbsolute(new String[]{"Threads"});
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Assert.fail();
        }
        Assert.assertNotEquals((long)-2L, (long)threadsQuark);
        List list = fixture.getQuarks(threadsQuark, new String[]{"..", "CPUs", "*"});
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testGetQuarks_relative_empty() {
        int threadsQuark = -2;
        try {
            threadsQuark = fixture.getQuarkAbsolute(new String[]{"Threads"});
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Assert.fail();
        }
        Assert.assertNotEquals((long)-2L, (long)threadsQuark);
        List list = fixture.getQuarks(threadsQuark, new String[0]);
        Assert.assertEquals(Arrays.asList(threadsQuark), (Object)list);
        list = fixture.getQuarks(threadsQuark, new String[0]);
        Assert.assertEquals(Arrays.asList(threadsQuark), (Object)list);
    }

    @Test
    public void testGetQuarksNoMatch() {
        List list = fixture.getQuarks(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)list.size());
        list = fixture.getQuarks(new String[]{"*", "invalid"});
        Assert.assertEquals((long)0L, (long)list.size());
        list = fixture.getQuarks(new String[]{"invalid", "*"});
        Assert.assertEquals((long)0L, (long)list.size());
        list = fixture.getQuarks(new String[]{"Threads", "*", "invalid"});
        Assert.assertEquals((long)0L, (long)list.size());
    }

    protected long getStartTimes(int idx) {
        return TestValues.startTimes[idx];
    }

    protected long getEndTimes(int idx) {
        return TestValues.endTimes[idx];
    }

    protected ITmfStateValue getStateValues(int idx) {
        return TestValues.values[idx];
    }

    @Test
    public void testFullQueryThorough() {
        try {
            List state = fixture.queryFullState(1331668248014184527L);
            Assert.assertEquals((long)TestValues.size, (long)state.size());
            int i = 0;
            while (i < state.size()) {
                Assert.assertEquals((long)this.getStartTimes(i), (long)((ITmfStateInterval)state.get(i)).getStartTime());
                Assert.assertEquals((long)this.getEndTimes(i), (long)((ITmfStateInterval)state.get(i)).getEndTime());
                Assert.assertEquals((long)i, (long)((ITmfStateInterval)state.get(i)).getAttribute());
                Assert.assertEquals((Object)this.getStateValues(i), (Object)((ITmfStateInterval)state.get(i)).getStateValue());
                ++i;
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            Assert.fail();
        }
    }

    @Test
    public void testFirstIntervalIsConsidered() {
        try {
            int quark = fixture.getQuarkAbsolute(new String[]{"Threads", "1397"});
            List list = fixture.queryFullState(1331668248014135800L);
            ITmfStateInterval interval = (ITmfStateInterval)list.get(quark);
            Assert.assertEquals((long)1331668247516664825L, (long)interval.getStartTime());
            int valueInt = interval.getStateValue().unboxInt();
            Assert.assertEquals((long)1L, (long)valueInt);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            Assert.fail();
        }
    }

    @Test
    public void testParentAttribute() {
        String[] path = new String[]{"CPUs/0/Current_thread", "CPUs/0", "CPUs"};
        try {
            int q = fixture.getQuarkAbsolute(new String[]{"CPUs", "0", "Current_thread"});
            int i = 0;
            while (i < path.length) {
                String name = fixture.getFullAttributePath(q);
                Assert.assertEquals((Object)path[i], (Object)name);
                q = fixture.getParentAttributeQuark(q);
                ++i;
            }
            Assert.assertEquals((long)-1L, (long)q);
            q = fixture.getParentAttributeQuark(q);
            Assert.assertEquals((long)-1L, (long)q);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Assert.fail();
        }
    }
}

