/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecSimpleDeclaration;

public class CPPASTSimpleDeclaration
extends CPPASTAttributeOwner
implements IASTSimpleDeclaration,
ICPPExecutionOwner {
    private IASTDeclarator[] declarators;
    private int declaratorsPos = -1;
    private IASTDeclSpecifier declSpecifier;

    public CPPASTSimpleDeclaration() {
    }

    public CPPASTSimpleDeclaration(IASTDeclSpecifier declSpecifier) {
        this.setDeclSpecifier(declSpecifier);
    }

    @Override
    public CPPASTSimpleDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTSimpleDeclaration copy(IASTNode.CopyStyle style) {
        CPPASTSimpleDeclaration copy = new CPPASTSimpleDeclaration();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CPPASTSimpleDeclaration> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setDeclSpecifier(this.declSpecifier == null ? null : this.declSpecifier.copy(style));
        IASTDeclarator[] iASTDeclaratorArray = this.getDeclarators();
        int n = iASTDeclaratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator declarator = iASTDeclaratorArray[n2];
            copy.addDeclarator(declarator == null ? null : declarator.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpecifier;
    }

    @Override
    public IASTDeclarator[] getDeclarators() {
        if (this.declarators == null) {
            return IASTDeclarator.EMPTY_DECLARATOR_ARRAY;
        }
        this.declarators = ArrayUtil.trimAt(IASTDeclarator.class, this.declarators, this.declaratorsPos);
        return this.declarators;
    }

    @Override
    public void addDeclarator(IASTDeclarator d) {
        this.assertNotFrozen();
        if (d != null) {
            this.declarators = ArrayUtil.appendAt(IASTDeclarator.class, this.declarators, ++this.declaratorsPos, d);
            d.setParent(this);
            d.setPropertyInParent(DECLARATOR);
        }
    }

    @Override
    public void setDeclSpecifier(IASTDeclSpecifier declSpecifier) {
        this.assertNotFrozen();
        this.declSpecifier = declSpecifier;
        if (declSpecifier != null) {
            declSpecifier.setParent(this);
            declSpecifier.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.declSpecifier != null && !this.declSpecifier.accept(action)) {
            return false;
        }
        IASTDeclarator[] dtors = this.getDeclarators();
        int i = 0;
        while (i < dtors.length) {
            if (!dtors[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        IASTDeclarator[] declarators = this.getDeclarators();
        int i = 0;
        while (i < declarators.length) {
            if (declarators[i] == child) {
                declarators[i] = (IASTDeclarator)other;
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                return;
            }
            ++i;
        }
        super.replace(child, other);
    }

    @Override
    public ICPPExecution getExecution() {
        IASTDeclarator[] declarators = this.getDeclarators();
        ICPPExecution[] declaratorExecutions = new ICPPExecution[declarators.length];
        int i = 0;
        while (i < declarators.length) {
            declaratorExecutions[i] = ((ICPPExecutionOwner)((Object)declarators[i])).getExecution();
            ++i;
        }
        return new ExecSimpleDeclaration(declaratorExecutions);
    }
}

