/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.tmf.core.event.ITmfCustomAttributes;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCallsiteAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfModelLookup;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventField;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;
import org.eclipse.tracecompass.tmf.ctf.core.event.NullEventDefinition;
import org.eclipse.tracecompass.tmf.ctf.core.event.lookup.CtfTmfCallsite;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public class CtfTmfEvent
extends TmfEvent
implements ITmfSourceLookup,
ITmfModelLookup,
ITmfCustomAttributes {
    private static final String EMPTY_CTF_EVENT_NAME = "Empty CTF event";
    private final @Nullable IEventDeclaration fEventDeclaration;
    private final IEventDefinition fEvent;
    private final int fSourceCpu;
    private final String fChannel;
    private final String fEventName;
    private transient @Nullable ITmfEventField fContent;
    private transient @Nullable CtfTmfEventType fEventType;
    private final @Nullable ICTFStream fStream;
    private final Map<String, Object> fPacketAttributes;

    protected CtfTmfEvent(CtfTmfTrace trace, long rank, ITmfTimestamp timestamp, String channel, int cpu, IEventDeclaration declaration, IEventDefinition eventDefinition) {
        super((ITmfTrace)trace, rank, timestamp, null, null);
        this.fEventDeclaration = declaration;
        this.fSourceCpu = cpu;
        this.fEventName = (String)NonNullUtils.checkNotNull((Object)declaration.getName());
        this.fEvent = eventDefinition;
        this.fChannel = channel;
        this.fStream = this.fEvent.getDeclaration().getStream();
        this.fPacketAttributes = eventDefinition.getPacketAttributes();
    }

    CtfTmfEvent(CtfTmfTrace trace) {
        super((ITmfTrace)trace, -1L, TmfTimestamp.fromNanos((long)-1L), null, (ITmfEventField)new TmfEventField("", null, (ITmfEventField[])new CtfTmfEventField[0]));
        this.fSourceCpu = -1;
        this.fEventName = EMPTY_CTF_EVENT_NAME;
        this.fEventDeclaration = null;
        this.fEvent = NullEventDefinition.INSTANCE;
        this.fChannel = "";
        this.fStream = null;
        this.fPacketAttributes = Collections.emptyMap();
    }

    @Deprecated
    public CtfTmfEvent() {
        this.fSourceCpu = -1;
        this.fEventName = EMPTY_CTF_EVENT_NAME;
        this.fEventDeclaration = null;
        this.fEvent = NullEventDefinition.INSTANCE;
        this.fChannel = "";
        this.fStream = null;
        this.fPacketAttributes = Collections.emptyMap();
    }

    public int getCPU() {
        return this.fSourceCpu;
    }

    public String getChannel() {
        return this.fChannel;
    }

    public long getStreamId() {
        ICTFStream stream = this.fStream;
        if (stream == null) {
            return -1L;
        }
        return stream.getId();
    }

    public long getUnscaledTime() {
        return this.fEvent.getTimestamp();
    }

    public CtfTmfTrace getTrace() {
        return (CtfTmfTrace)super.getTrace();
    }

    public synchronized ITmfEventType getType() {
        CtfTmfEventType type = this.fEventType;
        if (type == null) {
            type = new CtfTmfEventType(this.fEventName, this.getContent());
            this.getTrace().registerEventType(type);
            this.fEventType = type;
        }
        return type;
    }

    public String getName() {
        return this.fEventName;
    }

    public synchronized ITmfEventField getContent() {
        ITmfEventField content = this.fContent;
        if (content == null) {
            this.fContent = content = new TmfEventField(":root:", null, (ITmfEventField[])CtfTmfEvent.parseFields(this.fEvent));
        }
        return content;
    }

    private static CtfTmfEventField[] parseFields(IEventDefinition eventDef) {
        ICompositeDefinition structContext;
        ArrayList<CtfTmfEventField> fields = new ArrayList<CtfTmfEventField>();
        ICompositeDefinition structFields = eventDef.getFields();
        if (structFields != null && structFields.getFieldNames() != null) {
            for (String fn : structFields.getFieldNames()) {
                fields.add(CtfTmfEventField.parseField((IDefinition)structFields.getDefinition(fn), fn));
            }
        }
        if ((structContext = eventDef.getContext()) != null) {
            for (String contextName : structContext.getFieldNames()) {
                String curContextName = "context." + contextName;
                fields.add(CtfTmfEventField.parseField((IDefinition)structContext.getDefinition(contextName), curContextName));
            }
        }
        return fields.toArray(new CtfTmfEventField[fields.size()]);
    }

    public Set<String> listCustomAttributes() {
        IEventDeclaration declaration = this.fEventDeclaration;
        if (declaration == null) {
            return new HashSet<String>();
        }
        return declaration.getCustomAttributes();
    }

    public @Nullable String getCustomAttribute(@Nullable String name) {
        IEventDeclaration declaration = this.fEventDeclaration;
        if (declaration == null) {
            return null;
        }
        return declaration.getCustomAttribute(name);
    }

    public @Nullable ITmfCallsite getCallsite() {
        CtfTmfCallsite callsite = null;
        ITmfEventField ipField = this.getContent().getField(new String[]{"context._ip"});
        if (ipField != null && ipField.getValue() instanceof Long) {
            long ip = (Long)ipField.getValue();
            callsite = this.getTrace().getCallsite(this.fEventName, ip);
        }
        if (callsite == null) {
            callsite = this.getTrace().getCallsite(this.fEventName);
        }
        return callsite;
    }

    public @Nullable List<@NonNull ITmfCallsite> getCallsites() {
        for (ITmfEventAspect<?> aspect : this.getTrace().getEventAspects()) {
            List callsite;
            if (!(aspect instanceof TmfCallsiteAspect) || (callsite = (List)((TmfCallsiteAspect)aspect).resolve((ITmfEvent)this)) == null) continue;
            return callsite;
        }
        return super.getCallsites();
    }

    public @Nullable String getModelUri() {
        return this.getCustomAttribute("model.emf.uri");
    }

    public Map<String, Object> getPacketAttributes() {
        return this.fPacketAttributes;
    }

    public @Nullable ICompositeDefinition getPacketContext() {
        return this.fEvent.getPacketContext();
    }

    public @Nullable ICompositeDefinition getPacketHeader() {
        return this.fEvent.getPacketHeader();
    }

    public @Nullable ICompositeDefinition getStreamContext() {
        return this.fEvent.getStreamContext();
    }

    public @Nullable ICompositeDefinition getEventContext() {
        return this.fEvent.getEventContext();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getCPU();
        result = 31 * result + this.getChannel().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CtfTmfEvent other = (CtfTmfEvent)((Object)NonNullUtils.checkNotNull((Object)((Object)((CtfTmfEvent)((Object)obj)))));
        if (this.getCPU() != other.getCPU()) {
            return false;
        }
        return this.getChannel().equals(other.getChannel());
    }
}

