/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.FilterUpdateEvent;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.search.ui.text.RemoveAllEvent;

public abstract class AbstractTextSearchResult
implements ISearchResult {
    private static final Match[] EMPTY_ARRAY = new Match[0];
    private final Map<Object, List<Match>> fElementsToMatches = new HashMap<Object, List<Match>>();
    private final List<ISearchResultListener> fListeners = new ArrayList<ISearchResultListener>();
    private final MatchEvent fMatchEvent = new MatchEvent(this);
    private MatchFilter[] fMatchFilters = null;

    protected AbstractTextSearchResult() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match[] getMatches(Object element) {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            List<Match> matches = this.fElementsToMatches.get(element);
            if (matches != null) {
                return matches.toArray(new Match[matches.size()]);
            }
            return EMPTY_ARRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMatch(Match match) {
        boolean hasAdded = false;
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            hasAdded = this.doAddMatch(match);
        }
        if (hasAdded) {
            this.fireChange(this.getSearchResultEvent(match, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMatches(Match[] matches) {
        ArrayList<Match> reallyAdded = new ArrayList<Match>();
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (this.doAddMatch(match)) {
                    reallyAdded.add(match);
                }
                ++n2;
            }
        }
        if (!reallyAdded.isEmpty()) {
            this.fireChange(this.getSearchResultEvent(reallyAdded, 1));
        }
    }

    private MatchEvent getSearchResultEvent(Match match, int eventKind) {
        this.fMatchEvent.setKind(eventKind);
        this.fMatchEvent.setMatch(match);
        return this.fMatchEvent;
    }

    private MatchEvent getSearchResultEvent(Collection<Match> matches, int eventKind) {
        this.fMatchEvent.setKind(eventKind);
        Match[] matchArray = matches.toArray(new Match[matches.size()]);
        this.fMatchEvent.setMatches(matchArray);
        return this.fMatchEvent;
    }

    private boolean doAddMatch(Match match) {
        this.updateFilterState(match);
        List<Match> matches = this.fElementsToMatches.get(match.getElement());
        if (matches == null) {
            matches = new ArrayList<Match>();
            this.fElementsToMatches.put(match.getElement(), matches);
            matches.add(match);
            return true;
        }
        if (!matches.contains(match)) {
            AbstractTextSearchResult.insertSorted(matches, match);
            return true;
        }
        return false;
    }

    private static void insertSorted(List<Match> matches, Match match) {
        int insertIndex = AbstractTextSearchResult.getInsertIndex(matches, match);
        matches.add(insertIndex, match);
    }

    private static int getInsertIndex(List<Match> matches, Match match) {
        int count = matches.size();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Match data = matches.get(mid);
            int compare = AbstractTextSearchResult.compare(match, data);
            if (compare > 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return min;
    }

    private static int compare(Match match1, Match match2) {
        int diff = match2.getOffset() - match1.getOffset();
        if (diff != 0) {
            return diff;
        }
        return match2.getLength() - match1.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            this.doRemoveAll();
        }
        this.fireChange(new RemoveAllEvent(this));
    }

    private void doRemoveAll() {
        this.fElementsToMatches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        boolean existed = false;
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            existed = this.doRemoveMatch(match);
        }
        if (existed) {
            this.fireChange(this.getSearchResultEvent(match, 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatches(Match[] matches) {
        ArrayList<Match> existing = new ArrayList<Match>();
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            Match[] matchArray = matches;
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (this.doRemoveMatch(match)) {
                    existing.add(match);
                }
                ++n2;
            }
        }
        if (!existing.isEmpty()) {
            this.fireChange(this.getSearchResultEvent(existing, 2));
        }
    }

    private boolean doRemoveMatch(Match match) {
        boolean existed = false;
        List<Match> matches = this.fElementsToMatches.get(match.getElement());
        if (matches != null) {
            existed = matches.remove(match);
            if (matches.isEmpty()) {
                this.fElementsToMatches.remove(match.getElement());
            }
        }
        return existed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ISearchResultListener l) {
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChange(SearchResultEvent e) {
        HashSet<ISearchResultListener> copiedListeners = new HashSet<ISearchResultListener>();
        List<ISearchResultListener> list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            ((ISearchResultListener)listeners.next()).searchResultChanged(e);
        }
    }

    private void updateFilterStateForAllMatches() {
        Object[] elements;
        boolean disableFiltering = this.getActiveMatchFilters() == null;
        ArrayList<Match> changed = new ArrayList<Match>();
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Match[] matches;
            Object element = objectArray[n2];
            Match[] matchArray = matches = this.getMatches(element);
            int n3 = matches.length;
            int n4 = 0;
            while (n4 < n3) {
                Match match = matchArray[n4];
                if (disableFiltering || this.updateFilterState(match)) {
                    changed.add(match);
                }
                ++n4;
            }
            ++n2;
        }
        Match[] allChanges = changed.toArray(new Match[changed.size()]);
        this.fireChange(new FilterUpdateEvent(this, allChanges, this.getActiveMatchFilters()));
    }

    private boolean updateFilterState(Match match) {
        MatchFilter[] matchFilters = this.getActiveMatchFilters();
        if (matchFilters == null) {
            return false;
        }
        boolean oldState = match.isFiltered();
        MatchFilter[] matchFilterArray = matchFilters;
        int n = matchFilters.length;
        int n2 = 0;
        while (n2 < n) {
            MatchFilter matchFilter = matchFilterArray[n2];
            if (matchFilter.filters(match)) {
                match.setFiltered(true);
                return !oldState;
            }
            ++n2;
        }
        match.setFiltered(false);
        return oldState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMatchCount() {
        int count = 0;
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            for (List<Match> element : this.fElementsToMatches.values()) {
                if (element == null) continue;
                count += element.size();
            }
        }
        return count;
    }

    public int getMatchCount(Object element) {
        List<Match> matches = this.fElementsToMatches.get(element);
        if (matches != null) {
            return matches.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements() {
        Map<Object, List<Match>> map = this.fElementsToMatches;
        synchronized (map) {
            return this.fElementsToMatches.keySet().toArray();
        }
    }

    public void setActiveMatchFilters(MatchFilter[] filters) {
        this.fMatchFilters = filters;
        this.updateFilterStateForAllMatches();
    }

    public MatchFilter[] getActiveMatchFilters() {
        return this.fMatchFilters;
    }

    public MatchFilter[] getAllMatchFilters() {
        return null;
    }

    public abstract IEditorMatchAdapter getEditorMatchAdapter();

    public abstract IFileMatchAdapter getFileMatchAdapter();
}

