/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.IProbeEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.ProbeEventInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProbeEventInfoTest {
    private IProbeEventInfo fEventInfo1 = null;
    private IProbeEventInfo fEventInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fEventInfo1 = factory.getProbeEventInfo1();
        this.fEventInfo2 = factory.getProbeEventInfo2();
    }

    @Test
    public void testBaseEventInfo() {
        ProbeEventInfo fixture = new ProbeEventInfo("event");
        Assert.assertNotNull((Object)fixture);
        TraceEventType result = fixture.getEventType();
        Assert.assertEquals((Object)"event", (Object)fixture.getName());
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        TraceEnablement state = fixture.getState();
        Assert.assertEquals((Object)"disabled", (Object)state.getInName());
        Assert.assertEquals((Object)"DISABLED", (Object)state.name());
        Assert.assertEquals((Object)"DISABLED", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        Assert.assertNull((Object)fixture.getAddress());
        Assert.assertNull((Object)fixture.getOffset());
        Assert.assertNull((Object)fixture.getSymbol());
    }

    @Test
    public void testEventInfoCopy() {
        ProbeEventInfo info = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo1);
        Assert.assertEquals((Object)this.fEventInfo1.getName(), (Object)info.getName());
        Assert.assertEquals((Object)this.fEventInfo1.getEventType(), (Object)info.getEventType());
        Assert.assertEquals((Object)this.fEventInfo1.getState(), (Object)info.getState());
        Assert.assertEquals((Object)this.fEventInfo1.getAddress(), (Object)info.getAddress());
        Assert.assertEquals((Object)this.fEventInfo1.getOffset(), (Object)info.getOffset());
        Assert.assertEquals((Object)this.fEventInfo1.getSymbol(), (Object)info.getSymbol());
    }

    @Test
    public void testEventCopy2() {
        try {
            ProbeEventInfo info = null;
            new ProbeEventInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void testGetAndSetter() {
        ProbeEventInfo fixture = new ProbeEventInfo("event");
        fixture.setAddress("0xc12344321");
        String result = fixture.getAddress();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"0xc12344321", (Object)result);
        fixture.setOffset("0x1000");
        result = fixture.getOffset();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"0x1000", (Object)result);
        fixture.setSymbol("cpu_idle");
        result = fixture.getSymbol();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"cpu_idle", (Object)result);
    }

    @Test
    public void testToString_1() {
        Assert.assertEquals((Object)"[ProbeEventInfo([EventInfo([BaseEventInfo([TraceInfo(Name=probeEvent1)],type=TRACEPOINT,level=TRACE_DEBUG)],State=ENABLED,levelType=LOGLEVEL_NONE)],fAddress=0xc1231234)]", (Object)this.fEventInfo1.toString());
        Assert.assertEquals((Object)"[ProbeEventInfo([EventInfo([BaseEventInfo([TraceInfo(Name=probeEvent2)],type=FUNCTION,level=TRACE_DEBUG)],State=DISABLED,levelType=LOGLEVEL_NONE)],fOffset=0x100,fSymbol=init_post)]", (Object)this.fEventInfo2.toString());
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo1.equals(this.fEventInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo2.equals(this.fEventInfo2));
        Assert.assertTrue((String)"equals", (!this.fEventInfo1.equals(this.fEventInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventInfo2.equals(this.fEventInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        ProbeEventInfo info1 = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo1);
        ProbeEventInfo info2 = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fEventInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fEventInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        ProbeEventInfo info1 = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo1);
        ProbeEventInfo info2 = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo1);
        ProbeEventInfo info3 = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fEventInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        ProbeEventInfo info1 = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo1);
        ProbeEventInfo info2 = new ProbeEventInfo((ProbeEventInfo)this.fEventInfo2);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

