/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.ui.tests.data;

import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.chart.ui.data.ChartRange;
import org.junit.Assert;
import org.junit.Test;

public class ChartRangeTest {
    private static final @NonNull BigDecimal ZERO = BigDecimal.ZERO;
    private static final @NonNull BigDecimal ONE = BigDecimal.ONE;
    private static final @NonNull BigDecimal TEN = BigDecimal.TEN;

    @Test
    public void testDefaultConstructor() {
        ChartRange cr = new ChartRange();
        Assert.assertEquals((Object)BigDecimal.ZERO, (Object)cr.getMinimum());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)cr.getMaximum());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)cr.getDelta());
    }

    @Test
    public void testConstructor() {
        ChartRange cr = new ChartRange(ONE, TEN);
        Assert.assertEquals((Object)ONE, (Object)cr.getMinimum());
        Assert.assertEquals((Object)TEN, (Object)cr.getMaximum());
        Assert.assertEquals((Object)new BigDecimal(9), (Object)cr.getDelta());
        cr = new ChartRange(ONE, ONE);
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)cr.getMinimum());
        Assert.assertEquals((Object)new BigDecimal(2), (Object)cr.getMaximum());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)cr.getDelta());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructor() {
        ChartRange cr = new ChartRange(ONE, ZERO);
        Assert.assertNotNull((Object)cr);
    }

    @Test
    public void testClamp() {
        BigDecimal minusTwo = new BigDecimal(-2);
        ChartRange cr = new ChartRange(ONE, TEN);
        Assert.assertEquals((Object)ONE, (Object)cr.getMinimum());
        Assert.assertEquals((Object)TEN, (Object)cr.getMaximum());
        Assert.assertEquals((Object)new BigDecimal(9), (Object)cr.getDelta());
        cr.clamp();
        Assert.assertEquals((Object)ZERO, (Object)cr.getMinimum());
        Assert.assertEquals((Object)TEN, (Object)cr.getMaximum());
        Assert.assertEquals((Object)TEN, (Object)cr.getDelta());
        cr = new ChartRange(minusTwo, ONE);
        Assert.assertEquals((Object)minusTwo, (Object)cr.getMinimum());
        Assert.assertEquals((Object)ONE, (Object)cr.getMaximum());
        Assert.assertEquals((Object)new BigDecimal(3), (Object)cr.getDelta());
        cr.clamp();
        Assert.assertEquals((Object)minusTwo, (Object)cr.getMinimum());
        Assert.assertEquals((Object)ONE, (Object)cr.getMaximum());
        Assert.assertEquals((Object)new BigDecimal(3), (Object)cr.getDelta());
    }
}

