/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateIntervalStub;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateSystemTestUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.Messages;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestStateSystemModule;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestStateSystemProvider;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class StateSystemAnalysisModuleTest {
    @Rule
    public TestRule globalTimeout = new Timeout(1L, TimeUnit.MINUTES);
    public static final String MODULE_SS = "org.eclipse.linuxtools.tmf.core.tests.analysis.sstest";
    private static final String XML_TRACE = "testfiles/stub_xml_traces/valid/analysis_dependency.xml";
    private TestStateSystemModule fModule;
    private ITmfTrace fTrace;
    private static final String CRUCIAL_EVENT = "crucialEvent";
    private static final String CRUCIAL_FIELD = "crucialInfo";

    @Before
    public void setupTraces() {
        TmfXmlTraceStubNs trace = TmfXmlTraceStubNs.setupTrace(TmfCoreTestPlugin.getAbsoluteFilePath(XML_TRACE));
        trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
        this.fTrace = trace;
        this.fModule = (TestStateSystemModule)trace.getAnalysisModule(MODULE_SS);
    }

    @After
    public void cleanupTraces() {
        this.fTrace.dispose();
    }

    @Test
    public void testSsModule() {
        ITmfStateSystem ss = this.fModule.getStateSystem();
        Assert.assertNull((Object)ss);
        this.fModule.schedule();
        if (this.fModule.waitForCompletion()) {
            ss = this.fModule.getStateSystem();
            Assert.assertNotNull((Object)ss);
        } else {
            Assert.fail((String)"Module did not complete properly");
        }
    }

    @Test
    public void testInitialization() {
        Assert.assertNull((Object)this.fModule.getStateSystem());
        this.fModule.schedule();
        Assert.assertTrue((String)"Initialization succeeded", (boolean)this.fModule.waitForInitialization());
        Assert.assertNotNull((Object)this.fModule.getStateSystem());
    }

    @Test
    public void testProperties() {
        Map properties = this.fModule.getProperties();
        Assert.assertEquals((Object)this.fModule.getBackendName(), properties.get(Messages.TmfStateSystemAnalysisModule_PropertiesBackend));
        Assert.assertEquals((Object)this.fModule.getId(), properties.get(org.eclipse.tracecompass.tmf.core.analysis.Messages.TmfAbstractAnalysisModule_LabelId));
    }

    private static void setupDependentAnalysisHandler(CyclicBarrier barrier) {
        TestStateSystemProvider.setEventHandler((ss, provider, event) -> {
            try {
                barrier.await();
                if (event.getName().equals(CRUCIAL_EVENT)) {
                    String crucialInfo = (String)event.getContent().getField(new String[]{CRUCIAL_FIELD}).getValue();
                    int quark = ss.getQuarkAbsoluteAndAdd(new String[]{CRUCIAL_FIELD});
                    try {
                        ss.modifyAttribute(event.getTimestamp().toNanos(), (Object)crucialInfo, quark);
                    }
                    catch (Exception e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                barrier.await();
                return true;
            }
            catch (InterruptedException | BrokenBarrierException exception) {
                return false;
            }
        });
    }

    @Test
    public void testIsQueryable() {
        CyclicBarrier barrier = new CyclicBarrier(2);
        StateSystemAnalysisModuleTest.setupDependentAnalysisHandler(barrier);
        TestStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)((Object)module));
        Assert.assertTrue((boolean)module.isQueryable(1L));
        Assert.assertTrue((boolean)module.isQueryable(4L));
        Assert.assertTrue((boolean)module.isQueryable(5L));
        Assert.assertTrue((boolean)module.isQueryable(7L));
        Assert.assertTrue((boolean)module.isQueryable(10L));
        module.schedule();
        Assert.assertTrue((boolean)module.waitForInitialization());
        Assert.assertFalse((boolean)module.isQueryable(1L));
        try {
            try {
                barrier.await();
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertFalse((boolean)module.isQueryable(5L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertFalse((boolean)module.isQueryable(5L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertFalse((boolean)module.isQueryable(5L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertFalse((boolean)module.isQueryable(7L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertFalse((boolean)module.isQueryable(7L));
                barrier.await();
                barrier.await();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertTrue((boolean)module.isQueryable(7L));
                Assert.assertFalse((boolean)module.isQueryable(10L));
                barrier.await();
                this.fModule.waitForCompletion();
                Assert.assertTrue((boolean)module.isQueryable(1L));
                Assert.assertTrue((boolean)module.isQueryable(4L));
                Assert.assertTrue((boolean)module.isQueryable(5L));
                Assert.assertTrue((boolean)module.isQueryable(7L));
                Assert.assertTrue((boolean)module.isQueryable(10L));
                Assert.assertTrue((boolean)module.isQueryable(100L));
            }
            catch (InterruptedException | BrokenBarrierException e1) {
                Assert.fail((String)e1.getMessage());
                this.fModule.cancel();
                TestStateSystemProvider.setEventHandler(null);
            }
        }
        finally {
            TestStateSystemProvider.setEventHandler(null);
        }
    }

    @Ignore(value="Hangs very often")
    @Test
    public void testIsQueryableCancel() {
        TestStateSystemModule module = this.fModule;
        Assert.assertNotNull((Object)((Object)module));
        module.setPerEventSignalling(true);
        Assert.assertTrue((boolean)module.isQueryable(1L));
        Assert.assertTrue((boolean)module.isQueryable(4L));
        Assert.assertTrue((boolean)module.isQueryable(5L));
        Assert.assertTrue((boolean)module.isQueryable(7L));
        Assert.assertTrue((boolean)module.isQueryable(10L));
        this.fModule.schedule();
        Assert.assertTrue((boolean)module.waitForInitialization());
        Assert.assertFalse((boolean)module.isQueryable(1L));
        module.signalNextEvent();
        module.signalNextEvent();
        module.cancel();
        module.setPerEventSignalling(false);
        this.fModule.waitForCompletion();
        Assert.assertTrue((boolean)module.isQueryable(1L));
        Assert.assertTrue((boolean)module.isQueryable(4L));
        Assert.assertTrue((boolean)module.isQueryable(5L));
        Assert.assertTrue((boolean)module.isQueryable(7L));
        Assert.assertTrue((boolean)module.isQueryable(10L));
    }

    @Test
    public void testReReadFullAnalysis() throws TmfAnalysisException {
        TestStateSystemModule module = new TestStateSystemModule(true);
        TestStateSystemModule module2 = new TestStateSystemModule(true);
        try {
            ITmfTrace trace = this.fTrace;
            Assert.assertNotNull((Object)trace);
            module.setTrace(trace);
            module2.setTrace(trace);
            module.schedule();
            Assert.assertTrue((boolean)module.waitForCompletion());
            File ssFile = module2.getSsFile();
            Assert.assertNotNull((Object)ssFile);
            Assert.assertTrue((boolean)ssFile.exists());
            module2.schedule();
            Assert.assertTrue((boolean)module2.waitForCompletion());
        }
        finally {
            module.dispose();
            module2.dispose();
        }
    }

    @Test
    public void testRequestFailure() throws TmfAnalysisException {
        TestStateSystemModule module = new TestStateSystemModule();
        module.setRequestAction(e -> {
            throw new IllegalArgumentException("This exception is desired and part of the test");
        });
        try {
            ITmfTrace trace = this.fTrace;
            Assert.assertNotNull((Object)trace);
            module.setTrace(trace);
            module.schedule();
            Assert.assertFalse((boolean)module.waitForCompletion());
        }
        finally {
            module.dispose();
        }
    }

    @Test
    public void testFaultyStateProvider() throws TmfAnalysisException {
        final ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TestStateSystemModule module = new TestStateSystemModule(){

            @Override
            protected @NonNull ITmfStateProvider createStateProvider() {
                return new BreakingTest(trace, 7, "Expected exception: should be caught by the analysis itself");
            }
        };
        try {
            module.setTrace(trace);
            module.schedule();
            Assert.assertFalse((boolean)module.waitForCompletion());
        }
        finally {
            module.dispose();
        }
        module = new TestStateSystemModule(){

            @Override
            protected @NonNull ITmfStateProvider createStateProvider() {
                return new BreakingTest(trace, 5, "Expected exception: should be caught by either the analysis or the event request");
            }
        };
        try {
            module.setTrace(trace);
            module.schedule();
            Assert.assertFalse((boolean)module.waitForCompletion());
        }
        finally {
            module.dispose();
        }
        module = new TestStateSystemModule(){

            @Override
            protected @NonNull ITmfStateProvider createStateProvider() {
                return new BreakingTest(trace, 1, "Expected exception: should be caught by the event request thread");
            }
        };
        try {
            module.setTrace(trace);
            module.schedule();
            Assert.assertFalse((boolean)module.waitForCompletion());
        }
        finally {
            module.dispose();
        }
    }

    @Test
    public void testFailBeforeInitialization() throws TmfAnalysisException {
        ITmfTrace trace = this.fTrace;
        Assert.assertNotNull((Object)trace);
        TestStateSystemModule module = new TestStateSystemModule(){

            protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
                throw new IllegalStateException("This exception happens before initialization");
            }
        };
        try {
            module.setTrace(trace);
            module.schedule();
            Assert.assertFalse((boolean)module.waitForInitialization());
            Assert.assertFalse((boolean)module.waitForCompletion());
        }
        finally {
            module.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFutureEvents() {
        String futureVal = "futureVal";
        String futureStack = "futureStack";
        int oneValue = 100;
        String stack1 = "stack1";
        String stack2 = "stack2";
        try {
            TestStateSystemProvider.setEventHandler((ss, provider, event) -> {
                if (event.getTimestamp().toNanos() == 1L) {
                    int valueQuark = ss.getQuarkAbsoluteAndAdd(new String[]{futureVal});
                    ss.modifyAttribute(event.getTimestamp().toNanos(), (Object)oneValue, valueQuark);
                    provider.addFutureEvent(5L, null, valueQuark, ITmfStateProvider.FutureEventType.MODIFICATION);
                    int stackQuark = ss.getQuarkAbsoluteAndAdd(new String[]{futureStack});
                    ss.pushAttribute(event.getTimestamp().toNanos(), (Object)stack1, stackQuark);
                    provider.addFutureEvent(4L, (Object)stack2, stackQuark, ITmfStateProvider.FutureEventType.PUSH);
                    provider.addFutureEvent(7L, (Object)stack2, stackQuark, ITmfStateProvider.FutureEventType.POP);
                    provider.addFutureEvent(8L, (Object)stack1, stackQuark, ITmfStateProvider.FutureEventType.POP);
                }
                return true;
            });
            TestStateSystemModule module = this.fModule;
            module.schedule();
            Assert.assertTrue((boolean)module.waitForCompletion());
            ITmfStateSystem ss2 = module.getStateSystem();
            Assert.assertNotNull((Object)ss2);
            @NonNull ImmutableList expected = ImmutableList.of((Object)new StateIntervalStub(1, 4, (Object)oneValue), (Object)new StateIntervalStub(5, 10, null));
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss2, (List)expected, (String[])new String[]{futureVal});
            expected = ImmutableList.of((Object)new StateIntervalStub(1, 7, (Object)stack1), (Object)new StateIntervalStub(8, 10, null));
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss2, (List)expected, (String[])new String[]{futureStack, "1"});
            expected = ImmutableList.of((Object)new StateIntervalStub(1, 3, null), (Object)new StateIntervalStub(4, 6, (Object)stack2), (Object)new StateIntervalStub(7, 10, null));
            StateSystemTestUtils.testIntervalForAttributes((ITmfStateSystem)ss2, (List)expected, (String[])new String[]{futureStack, "2"});
        }
        finally {
            TestStateSystemProvider.setEventHandler(null);
        }
    }

    private final class BreakingTest
    extends TestStateSystemProvider {
        private final int fEventNo;
        private int fEventCount;
        private String fExceptionMessage;

        private BreakingTest(ITmfTrace trace, int eventToFail, String msg) {
            super(trace, 1, 2);
            this.fEventCount = 0;
            this.fEventNo = eventToFail;
            this.fExceptionMessage = msg;
        }

        @Override
        protected void eventHandle(@NonNull ITmfEvent event) {
            ++this.fEventCount;
            if (this.fEventCount == this.fEventNo) {
                throw new IllegalArgumentException(this.fExceptionMessage);
            }
        }
    }
}

