/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class TmfViewFactory {
    @VisibleForTesting
    public static final String INTERNAL_SECONDARY_ID_SEPARATOR = "&";

    private TmfViewFactory() {
    }

    @NonNullByDefault
    public static @Nullable IViewPart newView(String viewId, boolean generateSuffix) {
        IViewPart viewPart = null;
        String primaryId = null;
        String secondaryId = null;
        int index = viewId.indexOf(":");
        if (index != -1) {
            primaryId = viewId.substring(0, index);
            secondaryId = TmfViewFactory.getBaseSecId(viewId.substring(index + 1));
        } else {
            primaryId = viewId;
        }
        if (generateSuffix) {
            secondaryId = secondaryId == null ? UUID.randomUUID().toString() : String.valueOf(secondaryId) + INTERNAL_SECONDARY_ID_SEPARATOR + UUID.randomUUID().toString();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            viewPart = page.showView(primaryId, secondaryId, 1);
            page.activate((IWorkbenchPart)viewPart);
        }
        catch (PartInitException partInitException) {}
        return viewPart;
    }

    public static @Nullable String getBaseSecId(String secId) {
        if (secId == null) {
            return null;
        }
        int uuidSeparator = secId.lastIndexOf(INTERNAL_SECONDARY_ID_SEPARATOR);
        if (uuidSeparator == -1) {
            if (TmfViewFactory.isUUID(secId)) {
                return null;
            }
            return secId;
        }
        String potentialUUID = secId.substring(uuidSeparator + 1);
        if (!TmfViewFactory.isUUID(potentialUUID)) {
            return secId;
        }
        return secId.substring(0, uuidSeparator);
    }

    private static boolean isUUID(String uuid) {
        if (uuid == null) {
            return false;
        }
        try {
            UUID fromStringUUID = UUID.fromString(uuid);
            String toStringUUID = fromStringUUID.toString();
            return toStringUUID.equals(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

