/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class Services {
    @Inject
    private Display display;
    @Inject
    @Optional
    @Named(value="activeShell")
    private Shell shell;
    @Inject
    private MApplication mApplication;
    @Inject
    @Optional
    @Active
    private MWindow window;
    @Inject
    private EHandlerService eHandlerService;
    @Inject
    private IProgressService progressService;
    @Inject
    private EModelService modelService;
    @Inject
    private EPartService partService;
    @Inject
    private LogService logService;
    @Inject
    private StatusReporter statusReporter;
    @Inject
    private UISynchronize uiSynchronize;
    @Inject
    IEclipseContext localContext;
    IEclipseContext appContext;
    protected static Services instance;

    Services() {
        instance = this;
    }

    @PostConstruct
    void init() {
        this.appContext = this.mApplication.getContext();
        this.appContext.set(Services.class, (Object)this);
    }

    public <T> T getService(Class<T> clazz) {
        return (T)this.localContext.get(clazz);
    }

    public <T> void registerService(Class<T> clazz, T value) {
        this.appContext.set(clazz, value);
    }

    public static Services getInstance() {
        return instance;
    }

    public Display getDisplay() {
        return this.display != null ? this.display : this.getDefaultDisplay();
    }

    private Display getDefaultDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Shell getShell() {
        return this.shell;
    }

    public UISynchronize getUISynchronize() {
        return this.uiSynchronize;
    }

    public EHandlerService getEHandlerService() {
        return this.eHandlerService;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public StatusReporter getStatusReporter() {
        return this.statusReporter;
    }

    public IProgressService getProgressService() {
        return this.progressService;
    }

    public EModelService getModelService() {
        return this.modelService;
    }

    public EPartService getPartService() {
        return this.partService;
    }

    public MWindow getMWindow() {
        return this.window;
    }

    public MApplication getMApplication() {
        return this.mApplication;
    }
}

