/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.event;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.btf.core.event.BTFPayload;
import org.eclipse.tracecompass.btf.core.trace.BtfColumnNames;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;

public class BtfEventType
extends TmfEventType {
    private static final String @NonNull [] FIELDS_WITH_NOTES_COLUMNS = new String[]{BtfColumnNames.EVENT.toString(), BtfColumnNames.SOURCE_INSTANCE.toString(), BtfColumnNames.TARGET_INSTANCE.toString(), BtfColumnNames.NOTES.toString()};
    private static final @NonNull ITmfEventField FIELDS_WITH_NOTES = TmfEventField.makeRoot((String[])FIELDS_WITH_NOTES_COLUMNS);
    private final @NonNull String fName;
    private final String fDescription;
    private final List<String> fCols;
    private final ITmfEventField fFields;

    public BtfEventType(@NonNull String name, String description) {
        this.fName = name;
        this.fDescription = description;
        this.fCols = ImmutableList.copyOf((Object[])FIELDS_WITH_NOTES_COLUMNS);
        this.fFields = FIELDS_WITH_NOTES;
    }

    public String getName() {
        return this.fName;
    }

    public Collection<String> getFieldNames() {
        return this.fCols;
    }

    public ITmfEventField getRootField() {
        return this.fFields;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public ITmfEventField generateContent(String event, long sourceInstance, long targetInstance) {
        return this.generateContent(event, sourceInstance, targetInstance, null);
    }

    public ITmfEventField generateContent(String event, long sourceInstance, long targetInstance, @Nullable String notes) {
        String notesString = notes == null ? "" : notes;
        TmfEventField sourceInstanceField = new TmfEventField(BtfColumnNames.SOURCE_INSTANCE.toString(), (Object)sourceInstance, null);
        TmfEventField targetInstanceField = new TmfEventField(BtfColumnNames.TARGET_INSTANCE.toString(), (Object)targetInstance, null);
        TmfEventField eventField = new TmfEventField(BtfColumnNames.EVENT.toString(), (Object)event, (ITmfEventField[])BTFPayload.getFieldDescription(event));
        TmfEventField notesField = new TmfEventField(BtfColumnNames.NOTES.toString(), (Object)notesString, null);
        TmfEventField retField = new TmfEventField(":root:", null, (ITmfEventField[])new TmfEventField[]{eventField, sourceInstanceField, targetInstanceField, notesField});
        return retField;
    }
}

