/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiEmptyAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableClass;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartNumericalDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartStringDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartTimestampDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractDoubleResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.AbstractLongResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.INumericalResolver;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.IStringResolver;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;

public class LamiResultTable
implements IDataChartProvider<LamiTableEntry> {
    private final LamiTimeRange fTimeRange;
    private final LamiTableClass fTableClass;
    private final List<LamiTableEntry> fEntries;
    private final List<IDataChartDescriptor<LamiTableEntry, ?>> fDescriptors;

    public LamiResultTable(LamiTimeRange timeRange, LamiTableClass tableClass, Iterable<LamiTableEntry> entries) {
        this.fTimeRange = timeRange;
        this.fTableClass = tableClass;
        this.fEntries = ImmutableList.copyOf(entries);
        this.fDescriptors = new ArrayList();
        for (LamiTableEntryAspect aspect : this.getTableClass().getAspects()) {
            if (aspect instanceof LamiEmptyAspect) continue;
            if (aspect.isContinuous()) {
                if (aspect.isTimeStamp()) {
                    this.fDescriptors.add((IDataChartDescriptor<LamiTableEntry, ?>)new DataChartTimestampDescriptor(aspect.getName(), (INumericalResolver)new LamiDataLongResolver(aspect)));
                    continue;
                }
                if (aspect.isTimeDuration()) {
                    this.fDescriptors.add((IDataChartDescriptor<LamiTableEntry, ?>)new DataChartNumericalDescriptor(aspect.getName(), (INumericalResolver)new LamiDataDoubleResolver(aspect), aspect.getUnits()));
                    continue;
                }
                this.fDescriptors.add((IDataChartDescriptor<LamiTableEntry, ?>)new DataChartNumericalDescriptor(aspect.getName(), (INumericalResolver)new LamiDataDoubleResolver(aspect)));
                continue;
            }
            this.fDescriptors.add((IDataChartDescriptor<LamiTableEntry, ?>)new DataChartStringDescriptor(aspect.getName(), (IStringResolver)new LamiDataStringResolver(aspect)));
        }
    }

    public String getName() {
        return this.getTableClass().getTableTitle();
    }

    public Stream<@NonNull LamiTableEntry> getSource() {
        return (Stream)NonNullUtils.checkNotNull(this.fEntries.stream());
    }

    public List<IDataChartDescriptor<LamiTableEntry, ?>> getDataDescriptors() {
        return ImmutableList.copyOf(this.fDescriptors);
    }

    public LamiTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    public LamiTableClass getTableClass() {
        return this.fTableClass;
    }

    public List<LamiTableEntry> getEntries() {
        return this.fEntries;
    }

    private final class LamiDataDoubleResolver
    extends AbstractDoubleResolver<LamiTableEntry> {
        LamiTableEntryAspect fAspect;

        public LamiDataDoubleResolver(LamiTableEntryAspect aspect) {
            this.fAspect = aspect;
        }

        public Function<LamiTableEntry, @Nullable Double> getMapper() {
            return o -> {
                Number res = this.fAspect.resolveNumber((LamiTableEntry)o);
                if (res == null) {
                    return null;
                }
                return res.doubleValue();
            };
        }
    }

    private final class LamiDataLongResolver
    extends AbstractLongResolver<LamiTableEntry> {
        LamiTableEntryAspect fAspect;

        public LamiDataLongResolver(LamiTableEntryAspect aspect) {
            this.fAspect = aspect;
        }

        public Function<LamiTableEntry, @Nullable Long> getMapper() {
            return o -> {
                Number res = this.fAspect.resolveNumber((LamiTableEntry)o);
                if (res == null) {
                    return null;
                }
                return res.longValue();
            };
        }
    }

    private final class LamiDataStringResolver
    implements IStringResolver<LamiTableEntry> {
        LamiTableEntryAspect fAspect;

        public LamiDataStringResolver(LamiTableEntryAspect aspect) {
            this.fAspect = aspect;
        }

        public Function<@NonNull LamiTableEntry, @Nullable String> getMapper() {
            return o -> this.fAspect.resolveString((LamiTableEntry)o);
        }
    }
}

