/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public abstract class FilterImpl
implements Filter {
    private transient String filterString;

    public static FilterImpl newInstance(String filterString) throws InvalidSyntaxException {
        return FilterImpl.newInstance(filterString, false);
    }

    public static FilterImpl newInstance(String filterString, boolean debug) throws InvalidSyntaxException {
        return new Parser(filterString, debug).parse();
    }

    FilterImpl() {
    }

    @Override
    public boolean match(ServiceReference<?> reference) {
        return this.matches0(reference != null ? ServiceReferenceMap.asMap(reference) : Collections.emptyMap());
    }

    @Override
    public boolean match(Dictionary<String, ?> dictionary) {
        return this.matches0(dictionary != null ? new CaseInsensitiveDictionaryMap(dictionary) : Collections.emptyMap());
    }

    @Override
    public boolean matchCase(Dictionary<String, ?> dictionary) {
        return this.matches0(dictionary != null ? DictionaryMap.asMap(dictionary) : Collections.emptyMap());
    }

    @Override
    public boolean matches(Map<String, ?> map) {
        return this.matches0(map != null ? map : Collections.emptyMap());
    }

    abstract boolean matches0(Map<String, ?> var1);

    @Override
    public String toString() {
        String result = this.filterString;
        if (result == null) {
            this.filterString = result = this.normalize(new StringBuilder()).toString();
        }
        return result;
    }

    abstract StringBuilder normalize(StringBuilder var1);

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getRequiredObjectClass() {
        return this.getPrimaryKeyValue("objectClass");
    }

    public String getPrimaryKeyValue(String primaryKey) {
        return null;
    }

    public List<FilterImpl> getChildren() {
        return Collections.emptyList();
    }

    public String[] getAttributes() {
        ArrayList<String> results = new ArrayList<String>();
        this.getAttributesInternal(results);
        return results.toArray(new String[0]);
    }

    abstract void getAttributesInternal(List<String> var1);

    public Map<String, String> getStandardOSGiAttributes(String ... versions) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, Range> versionAttrs = new HashMap<String, Range>();
        if (versions != null) {
            String[] stringArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                String versionAttr = stringArray[n2];
                versionAttrs.put(versionAttr, null);
                ++n2;
            }
        }
        this.addAttributes(result, versionAttrs, false);
        for (Map.Entry entry : versionAttrs.entrySet()) {
            Range range = (Range)entry.getValue();
            if (range == null) continue;
            result.put((String)entry.getKey(), range.toString());
        }
        return result;
    }

    abstract void addAttributes(Map<String, String> var1, Map<String, Range> var2, boolean var3);

    static final class And
    extends FilterImpl {
        private final FilterImpl[] operands;

        And(FilterImpl[] operands) {
            this.operands = operands;
        }

        @Override
        boolean matches0(Map<String, ?> map) {
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl operand = filterImplArray[n2];
                if (!operand.matches0(map)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append('&');
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl operand = filterImplArray[n2];
                operand.normalize(sb);
                ++n2;
            }
            return sb.append(')');
        }

        @Override
        public String getPrimaryKeyValue(String primaryKey) {
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                String result;
                FilterImpl operand = filterImplArray[n2];
                if (operand instanceof Equal && (result = operand.getPrimaryKeyValue(primaryKey)) != null) {
                    return result;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public List<FilterImpl> getChildren() {
            return new ArrayList<FilterImpl>(Arrays.asList(this.operands));
        }

        @Override
        void getAttributesInternal(List<String> results) {
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl operand = filterImplArray[n2];
                operand.getAttributesInternal(results);
                ++n2;
            }
        }

        @Override
        void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl operand = filterImplArray[n2];
                operand.addAttributes(attributes, versionAttrs, false);
                ++n2;
            }
        }
    }

    static final class Approx
    extends Equal {
        final String approx;

        Approx(String attr, String value, boolean debug) {
            super(attr, value, debug);
            this.approx = Approx.approxString(value);
        }

        @Override
        String operation() {
            return "APPROX";
        }

        @Override
        String value() {
            return this.approx;
        }

        @Override
        boolean compare_String(String string) {
            string = Approx.approxString(string);
            return string.equalsIgnoreCase(this.approx);
        }

        @Override
        boolean compare_Character(char charval) {
            char charval2;
            try {
                charval2 = this.approx.charAt(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            return charval == charval2 || Character.toUpperCase(charval) == Character.toUpperCase(charval2) || Character.toLowerCase(charval) == Character.toLowerCase(charval2);
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append(this.attr).append('~').append('=');
            return Approx.encodeValue(sb, this.approx).append(')');
        }

        static String approxString(String input) {
            boolean changed = false;
            char[] output = input.toCharArray();
            int cursor = 0;
            char[] cArray = output;
            int n = output.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (Character.isWhitespace(c)) {
                    changed = true;
                } else {
                    output[cursor] = c;
                    ++cursor;
                }
                ++n2;
            }
            return changed ? new String(output, 0, cursor) : input;
        }

        @Override
        public String getPrimaryKeyValue(String primaryKey) {
            return null;
        }

        @Override
        public Map<String, String> getStandardOSGiAttributes(String ... versions) {
            throw new IllegalArgumentException("Invalid filter for standard OSGi Attributes: " + this.operation());
        }
    }

    private static final class DictionaryMap
    extends AbstractMap<String, Object>
    implements Map<String, Object> {
        private final Dictionary<String, ?> dictionary;

        static Map<String, ?> asMap(Dictionary<String, ?> dictionary) {
            if (dictionary instanceof Map) {
                Map coerced = (Map)((Object)dictionary);
                return coerced;
            }
            return new DictionaryMap(dictionary);
        }

        DictionaryMap(Dictionary<String, ?> dictionary) {
            this.dictionary = Objects.requireNonNull(dictionary);
        }

        @Override
        public Object get(Object key) {
            return this.dictionary.get(key);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    static class Equal
    extends Item {
        final String value;

        Equal(String attr, String value, boolean debug) {
            super(attr, debug);
            this.value = value;
        }

        @Override
        String operation() {
            return "EQUAL";
        }

        @Override
        String value() {
            return this.value;
        }

        boolean comparison(int compare) {
            return compare == 0;
        }

        @Override
        boolean compare_String(String string) {
            return this.comparison(string == this.value ? 0 : string.compareTo(this.value));
        }

        @Override
        boolean compare_Version(Version value1) {
            try {
                Version version2 = Version.valueOf(this.value);
                return this.comparison(value1.compareTo(version2));
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        boolean compare_Boolean(boolean boolval) {
            boolean boolval2 = Boolean.parseBoolean(this.value.trim());
            return this.comparison(Boolean.compare(boolval, boolval2));
        }

        @Override
        boolean compare_Byte(byte byteval) {
            byte byteval2;
            try {
                byteval2 = Byte.parseByte(this.value.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return this.comparison(Byte.compare(byteval, byteval2));
        }

        @Override
        boolean compare_Character(char charval) {
            char charval2;
            try {
                charval2 = this.value.charAt(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            return this.comparison(Character.compare(charval, charval2));
        }

        @Override
        boolean compare_Double(double doubleval) {
            double doubleval2;
            try {
                doubleval2 = Double.parseDouble(this.value.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return this.comparison(Double.compare(doubleval, doubleval2));
        }

        @Override
        boolean compare_Float(float floatval) {
            float floatval2;
            try {
                floatval2 = Float.parseFloat(this.value.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return this.comparison(Float.compare(floatval, floatval2));
        }

        @Override
        boolean compare_Integer(int intval) {
            int intval2;
            try {
                intval2 = Integer.parseInt(this.value.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return this.comparison(Integer.compare(intval, intval2));
        }

        @Override
        boolean compare_Long(long longval) {
            long longval2;
            try {
                longval2 = Long.parseLong(this.value.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return this.comparison(Long.compare(longval, longval2));
        }

        @Override
        boolean compare_Short(short shortval) {
            short shortval2;
            try {
                shortval2 = Short.parseShort(this.value.trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            return this.comparison(Short.compare(shortval, shortval2));
        }

        @Override
        boolean compare_Comparable(Comparable<Object> value1) {
            Object value2 = this.valueOf(value1.getClass());
            if (value2 == null) {
                return false;
            }
            try {
                return this.comparison(value1.compareTo(value2));
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        boolean compare_Unknown(Object value1) {
            Object value2 = this.valueOf(value1.getClass());
            if (value2 == null) {
                return false;
            }
            try {
                return value1.equals(value2);
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append(this.attr).append('=');
            return Equal.encodeValue(sb, this.value).append(')');
        }

        Object valueOf(Class<?> target) {
            block12: {
                Constructor<?> constructor;
                block11: {
                    Method method;
                    try {
                        method = target.getMethod("valueOf", String.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        break block11;
                    }
                    if (Modifier.isStatic(method.getModifiers()) && target.isAssignableFrom(method.getReturnType())) {
                        Equal.setAccessible(method);
                        try {
                            return method.invoke(null, this.value.trim());
                        }
                        catch (Error e) {
                            throw e;
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                }
                try {
                    constructor = target.getConstructor(String.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    break block12;
                }
                Equal.setAccessible(constructor);
                try {
                    return constructor.newInstance(this.value.trim());
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            return null;
        }

        private static void setAccessible(final AccessibleObject accessible) {
            if (!accessible.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        accessible.setAccessible(true);
                        return null;
                    }
                });
            }
        }

        @Override
        public String getPrimaryKeyValue(String primaryKey) {
            if (this.attr.equalsIgnoreCase(primaryKey)) {
                return this.value;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            if (!versionAttrs.containsKey(this.attr)) {
                attributes.put(this.attr, this.value);
                return;
            } else {
                Range currentRange = versionAttrs.get(this.attr);
                if (currentRange != null) {
                    if (!not) throw new IllegalStateException("Invalid range for: " + this.attr);
                    currentRange.addExclude(Version.valueOf(this.value));
                    return;
                } else {
                    currentRange = new Range();
                    Version version = Version.valueOf(this.value);
                    currentRange.setLeft('[', version);
                    currentRange.setRight(']', version);
                    versionAttrs.put(this.attr, currentRange);
                }
            }
        }
    }

    static final class GreaterEqual
    extends Equal {
        GreaterEqual(String attr, String value, boolean debug) {
            super(attr, value, debug);
        }

        @Override
        String operation() {
            return "GREATER";
        }

        @Override
        boolean comparison(int compare) {
            return compare >= 0;
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append(this.attr).append('>').append('=');
            return GreaterEqual.encodeValue(sb, this.value).append(')');
        }

        @Override
        public String getPrimaryKeyValue(String primaryKey) {
            return null;
        }

        @Override
        public Map<String, String> getStandardOSGiAttributes(String ... versions) {
            throw new IllegalArgumentException("Invalid filter for standard OSGi Attributes: " + this.operation());
        }

        @Override
        void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            if (!versionAttrs.containsKey(this.attr)) {
                throw new IllegalStateException("Invalid attribute: " + this.attr);
            }
            Range currentRange = versionAttrs.get(this.attr);
            if (currentRange == null) {
                currentRange = new Range();
                versionAttrs.put(this.attr, currentRange);
            }
            if (not) {
                if (!currentRange.setRight(')', Version.valueOf(this.value))) {
                    throw new IllegalStateException("range end is already processed for attribute: " + this.attr);
                }
            } else if (!currentRange.setLeft('[', Version.valueOf(this.value))) {
                throw new IllegalStateException("range start is already processed for attribute: " + this.attr);
            }
        }
    }

    static abstract class Item
    extends FilterImpl {
        final boolean debug;
        final String attr;

        Item(String attr, boolean debug) {
            this.attr = attr;
            this.debug = debug;
        }

        @Override
        boolean matches0(Map<String, ?> map) {
            return this.compare(map.get(this.attr));
        }

        abstract String operation();

        abstract String value();

        private boolean compare(Object value1) {
            if (this.debug) {
                if (value1 == null) {
                    Debug.println("compare(" + value1 + "," + this.value() + ")");
                } else if (!value1.getClass().isArray() && !(value1 instanceof Collection)) {
                    Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                }
            }
            if (value1 == null) {
                return false;
            }
            if (value1 instanceof String) {
                return this.compare_String((String)value1);
            }
            if (value1 instanceof Version) {
                return this.compare_Version((Version)value1);
            }
            Class<?> clazz = value1.getClass();
            if (clazz.isArray()) {
                Class<?> type = clazz.getComponentType();
                if (type.isPrimitive()) {
                    return this.compare_PrimitiveArray(type, value1);
                }
                return this.compare_ObjectArray((Object[])value1);
            }
            if (value1 instanceof Collection) {
                return this.compare_Collection((Collection)value1);
            }
            if (value1 instanceof Integer) {
                return this.compare_Integer((Integer)value1);
            }
            if (value1 instanceof Long) {
                return this.compare_Long((Long)value1);
            }
            if (value1 instanceof Byte) {
                return this.compare_Byte((Byte)value1);
            }
            if (value1 instanceof Short) {
                return this.compare_Short((Short)value1);
            }
            if (value1 instanceof Character) {
                return this.compare_Character(((Character)value1).charValue());
            }
            if (value1 instanceof Float) {
                return this.compare_Float(((Float)value1).floatValue());
            }
            if (value1 instanceof Double) {
                return this.compare_Double((Double)value1);
            }
            if (value1 instanceof Boolean) {
                return this.compare_Boolean((Boolean)value1);
            }
            if (value1 instanceof Comparable) {
                Comparable comparable = (Comparable)value1;
                return this.compare_Comparable(comparable);
            }
            return this.compare_Unknown(value1);
        }

        private boolean compare_Collection(Collection<?> collection) {
            for (Object value1 : collection) {
                if (!this.compare(value1)) continue;
                return true;
            }
            return false;
        }

        private boolean compare_ObjectArray(Object[] array) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object value1 = objectArray[n2];
                if (this.compare(value1)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean compare_PrimitiveArray(Class<?> type, Object primarray) {
            if (Integer.TYPE.isAssignableFrom(type)) {
                int[] array;
                int[] nArray = array = (int[])primarray;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    int value1 = nArray[n2];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Integer(value1)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                long[] array;
                long[] lArray = array = (long[])primarray;
                int n = array.length;
                int n3 = 0;
                while (n3 < n) {
                    long value1 = lArray[n3];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Long(value1)) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            if (Byte.TYPE.isAssignableFrom(type)) {
                byte[] array;
                byte[] byArray = array = (byte[])primarray;
                int n = array.length;
                int n4 = 0;
                while (n4 < n) {
                    byte value1 = byArray[n4];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Byte(value1)) {
                        return true;
                    }
                    ++n4;
                }
                return false;
            }
            if (Short.TYPE.isAssignableFrom(type)) {
                short[] array;
                short[] sArray = array = (short[])primarray;
                int n = array.length;
                int n5 = 0;
                while (n5 < n) {
                    short value1 = sArray[n5];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Short(value1)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            if (Character.TYPE.isAssignableFrom(type)) {
                char[] array;
                char[] cArray = array = (char[])primarray;
                int n = array.length;
                int n6 = 0;
                while (n6 < n) {
                    char value1 = cArray[n6];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Character(value1)) {
                        return true;
                    }
                    ++n6;
                }
                return false;
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                float[] array;
                float[] fArray = array = (float[])primarray;
                int n = array.length;
                int n7 = 0;
                while (n7 < n) {
                    float value1 = fArray[n7];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Float(value1)) {
                        return true;
                    }
                    ++n7;
                }
                return false;
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                double[] array;
                double[] dArray = array = (double[])primarray;
                int n = array.length;
                int n8 = 0;
                while (n8 < n) {
                    double value1 = dArray[n8];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Double(value1)) {
                        return true;
                    }
                    ++n8;
                }
                return false;
            }
            if (Boolean.TYPE.isAssignableFrom(type)) {
                boolean[] array;
                boolean[] blArray = array = (boolean[])primarray;
                int n = array.length;
                int n9 = 0;
                while (n9 < n) {
                    boolean value1 = blArray[n9];
                    if (this.debug) {
                        Debug.println(String.valueOf(this.operation()) + "(" + value1 + "," + this.value() + ")");
                    }
                    if (this.compare_Boolean(value1)) {
                        return true;
                    }
                    ++n9;
                }
                return false;
            }
            return false;
        }

        boolean compare_String(String string) {
            return false;
        }

        boolean compare_Version(Version value1) {
            return false;
        }

        boolean compare_Comparable(Comparable<Object> value1) {
            return false;
        }

        boolean compare_Unknown(Object value1) {
            return false;
        }

        boolean compare_Boolean(boolean boolval) {
            return false;
        }

        boolean compare_Byte(byte byteval) {
            return false;
        }

        boolean compare_Character(char charval) {
            return false;
        }

        boolean compare_Double(double doubleval) {
            return false;
        }

        boolean compare_Float(float floatval) {
            return false;
        }

        boolean compare_Integer(int intval) {
            return false;
        }

        boolean compare_Long(long longval) {
            return false;
        }

        boolean compare_Short(short shortval) {
            return false;
        }

        static StringBuilder encodeValue(StringBuilder sb, String value) {
            int i = 0;
            int len = value.length();
            while (i < len) {
                char c = value.charAt(i);
                switch (c) {
                    case '(': 
                    case ')': 
                    case '*': 
                    case '\\': {
                        sb.append('\\');
                    }
                }
                sb.append(c);
                ++i;
            }
            return sb;
        }

        @Override
        void getAttributesInternal(List<String> results) {
            results.add(this.attr);
        }

        @Override
        void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            attributes.put(this.attr, this.value());
        }
    }

    static final class LessEqual
    extends Equal {
        LessEqual(String attr, String value, boolean debug) {
            super(attr, value, debug);
        }

        @Override
        String operation() {
            return "LESS";
        }

        @Override
        boolean comparison(int compare) {
            return compare <= 0;
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append(this.attr).append('<').append('=');
            return LessEqual.encodeValue(sb, this.value).append(')');
        }

        @Override
        public String getPrimaryKeyValue(String primaryKey) {
            return null;
        }

        @Override
        public Map<String, String> getStandardOSGiAttributes(String ... versions) {
            throw new IllegalArgumentException("Invalid filter for standard OSGi Attributes: " + this.operation());
        }

        @Override
        void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            if (!versionAttrs.containsKey(this.attr)) {
                throw new IllegalStateException("Invalid attribute: " + this.attr);
            }
            Range currentRange = versionAttrs.get(this.attr);
            if (currentRange == null) {
                currentRange = new Range();
                versionAttrs.put(this.attr, currentRange);
            }
            if (not) {
                if (!currentRange.setLeft('(', Version.valueOf(this.value))) {
                    throw new IllegalStateException("range start is already processed for attribute: " + this.attr);
                }
            } else if (!currentRange.setRight(']', Version.valueOf(this.value))) {
                throw new IllegalStateException("range end is already processed for attribute: " + this.attr);
            }
        }
    }

    static final class Not
    extends FilterImpl {
        private final FilterImpl operand;

        Not(FilterImpl operand) {
            this.operand = operand;
        }

        @Override
        boolean matches0(Map<String, ?> map) {
            return !this.operand.matches0(map);
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append('!');
            this.operand.normalize(sb);
            return sb.append(')');
        }

        @Override
        void getAttributesInternal(List<String> results) {
            this.operand.getAttributesInternal(results);
        }

        @Override
        public Map<String, String> getStandardOSGiAttributes(String ... versions) {
            throw new IllegalArgumentException("Invalid filter for standard OSGi Attributes: NOT");
        }

        @Override
        void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            this.operand.addAttributes(attributes, versionAttrs, true);
        }
    }

    static final class Or
    extends FilterImpl {
        private final FilterImpl[] operands;

        Or(FilterImpl[] operands) {
            this.operands = operands;
        }

        @Override
        boolean matches0(Map<String, ?> map) {
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl operand = filterImplArray[n2];
                if (operand.matches0(map)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append('|');
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl operand = filterImplArray[n2];
                operand.normalize(sb);
                ++n2;
            }
            return sb.append(')');
        }

        @Override
        public List<FilterImpl> getChildren() {
            return new ArrayList<FilterImpl>(Arrays.asList(this.operands));
        }

        @Override
        void getAttributesInternal(List<String> results) {
            FilterImpl[] filterImplArray = this.operands;
            int n = this.operands.length;
            int n2 = 0;
            while (n2 < n) {
                FilterImpl operand = filterImplArray[n2];
                operand.getAttributesInternal(results);
                ++n2;
            }
        }

        @Override
        public Map<String, String> getStandardOSGiAttributes(String ... versions) {
            throw new IllegalArgumentException("Invalid filter for standard OSGi Attributes: OR");
        }

        @Override
        void addAttributes(Map<String, String> attributes, Map<String, Range> versionAttrs, boolean not) {
            throw new IllegalStateException("Invalid filter for standard OSGi requirements: OR");
        }
    }

    private static final class Parser {
        private final boolean debug;
        private final String filterstring;
        private final char[] filterChars;
        private int pos;

        Parser(String filterstring, boolean debug) {
            this.debug = debug;
            this.filterstring = filterstring;
            this.filterChars = filterstring.toCharArray();
            this.pos = 0;
        }

        FilterImpl parse() throws InvalidSyntaxException {
            FilterImpl filter;
            try {
                filter = this.parse_filter();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InvalidSyntaxException(Msg.FILTER_TERMINATED_ABRUBTLY, this.filterstring, e);
            }
            if (this.pos != this.filterChars.length) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_TRAILING_CHARACTERS, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return filter;
        }

        private FilterImpl parse_filter() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_LEFTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            FilterImpl filter = this.parse_filtercomp();
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != ')') {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_RIGHTPAREN, this.filterstring.substring(this.pos)), this.filterstring);
            }
            ++this.pos;
            this.skipWhiteSpace();
            return filter;
        }

        private FilterImpl parse_filtercomp() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            char c = this.filterChars[this.pos];
            switch (c) {
                case '&': {
                    ++this.pos;
                    return this.parse_and();
                }
                case '|': {
                    ++this.pos;
                    return this.parse_or();
                }
                case '!': {
                    ++this.pos;
                    return this.parse_not();
                }
            }
            return this.parse_item();
        }

        private FilterImpl parse_and() throws InvalidSyntaxException {
            int lookahead = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = lookahead - 1;
                return this.parse_item();
            }
            ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl child = this.parse_filter();
                operands.add(child);
            }
            return new And(operands.toArray(new FilterImpl[0]));
        }

        private FilterImpl parse_or() throws InvalidSyntaxException {
            int lookahead = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = lookahead - 1;
                return this.parse_item();
            }
            ArrayList<FilterImpl> operands = new ArrayList<FilterImpl>(10);
            while (this.filterChars[this.pos] == '(') {
                FilterImpl child = this.parse_filter();
                operands.add(child);
            }
            return new Or(operands.toArray(new FilterImpl[0]));
        }

        private FilterImpl parse_not() throws InvalidSyntaxException {
            int lookahead = this.pos;
            this.skipWhiteSpace();
            if (this.filterChars[this.pos] != '(') {
                this.pos = lookahead - 1;
                return this.parse_item();
            }
            FilterImpl child = this.parse_filter();
            return new Not(child);
        }

        private FilterImpl parse_item() throws InvalidSyntaxException {
            String attr = this.parse_attr();
            this.skipWhiteSpace();
            switch (this.filterChars[this.pos]) {
                case '~': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new Approx(attr, this.parse_value(), this.debug);
                }
                case '>': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new GreaterEqual(attr, this.parse_value(), this.debug);
                }
                case '<': {
                    if (this.filterChars[this.pos + 1] != '=') break;
                    this.pos += 2;
                    return new LessEqual(attr, this.parse_value(), this.debug);
                }
                case '=': {
                    String single;
                    if (this.filterChars[this.pos + 1] == '*') {
                        int oldpos = this.pos;
                        this.pos += 2;
                        this.skipWhiteSpace();
                        if (this.filterChars[this.pos] == ')') {
                            return new Present(attr, this.debug);
                        }
                        this.pos = oldpos;
                    }
                    ++this.pos;
                    String[] substrings = this.parse_substring();
                    int length = substrings.length;
                    if (length == 0) {
                        return new Equal(attr, "", this.debug);
                    }
                    if (length == 1 && (single = substrings[0]) != null) {
                        return new Equal(attr, single, this.debug);
                    }
                    return new Substring(attr, substrings, this.debug);
                }
            }
            throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_OPERATOR, this.filterstring.substring(this.pos)), this.filterstring);
        }

        private String parse_attr() throws InvalidSyntaxException {
            this.skipWhiteSpace();
            int begin = this.pos;
            int end = this.pos;
            char c = this.filterChars[this.pos];
            while (c != '~' && c != '<' && c != '>' && c != '=' && c != '(' && c != ')') {
                ++this.pos;
                if (!Character.isWhitespace(c)) {
                    end = this.pos;
                }
                c = this.filterChars[this.pos];
            }
            int length = end - begin;
            if (length == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_ATTR, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return new String(this.filterChars, begin, length);
        }

        private String parse_value() throws InvalidSyntaxException {
            StringBuilder sb = new StringBuilder(this.filterChars.length - this.pos);
            block5: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        break block5;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block5;
                    }
                }
                break;
            }
            if (sb.length() == 0) {
                throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_MISSING_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
            }
            return sb.toString();
        }

        private String[] parse_substring() throws InvalidSyntaxException {
            StringBuilder sb = new StringBuilder(this.filterChars.length - this.pos);
            ArrayList<String> operands = new ArrayList<String>(10);
            block6: while (true) {
                char c = this.filterChars[this.pos];
                switch (c) {
                    case ')': {
                        if (sb.length() <= 0) break block6;
                        operands.add(sb.toString());
                        break block6;
                    }
                    case '(': {
                        throw new InvalidSyntaxException(NLS.bind(Msg.FILTER_INVALID_VALUE, this.filterstring.substring(this.pos)), this.filterstring);
                    }
                    case '*': {
                        if (sb.length() > 0) {
                            operands.add(sb.toString());
                        }
                        sb.setLength(0);
                        operands.add(null);
                        ++this.pos;
                        continue block6;
                    }
                    case '\\': {
                        ++this.pos;
                        c = this.filterChars[this.pos];
                    }
                    default: {
                        sb.append(c);
                        ++this.pos;
                        continue block6;
                    }
                }
                break;
            }
            return operands.toArray(new String[0]);
        }

        private void skipWhiteSpace() {
            int length = this.filterChars.length;
            while (this.pos < length && Character.isWhitespace(this.filterChars[this.pos])) {
                ++this.pos;
            }
        }
    }

    static final class Present
    extends Item {
        Present(String attr, boolean debug) {
            super(attr, debug);
        }

        @Override
        boolean matches0(Map<String, ?> map) {
            if (this.debug) {
                Debug.println("PRESENT(" + this.attr + ")");
            }
            return map.get(this.attr) != null;
        }

        @Override
        String operation() {
            return "PRESENT";
        }

        @Override
        String value() {
            return "*";
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            return sb.append('(').append(this.attr).append('=').append('*').append(')');
        }
    }

    static class Range {
        private char leftRule = '\u0000';
        private Version leftVersion;
        private Version rightVersion;
        private char rightRule = '\u0000';
        private Collection<Version> excludes = new ArrayList<Version>(0);

        Range() {
        }

        public String toString() {
            if (this.rightVersion == null) {
                return this.leftVersion.toString();
            }
            return String.valueOf(this.leftRule) + this.leftVersion.toString() + ',' + this.rightVersion.toString() + this.rightRule;
        }

        void addExclude(Version exclude) {
            this.excludes.add(exclude);
            this.setLeft(this.leftRule, this.leftVersion);
            this.setRight(this.rightRule, this.rightVersion);
        }

        boolean setLeft(char leftRule, Version leftVersion) {
            if (this.leftVersion != null && this.leftVersion != leftVersion) {
                return false;
            }
            this.leftRule = (char)(this.excludes.contains(leftVersion) ? 40 : (int)leftRule);
            this.leftVersion = leftVersion;
            return true;
        }

        boolean setRight(char rightRule, Version rightVersion) {
            if (this.rightVersion != null && this.rightVersion != rightVersion) {
                return false;
            }
            this.rightRule = (char)(this.excludes.contains(rightVersion) ? 41 : (int)rightRule);
            this.rightVersion = rightVersion;
            return true;
        }
    }

    private static final class ServiceReferenceMap
    extends AbstractMap<String, Object>
    implements Map<String, Object> {
        private final ServiceReference<?> reference;

        static Map<String, ?> asMap(ServiceReference<?> reference) {
            if (reference instanceof ServiceReferenceImpl) {
                return ((ServiceReferenceImpl)reference).getRegistration().getProperties();
            }
            return new ServiceReferenceMap(reference);
        }

        ServiceReferenceMap(ServiceReference<?> reference) {
            this.reference = Objects.requireNonNull(reference);
        }

        @Override
        public Object get(Object key) {
            return this.reference.getProperty((String)key);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Substring
    extends Item {
        final String[] substrings;

        Substring(String attr, String[] substrings, boolean debug) {
            super(attr, debug);
            this.substrings = substrings;
        }

        @Override
        String operation() {
            return "SUBSTRING";
        }

        @Override
        String value() {
            return this.value(new StringBuilder()).toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean compare_String(String string) {
            int pos = 0;
            int i = 0;
            int size = this.substrings.length;
            while (i < size) {
                String substr = this.substrings[i];
                if (i + 1 < size) {
                    if (substr == null) {
                        String substr2 = this.substrings[i + 1];
                        if (substr2 != null) {
                            int index;
                            if (this.debug) {
                                Debug.println("indexOf(\"" + substr2 + "\"," + pos + ")");
                            }
                            if ((index = string.indexOf(substr2, pos)) == -1) {
                                return false;
                            }
                            pos = index + substr2.length();
                            if (i + 2 < size) {
                                ++i;
                            }
                        }
                    } else {
                        int len = substr.length();
                        if (this.debug) {
                            Debug.println("regionMatches(" + pos + ",\"" + substr + "\")");
                        }
                        if (!string.regionMatches(pos, substr, 0, len)) return false;
                        pos += len;
                    }
                } else {
                    if (substr == null) {
                        return true;
                    }
                    if (!this.debug) return string.endsWith(substr);
                    Debug.println("regionMatches(" + pos + "," + substr + ")");
                    return string.endsWith(substr);
                }
                ++i;
            }
            return true;
        }

        @Override
        StringBuilder normalize(StringBuilder sb) {
            sb.append('(').append(this.attr).append('=');
            return this.value(sb).append(')');
        }

        private StringBuilder value(StringBuilder sb) {
            String[] stringArray = this.substrings;
            int n = this.substrings.length;
            int n2 = 0;
            while (n2 < n) {
                String substr = stringArray[n2];
                if (substr == null) {
                    sb.append('*');
                } else {
                    Substring.encodeValue(sb, substr);
                }
                ++n2;
            }
            return sb;
        }
    }
}

