/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;

public class AvailableIUPatternFilter
extends PatternFilter {
    boolean checkName;
    boolean checkDescription;
    boolean checkVersion;
    boolean checkId = false;
    String patternString;

    public AvailableIUPatternFilter(IUColumnConfig[] columnConfig) {
        IUColumnConfig[] iUColumnConfigArray = columnConfig;
        int n = columnConfig.length;
        int n2 = 0;
        while (n2 < n) {
            IUColumnConfig element = iUColumnConfigArray[n2];
            int field = element.getColumnType();
            switch (field) {
                case 0: {
                    this.checkId = true;
                    break;
                }
                case 1: {
                    this.checkName = true;
                    break;
                }
                case 5: {
                    this.checkDescription = true;
                    break;
                }
                case 2: {
                    this.checkVersion = true;
                    break;
                }
            }
            ++n2;
        }
    }

    public boolean isElementSelectable(Object element) {
        return element instanceof IIUElement && !(element instanceof CategoryElement);
    }

    public void setPattern(String patternString) {
        super.setPattern(patternString);
        this.patternString = patternString;
    }

    protected boolean isParentMatch(Viewer viewer, Object element) {
        if (this.patternString == null || this.patternString.length() == 0) {
            return true;
        }
        return super.isParentMatch(viewer, element);
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (element instanceof CategoryElement) {
            return false;
        }
        String text = null;
        if (element instanceof IIUElement) {
            IInstallableUnit iu = ((IIUElement)element).getIU();
            if (this.checkName) {
                text = iu.getProperty("org.eclipse.equinox.p2.name", null);
                if (text != null && this.wordMatches(text)) {
                    return true;
                }
                text = iu.getProperty("org.eclipse.equinox.p2.description", null);
                if (text != null && this.wordMatches(text)) {
                    return true;
                }
            }
            if ((this.checkId || this.checkName && text == null) && this.wordMatches(text = iu.getId())) {
                return true;
            }
            if (!this.checkName && this.checkDescription && (text = iu.getProperty("org.eclipse.equinox.p2.description", null)) != null && this.wordMatches(text)) {
                return true;
            }
            if (this.checkVersion && this.wordMatches(text = iu.getVersion().toString())) {
                return true;
            }
        }
        return false;
    }
}

