/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.execution.graph;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsInterruptContext;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;

public class OsSystemModel {
    private final Table<String, Integer, HostThread> fCurrentTids = HashBasedTable.create();
    private final Table<String, Integer, Deque<OsInterruptContext>> fIntCtxStacks = HashBasedTable.create();
    private final Map<HostThread, OsWorker> fWorkerMap = new HashMap<HostThread, OsWorker>();
    private final Map<Integer, OsWorker> fSwapperWorkers = new HashMap<Integer, OsWorker>();

    public void cacheTidOnCpu(Integer cpu, HostThread ht) {
        this.fCurrentTids.put((Object)ht.getHost(), (Object)cpu, (Object)ht);
    }

    public @Nullable OsWorker getWorkerOnCpu(String host, Integer cpu) {
        HostThread ht = (HostThread)this.fCurrentTids.get((Object)host, (Object)cpu);
        if (ht == null) {
            return null;
        }
        return this.findWorker(ht, cpu);
    }

    @Deprecated
    public @Nullable OsWorker findWorker(HostThread ht) {
        return this.fWorkerMap.get(ht);
    }

    public @Nullable OsWorker findWorker(HostThread ht, @Nullable Integer cpu) {
        if (ht.getTid() == 0 && cpu != null) {
            return this.fSwapperWorkers.get(cpu);
        }
        return this.fWorkerMap.get(ht);
    }

    @Deprecated
    public void addWorker(OsWorker worker) {
        this.fWorkerMap.put(worker.getHostThread(), worker);
    }

    public void addWorker(OsWorker worker, @Nullable Integer cpu) {
        if (worker.getHostThread().getTid() == 0 && cpu != null) {
            this.fSwapperWorkers.put(cpu, worker);
        } else {
            this.fWorkerMap.put(worker.getHostThread(), worker);
        }
    }

    public Collection<OsWorker> getWorkers() {
        return this.fWorkerMap.values();
    }

    public void pushContextStack(String hostId, Integer cpu, OsInterruptContext interruptCtx) {
        ArrayDeque<OsInterruptContext> stack = (ArrayDeque<OsInterruptContext>)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            stack = new ArrayDeque<OsInterruptContext>();
            this.fIntCtxStacks.put((Object)hostId, (Object)cpu, stack);
        }
        stack.addFirst(interruptCtx);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public OsInterruptContext peekContextStack(String hostId, Integer cpu) {
        @NonNull Deque stack = (Deque)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            return OsInterruptContext.DEFAULT_CONTEXT;
        }
        if (stack.isEmpty()) {
            return OsInterruptContext.DEFAULT_CONTEXT;
        }
        return Objects.requireNonNull((OsInterruptContext)stack.peekFirst());
    }

    public @Nullable OsInterruptContext popContextStack(String hostId, Integer cpu) {
        Deque stack = (Deque)this.fIntCtxStacks.get((Object)hostId, (Object)cpu);
        if (stack == null) {
            return null;
        }
        if (stack.isEmpty()) {
            return null;
        }
        return (OsInterruptContext)stack.removeFirst();
    }
}

