/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDFixedFacetImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.w3c.dom.Element;

public abstract class XSDMinFacetImpl
extends XSDFixedFacetImpl
implements XSDMinFacet {
    protected static final Object VALUE_EDEFAULT = null;
    protected Object value = VALUE_EDEFAULT;
    protected static final boolean INCLUSIVE_EDEFAULT = false;
    protected static final boolean EXCLUSIVE_EDEFAULT = false;

    protected XSDMinFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_MIN_FACET;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldValue, this.value));
        }
    }

    public Boolean getInclusive() {
        return this.isInclusive() ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isInclusive() {
        return false;
    }

    public Boolean getExclusive() {
        return this.isExclusive() ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isExclusive() {
        return false;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getValue();
            }
            case 12: {
                return this.isInclusive();
            }
            case 13: {
                return this.isExclusive();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setValue(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 12: {
                return this.isInclusive();
            }
            case 13: {
                return this.isExclusive();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public void validate() {
        XSDMinInclusiveFacet xsdMinInclusiveFacet;
        XSDDiagnostic xsdDiagnostic;
        super.validate();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        XSDMaxFacet xsdMaxFacet = xsdSimpleTypeDefinition.getMaxFacet();
        if (xsdMaxFacet != null) {
            int comparison = xsdSimpleTypeDefinition.compareValues(this.getValue(), xsdMaxFacet.getValue());
            if (xsdMaxFacet.isInclusive() == this.isInclusive() ? comparison > 0 : comparison >= 0) {
                xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", String.valueOf(this.getFacetName()) + (xsdMaxFacet.isInclusive() == this.isInclusive() ? "-less-than-equal-to-" : "-less-than-") + xsdMaxFacet.getFacetName(), this.getElement(), "value", new Object[]{this.getLexicalValue(), xsdMaxFacet.getLexicalValue()});
                xsdDiagnostic.getComponents().add((Object)xsdMaxFacet);
            }
        }
        if (this.isExclusive() && (xsdMinInclusiveFacet = xsdSimpleTypeDefinition.getMinInclusiveFacet()) != null) {
            xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "minInclusive-minExclusive", this.getElement(), "value", new Object[0]);
            xsdDiagnostic.getComponents().add((Object)xsdMinInclusiveFacet);
        }
    }

    protected void validateValue() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
        XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        if (baseTypeDefinition != null) {
            Element theElement = this.getElement();
            if (this.getLexicalValue() == null) {
                this.createRequiredAttributeDiagnostic("http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), theElement, "value");
            } else {
                XSDSimpleTypeDefinitionImpl.AssessmentImpl assessment = (XSDSimpleTypeDefinitionImpl.AssessmentImpl)baseTypeDefinition.assess(theElement, this.getLexicalValue());
                Collection<XSDDiagnostic> allDiagnostics = assessment.getDiagnostics();
                if (!allDiagnostics.isEmpty()) {
                    if (this.isExclusive()) {
                        Iterator<XSDDiagnostic> i = allDiagnostics.iterator();
                        while (i.hasNext()) {
                            XSDDiagnostic xsdDiagnostic = i.next();
                            XSDConcreteComponent primaryComponent = xsdDiagnostic.getPrimaryComponent();
                            if (!(primaryComponent instanceof XSDMinExclusiveFacet) || !baseTypeDefinition.equalLiterals(theElement, this.getLexicalValue(), theElement, ((XSDMinExclusiveFacet)primaryComponent).getLexicalValue())) continue;
                            i.remove();
                        }
                    }
                    assessment.assignDiagnostics(this, theElement, "value");
                    this.getDiagnostics().addAll(allDiagnostics);
                }
            }
        }
    }

    protected boolean restrictionMatch(XSDFixedFacet xsdFixedFacet) {
        return xsdFixedFacet instanceof XSDMaxExclusiveFacet || xsdFixedFacet instanceof XSDMinExclusiveFacet;
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        int comparison = xsdSimpleTypeDefinition.compareValues(this.getValue(), xsdFixedFacet.getEffectiveValue());
        if (xsdFixedFacet instanceof XSDMinExclusiveFacet ? comparison < 0 : comparison >= 0) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", String.valueOf(this.getFacetName()) + (xsdFixedFacet instanceof XSDMinExclusiveFacet ? "-valid-restriction.2" : "-valid-restriction.4"), this.getElement(), "value", new Object[]{this.getLexicalValue(), xsdFixedFacet.getLexicalValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add((Object)xsdFixedFacet);
        }
    }
}

