/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.advanced;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.bidi.StructuredTextProcessor;
import org.eclipse.equinox.bidi.StructuredTextTypeHandlerFactory;
import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.StructuredTextImpl;

public final class StructuredTextExpertFactory {
    private static final String defaultSeparators = StructuredTextProcessor.getDefaultSeparators();
    private static Map<String, IStructuredTextExpert> sharedDefaultExperts = new HashMap<String, IStructuredTextExpert>();
    private static Map<String, Map<StructuredTextEnvironment, IStructuredTextExpert>> sharedExperts = new HashMap<String, Map<StructuredTextEnvironment, IStructuredTextExpert>>();
    private static IStructuredTextExpert defaultExpert;

    private StructuredTextExpertFactory() {
    }

    public static IStructuredTextExpert getExpert() {
        if (defaultExpert == null) {
            StructuredTextTypeHandler handler = new StructuredTextTypeHandler(defaultSeparators);
            defaultExpert = new StructuredTextImpl(handler, StructuredTextEnvironment.DEFAULT, false);
        }
        return defaultExpert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStructuredTextExpert getExpert(String type) {
        IStructuredTextExpert expert;
        Map<String, IStructuredTextExpert> map = sharedDefaultExperts;
        synchronized (map) {
            expert = sharedDefaultExperts.get(type);
            if (expert == null) {
                StructuredTextTypeHandler handler = StructuredTextTypeHandlerFactory.getHandler(type);
                if (handler == null) {
                    throw new IllegalArgumentException("Invalid type argument");
                }
                expert = new StructuredTextImpl(handler, StructuredTextEnvironment.DEFAULT, false);
                sharedDefaultExperts.put(type, expert);
            }
        }
        return expert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStructuredTextExpert getExpert(String type, StructuredTextEnvironment environment) {
        IStructuredTextExpert expert;
        if (environment == null) {
            environment = StructuredTextEnvironment.DEFAULT;
        }
        Map<String, Map<StructuredTextEnvironment, IStructuredTextExpert>> map = sharedExperts;
        synchronized (map) {
            Map<StructuredTextEnvironment, IStructuredTextExpert> experts = sharedExperts.get(type);
            if (experts == null) {
                experts = new HashMap<StructuredTextEnvironment, IStructuredTextExpert>();
                sharedExperts.put(type, experts);
            }
            if ((expert = experts.get(environment)) == null) {
                StructuredTextTypeHandler handler = StructuredTextTypeHandlerFactory.getHandler(type);
                if (handler == null) {
                    throw new IllegalArgumentException("Invalid type argument");
                }
                expert = new StructuredTextImpl(handler, environment, false);
                experts.put(environment, expert);
            }
        }
        return expert;
    }

    public static IStructuredTextExpert getStatefulExpert(String type) {
        return StructuredTextExpertFactory.getStatefulExpert(type, StructuredTextEnvironment.DEFAULT);
    }

    public static IStructuredTextExpert getStatefulExpert(String type, StructuredTextEnvironment environment) {
        StructuredTextTypeHandler handler = StructuredTextTypeHandlerFactory.getHandler(type);
        if (handler == null) {
            throw new IllegalArgumentException("Invalid type argument");
        }
        return StructuredTextExpertFactory.getStatefulExpert(handler, environment);
    }

    public static IStructuredTextExpert getStatefulExpert(StructuredTextTypeHandler handler, StructuredTextEnvironment environment) {
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        if (environment == null) {
            environment = StructuredTextEnvironment.DEFAULT;
        }
        return new StructuredTextImpl(handler, environment, true);
    }
}

