/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.Map;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.ISourceProviderListener;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractSourceProvider
implements ISourceProvider {
    protected static boolean DEBUG = Policy.DEBUG_SOURCES;
    private final ListenerList<ISourceProviderListener> listeners = new ListenerList(1);

    @Override
    public final void addSourceProviderListener(ISourceProviderListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        this.listeners.add((Object)listener);
    }

    protected final void fireSourceChanged(int sourcePriority, String sourceName, Object sourceValue) {
        for (ISourceProviderListener listener : this.listeners) {
            listener.sourceChanged(sourcePriority, sourceName, sourceValue);
        }
    }

    protected final void fireSourceChanged(int sourcePriority, Map sourceValuesByName) {
        for (ISourceProviderListener listener : this.listeners) {
            listener.sourceChanged(sourcePriority, sourceValuesByName);
        }
    }

    protected final void logDebuggingInfo(String message) {
        if (DEBUG && message != null) {
            Tracing.printTrace((String)"SOURCES", (String)message);
        }
    }

    @Override
    public final void removeSourceProviderListener(ISourceProviderListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null");
        }
        this.listeners.remove((Object)listener);
    }

    public void initialize(IServiceLocator locator) {
    }
}

