/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.e4.migration.PerspectiveBuilder;
import org.eclipse.ui.internal.e4.migration.PerspectiveReader;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.osgi.service.event.EventHandler;

public class ImportExportPespectiveHandler {
    private static final String PERSPECTIVE_SUFFIX_4X = "_e4persp";
    private static final String PERSPECTIVE_SUFFIX_3X = "_persp";
    private static final String ASCII_ENCODING = "ASCII";
    private static final String TRIMS_KEY = "trims";
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private Logger logger;
    @Inject
    @Preference(nodePath="org.eclipse.ui.workbench")
    private IEclipsePreferences preferences;
    @Inject
    private IEclipseContext context;
    @Inject
    private PerspectiveRegistry perspectiveRegistry;
    private EventHandler importPreferencesEnd;
    private EventHandler exportPreferencesBegin;
    private EventHandler exportPreferencesEnd;
    private IEclipsePreferences.IPreferenceChangeListener preferenceListener;
    private boolean ignoreEvents;
    private List<MPerspective> exportedPersps = new ArrayList<MPerspective>();
    private List<String> importedPersps = new ArrayList<String>();
    private Map<String, String> minMaxPersistedState;

    @PostConstruct
    private void init() {
        this.initializeEventHandlers();
        this.preferences.addPreferenceChangeListener(this.preferenceListener);
        this.eventBroker.subscribe("org/eclipse/ui/internal/wizards/preferences/export/begin", this.exportPreferencesBegin);
        this.eventBroker.subscribe("org/eclipse/ui/internal/wizards/preferences/export/end", this.exportPreferencesEnd);
        this.eventBroker.subscribe("org/eclipse/ui/internal/wizards/preferences/import/end", this.importPreferencesEnd);
    }

    @PreDestroy
    private void dispose() {
        this.preferences.removePreferenceChangeListener(this.preferenceListener);
        this.eventBroker.unsubscribe(this.exportPreferencesBegin);
        this.eventBroker.unsubscribe(this.exportPreferencesEnd);
        this.eventBroker.unsubscribe(this.importPreferencesEnd);
    }

    private void importPerspective4x(IEclipsePreferences.PreferenceChangeEvent event) {
        this.importedPersps.add(event.getKey());
        MPerspective perspective = null;
        try {
            perspective = this.perspFromString((String)event.getNewValue());
            this.addShowInTags(perspective);
        }
        catch (IOException e) {
            this.logError(event, e);
        }
        this.addPerspectiveToWorkbench(perspective);
    }

    private void addShowInTags(MPerspective perspective) {
        String targetId;
        ArrayList<String> showInTags;
        if (perspective != null && (showInTags = PerspectiveBuilder.getShowInPartFromRegistry(targetId = this.getOriginalId(perspective.getElementId()))) != null) {
            ArrayList<String> newTags = new ArrayList<String>();
            for (String showIn : showInTags) {
                newTags.add("persp.showIn:" + showIn);
            }
            perspective.getTags().addAll(newTags);
        }
    }

    private String getOriginalId(String id) {
        int index = id.lastIndexOf(46);
        if (index == -1) {
            return id;
        }
        return id.substring(0, index);
    }

    private void importPerspective3x(IEclipsePreferences.PreferenceChangeEvent event) {
        MPerspective perspective;
        block5: {
            this.importedPersps.add(event.getKey());
            StringReader reader = new StringReader((String)event.getNewValue());
            perspective = null;
            IEclipseContext childContext = this.context.createChild();
            try {
                try {
                    childContext.set(PerspectiveReader.class, (Object)new PerspectiveReader(XMLMemento.createReadRoot(reader)));
                    perspective = ((PerspectiveBuilder)ContextInjectionFactory.make(PerspectiveBuilder.class, (IEclipseContext)childContext)).createPerspective();
                }
                catch (WorkbenchException e) {
                    this.logError(event, (Exception)((Object)e));
                    reader.close();
                    childContext.dispose();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                reader.close();
                childContext.dispose();
                throw throwable;
            }
            reader.close();
            childContext.dispose();
        }
        this.addPerspectiveToWorkbench(perspective);
    }

    private void addPerspectiveToWorkbench(MPerspective perspective) {
        if (perspective == null) {
            return;
        }
        IPerspectiveDescriptor perspToOverwrite = this.perspectiveRegistry.findPerspectiveWithLabel(perspective.getLabel());
        if (perspToOverwrite == null) {
            this.perspectiveRegistry.addPerspective(perspective);
            this.importToolbarsLocation(perspective);
            return;
        }
        String perspToOverwriteId = perspToOverwrite.getId();
        if (!perspective.getElementId().equals(perspToOverwriteId)) {
            perspective.setElementId(perspToOverwriteId);
        }
        this.perspectiveRegistry.deletePerspective(perspToOverwrite);
        this.perspectiveRegistry.addPerspective(perspective);
        this.importToolbarsLocation(perspective);
    }

    private void logError(IEclipsePreferences.PreferenceChangeEvent event, Exception e) {
        this.logger.error((Throwable)e, String.format("Cannot read perspective \"%s\" from preferences", event.getKey()));
    }

    private void copyPerspToPreferences(MPerspective persp) throws IOException {
        MPerspective perspClone = (MPerspective)this.modelService.cloneElement((MUIElement)persp, null);
        this.exportToolbarsLocation(perspClone);
        String perspAsString = this.perspToString(perspClone);
        this.preferences.put(String.valueOf(perspClone.getLabel()) + PERSPECTIVE_SUFFIX_4X, perspAsString);
    }

    private void exportToolbarsLocation(MPerspective persp) {
        Map<String, String> minMaxPersState = this.getMinMaxPersistedState();
        if (minMaxPersState == null) {
            return;
        }
        String trimsData = minMaxPersState.get(persp.getElementId());
        persp.getPersistedState().put(TRIMS_KEY, trimsData);
    }

    private void importToolbarsLocation(MPerspective persp) {
        String trimsData = (String)persp.getPersistedState().get(TRIMS_KEY);
        if (trimsData == null || trimsData.trim().isEmpty()) {
            return;
        }
        persp.getPersistedState().remove(TRIMS_KEY);
        Map<String, String> minMaxPersState = this.getMinMaxPersistedState();
        if (minMaxPersState == null) {
            return;
        }
        minMaxPersState.put(persp.getElementId(), trimsData);
    }

    private Map<String, String> getMinMaxPersistedState() {
        if (this.minMaxPersistedState != null) {
            return this.minMaxPersistedState;
        }
        for (MAddon addon : this.application.getAddons()) {
            if (!"MinMax Addon".equals(addon.getElementId())) continue;
            this.minMaxPersistedState = addon.getPersistedState();
            break;
        }
        return this.minMaxPersistedState;
    }

    private String perspToString(MPerspective persp) throws IOException {
        Resource resource = new E4XMIResourceFactory().createResource(null);
        resource.getContents().add((Object)((EObject)persp));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("E4_FILTER_PERSISTED_STATE", Boolean.TRUE);
            resource.save((OutputStream)output, options);
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "Cannot close output stream");
            }
        }
        resource.getContents().clear();
        return new String(output.toByteArray(), ASCII_ENCODING);
    }

    private MPerspective perspFromString(String perspAsString) throws IOException {
        Resource resource = new E4XMIResourceFactory().createResource(null);
        ByteArrayInputStream input = new ByteArrayInputStream(perspAsString.getBytes(ASCII_ENCODING));
        try {
            resource.load((InputStream)input, null);
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "Cannot close input stream");
            }
        }
        MPerspective perspective = (MPerspective)resource.getContents().get(0);
        resource.getContents().clear();
        return perspective;
    }

    private void copyPerspsToPreferences() {
        for (MUIElement snippet : this.application.getSnippets()) {
            if (!(snippet instanceof MPerspective)) continue;
            MPerspective persp = (MPerspective)snippet;
            this.exportedPersps.add(persp);
        }
        this.ignoreEvents = true;
        for (MPerspective persp : this.exportedPersps) {
            try {
                this.copyPerspToPreferences(persp);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, String.format("Cannot save perspective \"%s\" to preferences", persp.getElementId()));
            }
        }
        this.ignoreEvents = false;
    }

    private void removeExportedPreferences() {
        this.ignoreEvents = true;
        for (MPerspective persp : this.exportedPersps) {
            this.preferences.remove(String.valueOf(persp.getLabel()) + PERSPECTIVE_SUFFIX_4X);
        }
        this.ignoreEvents = false;
        this.exportedPersps.clear();
    }

    private void removeImportedPreferences() {
        this.ignoreEvents = true;
        for (String key : this.importedPersps) {
            this.preferences.remove(key);
        }
        this.ignoreEvents = false;
        this.importedPersps.clear();
        this.preferences.remove("perspectives");
    }

    private void initializeEventHandlers() {
        this.importPreferencesEnd = event -> this.removeImportedPreferences();
        this.exportPreferencesBegin = event -> this.copyPerspsToPreferences();
        this.exportPreferencesEnd = event -> this.removeExportedPreferences();
        this.preferenceListener = event -> {
            if (this.ignoreEvents) {
                return;
            }
            if (event.getKey().endsWith(PERSPECTIVE_SUFFIX_4X)) {
                this.importPerspective4x(event);
            } else if (event.getKey().endsWith(PERSPECTIVE_SUFFIX_3X)) {
                this.importPerspective3x(event);
            }
        };
    }
}

