/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.markers;

import com.google.common.collect.Range;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerConfigXmlParser;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.junit.Assert;
import org.junit.Test;

public class MarkerConfigXmlParserTest {
    private static final String XML_CONTENT = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"10\" unit=\"ms\" range=\"0..4095\" offset=\"0\">      <submarker name=\"Submarker A-1-1\" label=\"A-1-1 %d\" id=\"submarker.a.1.1\" color=\"#000000\" range=\"0..99\">        <submarker name=\"Submarker A-1-1-1\" label=\"A-1-1-1 %d\" id=\"submarker.a.1.1.1\" range=\"0..9\">        </submarker>      </submarker>    </marker>    <marker name=\"Marker A-2\" label=\"A-2 %d\" id=\"marker.a.2\" referenceid=\"ref.a.2\" color=\"#ff0000\" period=\"20\" unit=\"us\" range=\"0..\" offset=\"0\">    </marker>    <marker name=\"Marker A-3\" label=\"A-3 %d\" id=\"marker.a.3\" referenceid=\"ref.a.3\" color=\"#00ff00\" period=\"2.5\" unit=\"ns\" range=\"0..\" offset=\"0\">      <segments name=\"Submarker A-3-1\">        <segment label=\"A-3-1-a %d\" id=\"marker.a.3.1.a\" color=\"#aaaaaa\" length=\"1\"/>        <segment label=\"A-3-1-b %d\" id=\"marker.a.3.1.b\" color=\"#bbbbbb\" length=\"2\"/>      </segments>    </marker>  </marker-set>  <marker-set name=\"Set B\" id=\"set.b\">    <marker name=\"Marker B-1\" label=\"B-1 %d\" id=\"marker.b.1\" referenceid=\"ref.b.1\" color=\"#010203\" period=\"1000\" unit=\"cycles\" range=\"1..\" offset=\"5\">      <submarker name=\"Submarker B-1-1\" label=\"B-1-1 %d\" id=\"submarker.b.1.1\" range=\"1..10\">      </submarker>      <submarker name=\"Submarker B-1-2\" label=\"B-1-2 %d\" id=\"submarker.b.1.2\" range=\"1..100\">      </submarker>    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_PERIOD_STRING = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"abc\" unit=\"ms\" range=\"0..4095\" offset=\"0\">    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_PERIOD_ZERO = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"0\" unit=\"ms\" range=\"0..4095\" offset=\"0\">    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_PERIOD_NEGATIVE = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"-1\" unit=\"ms\" range=\"0..4095\" offset=\"0\">    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_UNIT = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"10\" unit=\"qwerty\" range=\"0..4095\" offset=\"0\">    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_RANGE = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"10\" unit=\"ms\" range=\"4095..0\" offset=\"0\">    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_OFFSET = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"10\" unit=\"ms\" range=\"0..4095\" offset=\"abc\">    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_SUBMARKER_RANGE = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"10\" unit=\"ms\" range=\"4095..0\" offset=\"0\">      <submarker name=\"Submarker A-1-1\" label=\"A-1-1 %d\" id=\"submarker.a.1.1\" color=\"#000000\" range=\"0..\"/>    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_SEGMENT_COUNT = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"10\" unit=\"ms\" range=\"4095..0\" offset=\"0\">      <segments name=\"Submarker A-1-1\">      </segments>    </marker>  </marker-set></marker-sets>";
    private static final String XML_CONTENT_INVALID_SEGMENT_LENGTH = "<marker-sets>  <marker-set name=\"Set A\" id=\"set.a\">    <marker name=\"Marker A-1\" label=\"A-1 %d\" id=\"marker.a.1\" referenceid=\"ref.a.1\" color=\"#0000ff\" period=\"10\" unit=\"ms\" range=\"4095..0\" offset=\"0\">      <segments name=\"Submarker A-1-1\">        <segment label=\"A-1-1-a %d\" id=\"marker.a.1.1.a\" color=\"#aaaaaa\" length=\"0\"/>      </segments>    </marker>  </marker-set></marker-sets>";

    @Test
    public void testParse() throws IOException {
        File file = File.createTempFile("markers", "xml");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileWriter fw = new FileWriter(file);){
                fw.write(XML_CONTENT);
                fw.flush();
                List markerSets = MarkerConfigXmlParser.parse((String)file.getAbsolutePath());
                Assert.assertEquals((long)2L, (long)markerSets.size());
                MarkerSet setA = (MarkerSet)markerSets.get(0);
                Assert.assertEquals((Object)"Set A", (Object)setA.getName());
                Assert.assertEquals((Object)"set.a", (Object)setA.getId());
                Assert.assertEquals((long)3L, (long)setA.getMarkers().size());
                Marker.PeriodicMarker markerA1 = (Marker.PeriodicMarker)setA.getMarkers().get(0);
                Assert.assertEquals((Object)"Marker A-1", (Object)markerA1.getName());
                Assert.assertEquals((Object)"A-1 %d", (Object)markerA1.getLabel());
                Assert.assertEquals((Object)"marker.a.1", (Object)markerA1.getId());
                Assert.assertEquals((Object)"ref.a.1", (Object)markerA1.getReferenceId());
                Assert.assertEquals((Object)"#0000ff", (Object)markerA1.getColor());
                Assert.assertEquals((double)10.0, (double)markerA1.getPeriod(), (double)0.0);
                Assert.assertEquals((Object)"ms", (Object)markerA1.getUnit());
                Assert.assertEquals((Object)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(4095L)), (Object)markerA1.getRange());
                Assert.assertEquals((long)0L, (long)markerA1.getOffset());
                Assert.assertEquals((long)1L, (long)markerA1.getSubMarkers().size());
                SubMarker.SplitMarker submarkerA11 = (SubMarker.SplitMarker)markerA1.getSubMarkers().get(0);
                Assert.assertEquals((Object)"Submarker A-1-1", (Object)submarkerA11.getName());
                Assert.assertEquals((Object)"A-1-1 %d", (Object)submarkerA11.getLabel());
                Assert.assertEquals((Object)"submarker.a.1.1", (Object)submarkerA11.getId());
                Assert.assertEquals((Object)"#000000", (Object)submarkerA11.getColor());
                Assert.assertEquals((Object)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(99L)), (Object)submarkerA11.getRange());
                Assert.assertEquals((long)1L, (long)submarkerA11.getSubMarkers().size());
                SubMarker.SplitMarker submarkerA111 = (SubMarker.SplitMarker)submarkerA11.getSubMarkers().get(0);
                Assert.assertEquals((Object)"Submarker A-1-1-1", (Object)submarkerA111.getName());
                Assert.assertEquals((Object)"A-1-1-1 %d", (Object)submarkerA111.getLabel());
                Assert.assertEquals((Object)"submarker.a.1.1.1", (Object)submarkerA111.getId());
                Assert.assertEquals((Object)"#000000", (Object)submarkerA111.getColor());
                Assert.assertEquals((Object)Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(9L)), (Object)submarkerA111.getRange());
                Assert.assertEquals((long)0L, (long)submarkerA111.getSubMarkers().size());
                Marker.PeriodicMarker markerA2 = (Marker.PeriodicMarker)setA.getMarkers().get(1);
                Assert.assertEquals((Object)"Marker A-2", (Object)markerA2.getName());
                Assert.assertEquals((Object)"A-2 %d", (Object)markerA2.getLabel());
                Assert.assertEquals((Object)"marker.a.2", (Object)markerA2.getId());
                Assert.assertEquals((Object)"ref.a.2", (Object)markerA2.getReferenceId());
                Assert.assertEquals((Object)"#ff0000", (Object)markerA2.getColor());
                Assert.assertEquals((double)20.0, (double)markerA2.getPeriod(), (double)0.0);
                Assert.assertEquals((Object)"us", (Object)markerA2.getUnit());
                Assert.assertEquals((Object)Range.atLeast((Comparable)Long.valueOf(0L)), (Object)markerA2.getRange());
                Assert.assertEquals((long)0L, (long)markerA2.getOffset());
                Assert.assertEquals((long)0L, (long)markerA2.getSubMarkers().size());
                Marker.PeriodicMarker markerA3 = (Marker.PeriodicMarker)setA.getMarkers().get(2);
                Assert.assertEquals((Object)"Marker A-3", (Object)markerA3.getName());
                Assert.assertEquals((Object)"A-3 %d", (Object)markerA3.getLabel());
                Assert.assertEquals((Object)"marker.a.3", (Object)markerA3.getId());
                Assert.assertEquals((Object)"ref.a.3", (Object)markerA3.getReferenceId());
                Assert.assertEquals((Object)"#00ff00", (Object)markerA3.getColor());
                Assert.assertEquals((double)2.5, (double)markerA3.getPeriod(), (double)0.0);
                Assert.assertEquals((Object)"ns", (Object)markerA3.getUnit());
                Assert.assertEquals((Object)Range.atLeast((Comparable)Long.valueOf(0L)), (Object)markerA3.getRange());
                Assert.assertEquals((long)0L, (long)markerA3.getOffset());
                Assert.assertEquals((long)1L, (long)markerA3.getSubMarkers().size());
                SubMarker.WeightedMarker submarkerA31 = (SubMarker.WeightedMarker)markerA3.getSubMarkers().get(0);
                Assert.assertEquals((Object)"Submarker A-3-1", (Object)submarkerA31.getName());
                Assert.assertEquals((long)0L, (long)submarkerA31.getSubMarkers().size());
                Assert.assertEquals((long)2L, (long)submarkerA31.getSegments().size());
                MarkerSegment submarkerA31a = (MarkerSegment)submarkerA31.getSegments().get(0);
                Assert.assertEquals(null, (Object)submarkerA31a.getName());
                Assert.assertEquals((Object)"A-3-1-a %d", (Object)submarkerA31a.getLabel());
                Assert.assertEquals((Object)"marker.a.3.1.a", (Object)submarkerA31a.getId());
                Assert.assertEquals((Object)"#aaaaaa", (Object)submarkerA31a.getColor());
                Assert.assertEquals((long)1L, (long)submarkerA31a.getLength());
                Assert.assertEquals((long)0L, (long)submarkerA31a.getSubMarkers().size());
                MarkerSegment submarkerA31b = (MarkerSegment)submarkerA31.getSegments().get(1);
                Assert.assertEquals(null, (Object)submarkerA31b.getName());
                Assert.assertEquals((Object)"A-3-1-b %d", (Object)submarkerA31b.getLabel());
                Assert.assertEquals((Object)"marker.a.3.1.b", (Object)submarkerA31b.getId());
                Assert.assertEquals((Object)"#bbbbbb", (Object)submarkerA31b.getColor());
                Assert.assertEquals((long)2L, (long)submarkerA31b.getLength());
                Assert.assertEquals((long)0L, (long)submarkerA31b.getSubMarkers().size());
                MarkerSet setB = (MarkerSet)markerSets.get(1);
                Assert.assertEquals((Object)"Set B", (Object)setB.getName());
                Assert.assertEquals((Object)"set.b", (Object)setB.getId());
                Assert.assertEquals((long)1L, (long)setB.getMarkers().size());
                Marker.PeriodicMarker markerB1 = (Marker.PeriodicMarker)setB.getMarkers().get(0);
                Assert.assertEquals((Object)"Marker B-1", (Object)markerB1.getName());
                Assert.assertEquals((Object)"B-1 %d", (Object)markerB1.getLabel());
                Assert.assertEquals((Object)"marker.b.1", (Object)markerB1.getId());
                Assert.assertEquals((Object)"ref.b.1", (Object)markerB1.getReferenceId());
                Assert.assertEquals((Object)"#010203", (Object)markerB1.getColor());
                Assert.assertEquals((double)1000.0, (double)markerB1.getPeriod(), (double)0.0);
                Assert.assertEquals((Object)"cycles", (Object)markerB1.getUnit());
                Assert.assertEquals((Object)Range.atLeast((Comparable)Long.valueOf(1L)), (Object)markerB1.getRange());
                Assert.assertEquals((long)5L, (long)markerB1.getOffset());
                Assert.assertEquals((long)2L, (long)markerB1.getSubMarkers().size());
                SubMarker.SplitMarker submarkerB11 = (SubMarker.SplitMarker)markerB1.getSubMarkers().get(0);
                Assert.assertEquals((Object)"Submarker B-1-1", (Object)submarkerB11.getName());
                Assert.assertEquals((Object)"submarker.b.1.1", (Object)submarkerB11.getId());
                Assert.assertEquals((Object)"#010203", (Object)submarkerB11.getColor());
                Assert.assertEquals((Object)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(10L)), (Object)submarkerB11.getRange());
                Assert.assertEquals((long)0L, (long)submarkerB11.getSubMarkers().size());
                SubMarker.SplitMarker submarkerB12 = (SubMarker.SplitMarker)markerB1.getSubMarkers().get(1);
                Assert.assertEquals((Object)"Submarker B-1-2", (Object)submarkerB12.getName());
                Assert.assertEquals((Object)"submarker.b.1.2", (Object)submarkerB12.getId());
                Assert.assertEquals((Object)"#010203", (Object)submarkerB12.getColor());
                Assert.assertEquals((Object)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(100L)), (Object)submarkerB12.getRange());
                Assert.assertEquals((long)0L, (long)submarkerB12.getSubMarkers().size());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void testParseInvalidFile() {
        File file = new File("invalid");
        List markerSets = MarkerConfigXmlParser.parse((String)file.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)markerSets.size());
    }

    @Test
    public void testParseInvalidContent() throws IOException {
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_PERIOD_STRING);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_PERIOD_ZERO);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_PERIOD_NEGATIVE);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_UNIT);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_RANGE);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_OFFSET);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_SUBMARKER_RANGE);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_SEGMENT_COUNT);
        MarkerConfigXmlParserTest.testParseInvalidContent(XML_CONTENT_INVALID_SEGMENT_LENGTH);
    }

    private static void testParseInvalidContent(String content) throws IOException {
        File file = File.createTempFile("markers", "xml");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileWriter fw = new FileWriter(file);){
                fw.write(content);
                fw.flush();
                List markerSets = MarkerConfigXmlParser.parse((String)file.getAbsolutePath());
                Assert.assertEquals((long)0L, (long)markerSets.size());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void testExtensionPoint() {
        List markerSet = MarkerConfigXmlParser.getMarkerSets();
        Assert.assertEquals((String)"Extension point markers should be loaded", (long)1L, (long)markerSet.size());
        MarkerSet set = (MarkerSet)markerSet.get(0);
        Assert.assertEquals((String)"Wrong MarkerSet name", (Object)"Example", (Object)set.getName());
        Assert.assertEquals((String)"Wrong MarkerSet Id", (Object)"example.id", (Object)set.getId());
    }
}

