/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.operations;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.Messages;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;

public class NewExperimentOperation
implements IRunnableWithProgress {
    private final @NonNull String fExperimentName;
    private final @NonNull TmfExperimentFolder fExperimentFolderRoot;
    private final String fExperimentType;
    private final List<TmfTraceElement> fTraceElements;
    private @Nullable IFolder fExperimentFolder = null;
    private @NonNull IStatus fStatus = Status.OK_STATUS;

    public NewExperimentOperation(@NonNull TmfExperimentFolder experimentFolder, @NonNull String experimentName) {
        this.fExperimentFolderRoot = experimentFolder;
        this.fExperimentName = experimentName;
        this.fExperimentType = "org.eclipse.linuxtools.tmf.core.experiment.generic";
        this.fTraceElements = Collections.emptyList();
    }

    public NewExperimentOperation(@NonNull TmfExperimentFolder experimentFolder, @NonNull String experimentName, String experimentType, List<TmfTraceElement> traceElements) {
        this.fExperimentFolderRoot = experimentFolder;
        this.fExperimentName = experimentName;
        this.fExperimentType = experimentType != null ? experimentType : "org.eclipse.linuxtools.tmf.core.experiment.generic";
        this.fTraceElements = traceElements != null ? traceElements : Collections.emptyList();
    }

    public void run(IProgressMonitor monitor) {
        IFolder experimentFolder = this.createExperiment(this.fExperimentName);
        try {
            monitor.beginTask("", 1000);
            ModalContext.checkCanceled((IProgressMonitor)monitor);
            experimentFolder.create(false, true, monitor);
            IConfigurationElement ce = TmfTraceType.getTraceAttributes((String)this.fExperimentType);
            if (ce != null) {
                experimentFolder.setPersistentProperty(TmfCommonConstants.TRACETYPE, ce.getAttribute("id"));
            }
            this.fExperimentFolder = experimentFolder;
            TmfExperimentElement experimentElement = this.fExperimentFolderRoot.addExperiment(experimentFolder);
            for (TmfTraceElement trace : this.fTraceElements) {
                experimentElement.addTrace(trace, false);
            }
            experimentElement.refreshTraceType();
            experimentElement.refresh();
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException interruptedException) {
            this.setStatus(Status.CANCEL_STATUS);
            Thread.currentThread().interrupt();
        }
        catch (CoreException | InvalidRegistryObjectException e) {
            String msg = NLS.bind((String)Messages.NewExperimentOperation_CreationError, (Object)this.fExperimentName);
            Activator.getDefault().logError(msg, e);
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", msg, e));
        }
    }

    public @Nullable IFolder getExperimentFolder() {
        return this.fExperimentFolder;
    }

    private IFolder createExperiment(String experimentName) {
        IFolder expResource = this.fExperimentFolderRoot.getResource();
        IWorkspaceRoot workspaceRoot = expResource.getWorkspace().getRoot();
        IPath folderPath = expResource.getFullPath().append(experimentName);
        IFolder folder = workspaceRoot.getFolder(folderPath);
        return folder;
    }

    protected void setStatus(@NonNull IStatus status) {
        this.fStatus = status;
    }

    public @NonNull IStatus getStatus() {
        return this.fStatus;
    }
}

