/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.symbols;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.symbols.DefaultSymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProviderFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public final class SymbolProviderManager {
    private static @Nullable SymbolProviderManager INSTANCE;
    private static final String OLD_EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.ui.symbolProvider";
    private static final String EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.core.symbolProvider";
    private static final String ELEM_NAME_PROVIDER = "providerFactory";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PRIORITY = "priority";
    private final List<SymbolProviderFactoryWrapper> fProviders;
    private final Multimap<ITmfTrace, WeakReference<ISymbolProvider>> fInstances = LinkedHashMultimap.create();

    public static synchronized SymbolProviderManager getInstance() {
        SymbolProviderManager manager = INSTANCE;
        if (manager == null) {
            INSTANCE = manager = new SymbolProviderManager();
        }
        return manager;
    }

    private SymbolProviderManager() {
        this.fProviders = new ArrayList<SymbolProviderFactoryWrapper>();
        this.load(OLD_EXTENSION_POINT_ID);
        this.load(EXTENSION_POINT_ID);
        this.fProviders.sort(Comparator.comparingLong(o -> -o.priority));
    }

    private void load(String configElemPath) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(configElemPath);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element != null && ELEM_NAME_PROVIDER.equals(element.getName())) {
                try {
                    Object extension = NonNullUtils.checkNotNull((Object)element.createExecutableExtension(ATTR_CLASS));
                    int priority = 0;
                    try {
                        priority = Integer.parseInt(element.getAttribute(ATTR_PRIORITY));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.fProviders.add(new SymbolProviderFactoryWrapper((ISymbolProviderFactory)extension, priority));
                }
                catch (ClassCastException | CoreException e) {
                    Activator.logError("Exception while loading extensions", e);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ISymbolProvider> getSymbolProviders(ITmfTrace trace) {
        Multimap<ITmfTrace, WeakReference<ISymbolProvider>> multimap = this.fInstances;
        synchronized (multimap) {
            ArrayList<ISymbolProvider> symbolProviders = new ArrayList<ISymbolProvider>();
            for (WeakReference reference : this.fInstances.get((Object)trace)) {
                ISymbolProvider provider = (ISymbolProvider)reference.get();
                if (provider == null) continue;
                symbolProviders.add(provider);
            }
            if (symbolProviders.isEmpty()) {
                for (ITmfTrace subTrace : TmfTraceManager.getTraceSet(trace)) {
                    if (subTrace != trace) {
                        Collection<ISymbolProvider> traceSymbolProviders = this.getSymbolProviders(subTrace);
                        traceSymbolProviders.forEach(sp -> {
                            symbolProviders.add((ISymbolProvider)sp);
                            this.fInstances.put((Object)trace, new WeakReference<ISymbolProvider>((ISymbolProvider)sp));
                        });
                        continue;
                    }
                    for (SymbolProviderFactoryWrapper wrapper : this.fProviders) {
                        ISymbolProviderFactory factory = wrapper.factory;
                        ISymbolProvider provider = factory.createProvider(trace);
                        if (provider == null) continue;
                        symbolProviders.add(provider);
                        this.fInstances.put((Object)trace, new WeakReference<ISymbolProvider>(provider));
                    }
                }
            }
            if (symbolProviders.isEmpty()) {
                DefaultSymbolProvider defaultSymbolProvider = new DefaultSymbolProvider(trace);
                this.fInstances.put((Object)trace, new WeakReference<DefaultSymbolProvider>(defaultSymbolProvider));
                symbolProviders.add(defaultSymbolProvider);
            }
            return symbolProviders;
        }
    }

    @Deprecated
    public ISymbolProvider getSymbolProvider(ITmfTrace trace) {
        return this.getSymbolProviders(trace).iterator().next();
    }

    private static class SymbolProviderFactoryWrapper {
        public final ISymbolProviderFactory factory;
        public final int priority;

        private SymbolProviderFactoryWrapper(ISymbolProviderFactory factory, int priority) {
            this.factory = factory;
            this.priority = priority;
        }
    }
}

