/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.memory;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class UstMemoryUsageDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfTreeXYDataProvider<MemoryUsageTreeModel> {
    public static final String ID = "org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryUsageDataProvider";
    private static final AtomicLong ENTRY_IDS = new AtomicLong();
    private final BiMap<Long, Integer> fIdToQuark = HashBiMap.create();
    private @Nullable TmfModelResponse<List<MemoryUsageTreeModel>> fCached;
    private final long fTraceId = ENTRY_IDS.getAndIncrement();
    private final UstMemoryAnalysisModule fModule;

    public static @Nullable UstMemoryUsageDataProvider create(ITmfTrace trace) {
        UstMemoryAnalysisModule module = (UstMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, UstMemoryAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.memory");
        if (module != null) {
            module.schedule();
            return new UstMemoryUsageDataProvider(trace, module);
        }
        return null;
    }

    private UstMemoryUsageDataProvider(ITmfTrace trace, UstMemoryAnalysisModule module) {
        super(trace);
        this.fModule = module;
    }

    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        boolean complete;
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        long[] xValues = filter.getTimesRequested();
        Map<Integer, double[]> tempModel = this.initSeries(filter);
        long currentEnd = ss.getCurrentEndTime();
        boolean bl = complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        if (tempModel.isEmpty()) {
            return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.MemoryUsageDataProvider_Title), (long[])xValues, Collections.emptyMap(), (boolean)complete);
        }
        try {
            int i = 0;
            while (i < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i];
                if (time >= ss.getStartTime() && time <= currentEnd) {
                    List fullState = ss.queryFullState(time);
                    for (Map.Entry<Integer, double[]> entry : tempModel.entrySet()) {
                        int quark = entry.getKey();
                        int memoryAttribute = ss.optQuarkRelative(quark, new String[]{"Memory"});
                        if (memoryAttribute == -2) continue;
                        double[] values = entry.getValue();
                        Object val = ((ITmfStateInterval)fullState.get(memoryAttribute)).getValue();
                        values[i] = UstMemoryUsageDataProvider.extractValue(val);
                    }
                }
                ++i;
            }
        }
        catch (StateSystemDisposedException e) {
            return TmfCommonXAxisResponseFactory.createFailedResponse((String)e.getMessage());
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        for (Map.Entry<Integer, double[]> tempEntry : tempModel.entrySet()) {
            String name = String.valueOf(this.getTrace().getName()) + ':' + ss.getAttributeName(tempEntry.getKey().intValue());
            ySeries.put((Object)name, (Object)new YModel(name, tempEntry.getValue()));
        }
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.MemoryUsageDataProvider_Title), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private Map<Integer, double[]> initSeries(TimeQueryFilter filter) {
        if (filter instanceof SelectionTimeQueryFilter) {
            Collection selectedEntries = ((SelectionTimeQueryFilter)filter).getSelectedItems();
            HashMap<Integer, double[]> selectedSeries = new HashMap<Integer, double[]>();
            int length = filter.getTimesRequested().length;
            for (Long id : selectedEntries) {
                Integer quark = (Integer)this.fIdToQuark.get((Object)id);
                if (quark == null) continue;
                selectedSeries.put(quark, new double[length]);
            }
            return selectedSeries;
        }
        return Collections.emptyMap();
    }

    private static long extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return 0L;
    }

    public TmfModelResponse<List<MemoryUsageTreeModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        List fullState;
        if (this.fCached != null) {
            return this.fCached;
        }
        this.fModule.waitForInitialization();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        boolean isComplete = ss.waitUntilBuilt(0L);
        List tidQuarks = ss.getSubAttributes(-1, false);
        try {
            fullState = ss.queryFullState(ss.getCurrentEndTime());
        }
        catch (StateSystemDisposedException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.STATE_SYSTEM_FAILED);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new MemoryUsageTreeModel(this.fTraceId, -1L, -1, this.getTrace().getName()));
        Iterator iterator = tidQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            int memoryAttribute = ss.optQuarkRelative(quark, new String[]{"Memory"});
            int procNameQuark = ss.optQuarkRelative(quark, new String[]{"Procname"});
            if (memoryAttribute == -2 || procNameQuark == -2) continue;
            String name = String.valueOf(((ITmfStateInterval)fullState.get(procNameQuark)).getValue());
            int tid = Integer.parseInt(ss.getAttributeName(quark));
            Long id = (Long)this.fIdToQuark.inverse().get((Object)quark);
            if (id == null) {
                id = ENTRY_IDS.getAndIncrement();
                this.fIdToQuark.put((Object)id, (Object)quark);
            }
            builder.add((Object)new MemoryUsageTreeModel(id.longValue(), this.fTraceId, tid, name));
        }
        ImmutableList list = builder.build();
        if (isComplete) {
            TmfModelResponse tmfModelResponse;
            this.fCached = tmfModelResponse = new TmfModelResponse((Object)list, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            return tmfModelResponse;
        }
        return new TmfModelResponse((Object)list, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    public String getId() {
        return ID;
    }
}

