/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageView;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class CpuUsageTreeViewer
extends AbstractSelectTreeViewer {
    public CpuUsageTreeViewer(Composite parent) {
        super(parent, 4, "org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider");
        this.setLabelProvider((IBaseLabelProvider)new CpuLabelProvider());
    }

    protected void updateContent(long start, long end, boolean isSelection) {
        super.updateContent(start, end, isSelection);
    }

    protected @Nullable TimeQueryFilter getFilter(long start, long end, boolean isSelection) {
        long newStart = Long.max(start, this.getStartTime());
        long newEnd = Long.min(end, this.getEndTime());
        if (isSelection || newEnd < newStart) {
            return null;
        }
        return new SelectedCpuQueryFilter(newStart, newEnd, 2, Collections.emptyList(), CpuUsageView.getCpus(this.getTrace()));
    }

    protected ITmfTreeViewerEntry modelToTree(long start, long end, List<TmfTreeDataModel> model) {
        double time = end - start;
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        map.put(-1L, root);
        for (CpuUsageEntryModel entryModel : Iterables.filter(model, CpuUsageEntryModel.class)) {
            CpuUsageEntry cpuUsageEntry = new CpuUsageEntry(entryModel, (double)entryModel.getTime() / time);
            map.put(entryModel.getId(), (Object)cpuUsageEntry);
            TmfTreeViewerEntry parent = (TmfTreeViewerEntry)map.get(entryModel.getParentId());
            if (parent == null) continue;
            parent.addChild((TmfTreeViewerEntry)cpuUsageEntry);
        }
        return root;
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> {
            ImmutableList.Builder columns = ImmutableList.builder();
            columns.add((Object)CpuUsageTreeViewer.createColumn((String)Messages.CpuUsageComposite_ColumnProcess, Comparator.comparing(TmfTreeViewerEntry::getName)));
            Comparator<CpuUsageEntry> tidCompare = Comparator.comparingInt(c -> ((CpuUsageEntryModel)c.getModel()).getTid());
            columns.add((Object)CpuUsageTreeViewer.createColumn((String)Messages.CpuUsageComposite_ColumnTID, tidCompare));
            TmfTreeColumnData percentColumn = CpuUsageTreeViewer.createColumn((String)Messages.CpuUsageComposite_ColumnPercent, Comparator.comparingDouble(CpuUsageEntry::getPercent));
            percentColumn.setPercentageProvider(data -> ((CpuUsageEntry)((Object)((Object)((Object)data)))).getPercent());
            columns.add((Object)percentColumn);
            Comparator<CpuUsageEntry> timeCompare = Comparator.comparingLong(c -> ((CpuUsageEntryModel)c.getModel()).getTime());
            columns.add((Object)CpuUsageTreeViewer.createColumn((String)Messages.CpuUsageComposite_ColumnTime, timeCompare));
            columns.add((Object)new TmfTreeColumnData(Messages.CpuUsageComposite_ColumnLegend));
            return columns.build();
        };
    }

    protected class CpuLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected CpuLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            CpuUsageEntry obj = (CpuUsageEntry)((Object)element);
            if (columnIndex == 0) {
                return obj.getName();
            }
            if (columnIndex == 1) {
                int tid = ((CpuUsageEntryModel)obj.getModel()).getTid();
                if (tid == -2) {
                    return Messages.CpuUsageXYViewer_Total;
                }
                return Integer.toString(tid);
            }
            if (columnIndex == 2) {
                return String.format(Messages.CpuUsageComposite_TextPercent, 100.0 * obj.getPercent());
            }
            if (columnIndex == 3) {
                return NLS.bind((String)Messages.CpuUsageComposite_TextTime, (Object)((CpuUsageEntryModel)obj.getModel()).getTime());
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 4 && element instanceof CpuUsageEntry) {
                CpuUsageEntry cpuUsageEntry = (CpuUsageEntry)((Object)element);
                CpuUsageEntryModel model = (CpuUsageEntryModel)cpuUsageEntry.getModel();
                int tid = model.getTid();
                if (tid < 0) {
                    return CpuUsageTreeViewer.this.getLegendImage("total:" + model.getName());
                }
                if (CpuUsageTreeViewer.this.isChecked(element)) {
                    CpuUsageEntry parent = (CpuUsageEntry)cpuUsageEntry.getParent();
                    return CpuUsageTreeViewer.this.getLegendImage(String.valueOf(((CpuUsageEntryModel)parent.getModel()).getName()) + ':' + model.getTid());
                }
            }
            return null;
        }
    }
}

