/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPEnumeration
extends PlatformObject
implements ICPPEnumeration,
ICPPInternalBinding {
    private static final IASTName NOT_INITIALIZED = CPPASTName.NOT_INITIALIZED;
    private static final IEnumerator[] EMPTY_ENUMERATORS = new IEnumerator[0];
    private final boolean fIsScoped;
    private final IType fFixedType;
    private IASTName fDefinition = NOT_INITIALIZED;
    private IASTName[] fDeclarations = IASTName.EMPTY_NAME_ARRAY;
    private Long fMaxValue;
    private Long fMinValue;
    private ICPPEnumeration fIndexBinding;
    private boolean fSearchedIndex;

    public CPPEnumeration(ICPPASTEnumerationSpecifier spec, IType fixedType) {
        IASTName name = spec.getName();
        this.fIsScoped = spec.isScoped();
        this.fFixedType = fixedType;
        if (spec.isOpaque()) {
            this.addDeclaration(name);
        } else {
            this.addDefinition(name);
        }
        name.setBinding(this);
    }

    @Override
    public IASTNode[] getDeclarations() {
        this.fDeclarations = ArrayUtil.trim(this.fDeclarations);
        return this.fDeclarations;
    }

    @Override
    public IASTName getDefinition() {
        if (this.fDefinition == NOT_INITIALIZED) {
            return null;
        }
        return this.fDefinition;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.getADeclaration().getSimpleID();
    }

    private IASTName getADeclaration() {
        if (this.fDefinition != null && this.fDefinition != NOT_INITIALIZED) {
            return this.fDefinition;
        }
        return this.fDeclarations[0];
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getADeclaration());
    }

    @Override
    public Object clone() {
        throw new IllegalArgumentException("Enums must not be cloned");
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    @Override
    public void addDefinition(IASTNode node) {
        assert (this.fDefinition == null || this.fDefinition == NOT_INITIALIZED);
        this.fDefinition = (IASTName)node;
    }

    @Override
    public void addDeclaration(IASTNode node) {
        assert (node instanceof IASTName);
        this.fDeclarations = this.fDeclarations == null ? new IASTName[]{(IASTName)node} : ArrayUtil.append(this.fDeclarations, (IASTName)node);
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexBinding) {
            return type.isSameType(this);
        }
        return false;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        return CPPVisitor.findDeclarationOwner(this.getADeclaration(), true);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public long getMinValue() {
        if (this.fMinValue != null) {
            return this.fMinValue;
        }
        long minValue = SemanticUtil.computeMinValue(this);
        this.fMinValue = minValue;
        return minValue;
    }

    @Override
    public long getMaxValue() {
        if (this.fMaxValue != null) {
            return this.fMaxValue;
        }
        long maxValue = SemanticUtil.computeMaxValue(this);
        this.fMaxValue = maxValue;
        return maxValue;
    }

    @Override
    public boolean isScoped() {
        return this.fIsScoped;
    }

    @Override
    public IType getFixedType() {
        return this.fFixedType;
    }

    @Override
    public IEnumerator[] getEnumerators() {
        this.findDefinition();
        IASTName definition = this.getDefinition();
        if (definition == null) {
            ICPPEnumeration typeInIndex = this.getIndexBinding();
            if (typeInIndex != null) {
                return typeInIndex.getEnumerators();
            }
            return EMPTY_ENUMERATORS;
        }
        IASTEnumerationSpecifier.IASTEnumerator[] enums = ((IASTEnumerationSpecifier)definition.getParent()).getEnumerators();
        IEnumerator[] bindings = new IEnumerator[enums.length];
        int i = 0;
        while (i < enums.length) {
            bindings[i] = (IEnumerator)enums[i].getName().resolveBinding();
            ++i;
        }
        return bindings;
    }

    private ICPPEnumeration getIndexBinding() {
        IASTTranslationUnit translationUnit;
        IIndex index;
        if (!this.fSearchedIndex && (index = (translationUnit = this.getADeclaration().getTranslationUnit()).getIndex()) != null) {
            this.fIndexBinding = (ICPPEnumeration)((Object)index.adaptBinding(this));
        }
        return this.fIndexBinding;
    }

    @Override
    public ICPPScope asScope() {
        this.findDefinition();
        IASTName def = this.getDefinition();
        if (def == null) {
            ICPPEnumeration indexBinding = this.getIndexBinding();
            if (indexBinding != null) {
                return indexBinding.asScope();
            }
            def = this.getADeclaration();
        }
        return ((ICPPASTEnumerationSpecifier)def.getParent()).getScope();
    }

    private void findDefinition() {
        if (this.fDefinition == NOT_INITIALIZED) {
            FindDefinitionAction action = new FindDefinitionAction();
            IASTNode node = CPPVisitor.getContainingBlockItem(this.getADeclaration()).getParent();
            node.accept(action);
        }
    }

    public static class CPPEnumerationProblem
    extends ProblemBinding
    implements ICPPEnumeration,
    ICPPScope {
        public CPPEnumerationProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        @Override
        public IEnumerator[] getEnumerators() {
            return EMPTY_ENUMERATORS;
        }

        @Override
        public long getMinValue() {
            return 0L;
        }

        @Override
        public long getMaxValue() {
            return 0L;
        }

        @Override
        public boolean isScoped() {
            return false;
        }

        @Override
        public IType getFixedType() {
            return null;
        }

        @Override
        public ICPPScope asScope() {
            return this;
        }
    }

    private class FindDefinitionAction
    extends ASTVisitor {
        private char[] nameArray;

        private FindDefinitionAction() {
            this.nameArray = CPPEnumeration.this.getNameCharArray();
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        @Override
        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId || name instanceof ICPPASTQualifiedName) {
                return 1;
            }
            char[] c = name.getLookupKey();
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTEnumerationSpecifier && !((ICPPASTEnumerationSpecifier)parent).isOpaque() && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPEnumeration.this && CPPEnumeration.this.getDefinition() == name) {
                return 2;
            }
            return 3;
        }

        @Override
        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration) {
                return 3;
            }
            return 1;
        }

        @Override
        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTEnumerationSpecifier ? 3 : 1;
        }

        @Override
        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

