/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;

public class LamiTableEntry {
    private final List<LamiData> fValues;

    public LamiTableEntry(List<LamiData> values) {
        this.fValues = (List)NonNullUtils.checkNotNull((Object)ImmutableList.copyOf(values));
    }

    public LamiData getValue(int index) {
        return this.fValues.get(index);
    }

    public @Nullable LamiTimeRange getCorrespondingTimeRange() {
        Optional<LamiTimeRange> oTimerange = this.fValues.stream().filter(data -> data instanceof LamiTimeRange).map(data -> (LamiTimeRange)data).findFirst();
        if (oTimerange.isPresent()) {
            return oTimerange.get();
        }
        List timestamps = this.fValues.stream().filter(data -> data instanceof LamiTimestamp).map(data -> (LamiTimestamp)data).collect(Collectors.toList());
        if (timestamps.size() > 1) {
            LamiTimestamp firstTs = (LamiTimestamp)timestamps.get(0);
            LamiTimestamp secondTs = (LamiTimestamp)timestamps.get(1);
            Long firstTsValue = firstTs.getValue();
            Long secondTsValue = secondTs.getValue();
            if (firstTsValue != null && secondTsValue != null && Long.compare(firstTsValue, secondTsValue) <= 0) {
                return new LamiTimeRange(firstTs, secondTs);
            }
        }
        if (!timestamps.isEmpty()) {
            LamiTimestamp ts = (LamiTimestamp)timestamps.get(0);
            return new LamiTimeRange(ts, ts);
        }
        return null;
    }
}

