/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.dataprovider;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DataProviderManager {
    private static @Nullable DataProviderManager INSTANCE;
    private static final String EXTENSION_POINT_ID = "org.eclipse.tracecompass.tmf.core.dataprovider";
    private static final String ELEMENT_NAME_PROVIDER = "dataProviderFactory";
    private static final String ATTR_CLASS = "class";
    private List<IDataProviderFactory> fDataProviderFactories = new ArrayList<IDataProviderFactory>();
    private final Multimap<ITmfTrace, ITmfTreeDataProvider<? extends ITmfTreeDataModel>> fInstances = LinkedHashMultimap.create();

    public static synchronized DataProviderManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataProviderManager();
        }
        return INSTANCE;
    }

    private DataProviderManager() {
        this.loadDataProviders();
    }

    private void loadDataProviders() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cElement = iConfigurationElementArray[n2];
            if (cElement != null && cElement.getName().equals(ELEMENT_NAME_PROVIDER)) {
                try {
                    Object extension = cElement.createExecutableExtension(ATTR_CLASS);
                    this.fDataProviderFactories.add((IDataProviderFactory)extension);
                }
                catch (CoreException e) {
                    Activator.logError("Unable to load extensions", e);
                }
            }
            ++n2;
        }
    }

    public <T extends ITmfTreeDataProvider<? extends ITmfTreeDataModel>> @Nullable T getDataProvider(@NonNull ITmfTrace trace, String id, Class<T> dataProviderClass) {
        Collection<T> dataProvider = this.getDataProvider(trace, dataProviderClass);
        for (ITmfTreeDataProvider provider : dataProvider) {
            if (provider == null || !id.equals(provider.getId())) continue;
            return (T)provider;
        }
        return null;
    }

    public synchronized <T> Collection<T> getDataProvider(@NonNull ITmfTrace trace, Class<T> dataProviderClass) {
        ArrayList<T> dataProviders = new ArrayList<T>();
        for (ITmfTreeDataProvider dataProvider : this.fInstances.get((Object)trace)) {
            if (dataProvider == null || !dataProviderClass.isAssignableFrom(dataProvider.getClass())) continue;
            dataProviders.add(dataProviderClass.cast(dataProvider));
        }
        if (dataProviders.isEmpty()) {
            for (IDataProviderFactory providerFactory : this.fDataProviderFactories) {
                ITmfTreeDataProvider<? extends ITmfTreeDataModel> provider = providerFactory.createProvider(trace);
                if (provider == null) continue;
                this.fInstances.put((Object)trace, provider);
                if (!dataProviderClass.isAssignableFrom(provider.getClass())) continue;
                dataProviders.add(dataProviderClass.cast(provider));
            }
        }
        return dataProviders;
    }
}

