/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory.MemoryUsageTreeViewer;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.XYChartLegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;

public class MemoryUsageView
extends TmfChartView {
    private final String fProviderId;
    private final TmfXYChartSettings fSettings;

    public MemoryUsageView(String title, String providerId, TmfXYChartSettings settings) {
        super(title);
        this.fProviderId = providerId;
        this.fSettings = settings;
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        TmfFilteredXYChartViewer viewer = new TmfFilteredXYChartViewer(parent, this.fSettings, this.fProviderId){

            public @NonNull IYAppearance getSeriesAppearance(String seriesName) {
                int width = seriesName.endsWith(":total") ? 2 : 1;
                return this.getPresentationProvider().getAppearance(seriesName, "line", width);
            }
        };
        viewer.getSwtChart().getAxisSet().getYAxis(0).getTick().setFormat(DataSizeWithUnitFormat.getInstance());
        return viewer;
    }

    protected @NonNull TmfViewer createLeftChildViewer(Composite parent) {
        MemoryUsageTreeViewer fTreeViewer = new MemoryUsageTreeViewer(parent, this.fProviderId);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            fTreeViewer.traceSelected(signal);
        }
        return fTreeViewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TmfViewer tree = this.getLeftChildViewer();
        TmfXYChartViewer chart = this.getChartViewer();
        if (tree instanceof MemoryUsageTreeViewer && chart instanceof TmfFilteredXYChartViewer) {
            XYChartLegendImageProvider legendImageProvider = new XYChartLegendImageProvider((TmfCommonXAxisChartViewer)chart);
            MemoryUsageTreeViewer memoryTree = (MemoryUsageTreeViewer)tree;
            memoryTree.setTreeListener((ICheckboxTreeViewerListener)((TmfFilteredXYChartViewer)chart));
            memoryTree.setLegendImageProvider((ILegendImageProvider)legendImageProvider);
        }
    }
}

