/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.cpuusage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageEntryModel;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CpuUsageDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfTreeXYDataProvider<CpuUsageEntryModel> {
    public static final String TOTAL = "total:";
    private static final TmfModelResponse<List<CpuUsageEntryModel>> FAILED_TREE_RESPONSE = new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider";
    public static final int TOTAL_SERIES_TID = -2;
    private static final AtomicLong CPU_USAGE_ID = new AtomicLong();
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();
    private final BiMap<Long, String> fTidToName = HashBiMap.create();
    private final long fTotalId = CPU_USAGE_ID.getAndIncrement();
    private final KernelCpuUsageAnalysis fModule;
    private @Nullable ITmfStateSystem fKernelSs;

    public static @Nullable CpuUsageDataProvider create(ITmfTrace trace) {
        KernelCpuUsageAnalysis module = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        if (module != null) {
            module.schedule();
            return new CpuUsageDataProvider(trace, module);
        }
        return null;
    }

    private CpuUsageDataProvider(ITmfTrace trace, KernelCpuUsageAnalysis module) {
        super(trace);
        this.fModule = module;
    }

    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        Collection<Object> selectedThreads = Collections.emptySet();
        Set cpus = Collections.emptySet();
        if (filter instanceof SelectedCpuQueryFilter) {
            selectedThreads = ((SelectionTimeQueryFilter)filter).getSelectedItems();
            cpus = ((SelectedCpuQueryFilter)filter).getSelectedCpus();
        }
        long[] xValues = filter.getTimesRequested();
        double[] totalValues = new double[xValues.length];
        HashMap<String, double[]> selectedThreadValues = new HashMap<String, double[]>();
        for (Long l : selectedThreads) {
            String tid = (String)this.fTidToName.get((Object)l);
            if (tid == null) continue;
            selectedThreadValues.put(tid, new double[xValues.length]);
        }
        long l = Math.max(filter.getStart(), ss.getStartTime());
        long currentEnd = ss.getCurrentEndTime();
        int i = 1;
        while (i < xValues.length) {
            long time = xValues[i];
            if (time >= ss.getStartTime() && time <= currentEnd && l < time) {
                Map cpuUsageMap = Maps.filterKeys(this.fModule.getCpuUsageInRange(cpus, l, time), key -> key.startsWith("total"));
                long totalCpu = 0L;
                for (Map.Entry entry : cpuUsageMap.entrySet()) {
                    String threadName = CpuUsageDataProvider.extractThreadName((String)entry.getKey());
                    if (threadName == null) continue;
                    long cpuTime = (Long)entry.getValue();
                    totalCpu += cpuTime;
                    double[] values = (double[])selectedThreadValues.get(entry.getKey());
                    if (values == null) continue;
                    values[i] = CpuUsageDataProvider.normalize(l, time, cpuTime);
                }
                totalValues[i] = CpuUsageDataProvider.normalize(l, time, totalCpu);
                l = time;
            }
            if (monitor != null && monitor.isCanceled()) {
                return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
            }
            ++i;
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        String key2 = TOTAL + this.getTrace().getName();
        ySeries.put((Object)key2, (Object)new YModel(key2, totalValues));
        for (Map.Entry entry : selectedThreadValues.entrySet()) {
            String selectedThread = String.valueOf(this.getTrace().getName()) + ':' + CpuUsageDataProvider.extractThreadName((String)entry.getKey());
            ySeries.put((Object)selectedThread, (Object)new YModel(selectedThread, (double[])entry.getValue()));
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.CpuUsageDataProvider_title), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private static double normalize(long prevTime, long time, long value) {
        return (double)value / (double)(time - prevTime) * 100.0;
    }

    private static @Nullable String extractThreadName(String key) {
        String[] strings = key.split("/", 2);
        if (strings.length > 1 && !strings[1].equals("0")) {
            return strings[1];
        }
        return null;
    }

    public TmfModelResponse<List<CpuUsageEntryModel>> fetchTree(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        if (!(filter instanceof SelectedCpuQueryFilter)) {
            return new TmfModelResponse(Collections.emptyList(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        SelectedCpuQueryFilter cpuQueryFilter = (SelectedCpuQueryFilter)filter;
        long end = filter.getEnd();
        this.fModule.waitForInitialization();
        ITmfStateSystem ss = this.fModule.getStateSystem();
        if (ss == null) {
            return FAILED_TREE_RESPONSE;
        }
        ITmfStateSystem kernelSs = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)this.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelSs == null) {
            return FAILED_TREE_RESPONSE;
        }
        boolean complete = ss.waitUntilBuilt(0L) && kernelSs.waitUntilBuilt(0L);
        Map<String, Long> cpuUsageMap = this.fModule.getCpuUsageInRange(cpuQueryFilter.getSelectedCpus(), filter.getStart(), end);
        ArrayList<CpuUsageEntryModel> entryList = new ArrayList<CpuUsageEntryModel>();
        Map totalMap = Maps.filterKeys(cpuUsageMap, key -> key.startsWith("total"));
        long totalTime = totalMap.values().stream().mapToLong(Long::longValue).sum();
        entryList.add(new CpuUsageEntryModel(this.fTotalId, -1L, this.getTrace().getName(), -2, totalTime));
        for (Map.Entry<String, Long> entry : cpuUsageMap.entrySet()) {
            String tid;
            String[] strings;
            String key2 = entry.getKey();
            if (entry.getValue() == 0L || !key2.startsWith("total") || (strings = key2.split("/", 2)).length <= 1 || (tid = strings[1]).equals("0")) continue;
            Long id = (Long)this.fTidToName.inverse().get((Object)key2);
            if (id == null) {
                id = CPU_USAGE_ID.getAndIncrement();
                this.fTidToName.put((Object)id, (Object)key2);
            }
            entryList.add(new CpuUsageEntryModel(id, this.fTotalId, this.getProcessName(tid, filter.getStart()), Integer.parseInt(tid), entry.getValue()));
        }
        if (complete) {
            return new TmfModelResponse(entryList, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse(entryList, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    private String getProcessName(String tid, long start) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        ITmfStateSystem kernelSs = this.fKernelSs;
        if (kernelSs == null) {
            kernelSs = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)this.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        }
        if (kernelSs == null) {
            return tid;
        }
        this.fKernelSs = kernelSs;
        int execNameQuark = kernelSs.optQuarkAbsolute(new String[]{"Threads", tid, "Exec_name"});
        if (execNameQuark == -2) {
            return tid;
        }
        StateSystemUtils.QuarkIterator iterator = new StateSystemUtils.QuarkIterator(kernelSs, execNameQuark, start);
        while (iterator.hasNext()) {
            Object execNameObject = ((ITmfStateInterval)iterator.next()).getValue();
            if (!(execNameObject instanceof String)) continue;
            execName = (String)execNameObject;
            this.fProcessNameMap.put(tid, execName);
            return execName;
        }
        return tid;
    }

    public String getId() {
        return ID;
    }
}

