/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics;

import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.Statistics;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.statistics.Messages;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public abstract class AbstractSegmentsStatisticsViewer
extends AbstractTmfTreeViewer {
    private static final Format FORMATTER = new SubSecondTimeWithUnitFormat();
    private @Nullable TmfAbstractAnalysisModule fModule;
    private MenuManager fTablePopupMenuManager;
    private static final String[] COLUMN_NAMES = new String[]{(String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_LevelLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_Statistics_MinLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_MaxLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_AverageLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatisticsViewer_StandardDeviation), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatisticsViewer_Count), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatisticsViewer_Total)};

    public AbstractSegmentsStatisticsViewer(Composite parent) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new SegmentStoreStatisticsLabelProvider());
        this.fTablePopupMenuManager = new MenuManager();
        this.fTablePopupMenuManager.setRemoveAllWhenShown(true);
        this.fTablePopupMenuManager.addMenuListener(manager -> {
            TreeViewer viewer = this.getTreeViewer();
            ISelection selection = viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (manager != null) {
                    this.appendToTablePopupMenu(manager, sel);
                }
            }
        });
        Menu tablePopup = this.fTablePopupMenuManager.createContextMenu((Control)this.getTreeViewer().getTree());
        Tree tree = this.getTreeViewer().getTree();
        tree.setMenu(tablePopup);
        tree.addDisposeListener(e -> {
            if (this.fModule != null) {
                this.fModule.dispose();
            }
        });
    }

    protected abstract @Nullable TmfAbstractAnalysisModule createStatisticsAnalysiModule();

    public @Nullable TmfAbstractAnalysisModule getStatisticsAnalysisModule() {
        return this.fModule;
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            public List<@Nullable TmfTreeColumnData> getColumnData() {
                ArrayList<@Nullable TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(COLUMN_NAMES[0]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return n1.getName().compareTo(n2.getName());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[1]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Long.compare(n1.getEntry().getMin(), n2.getEntry().getMin());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[2]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Long.compare(n1.getEntry().getMax(), n2.getEntry().getMax());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[3]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Double.compare(n1.getEntry().getMean(), n2.getEntry().getMean());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[4]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Double.compare(n1.getEntry().getStdDev(), n2.getEntry().getStdDev());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[5]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Long.compare(n1.getEntry().getNbElements(), n2.getEntry().getNbElements());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[6]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Double.compare(n1.getEntry().getTotal(), n2.getEntry().getTotal());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData("");
                columns.add(column);
                return columns;
            }
        };
    }

    public void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            TmfAbstractAnalysisModule module = this.createStatisticsAnalysiModule();
            if (module == null) {
                return;
            }
            try {
                module.setTrace(trace);
                module.schedule();
                if (this.fModule != null) {
                    this.fModule.dispose();
                }
                this.fModule = module;
            }
            catch (TmfAnalysisException e) {
                Activator.getDefault().logError("Error initializing statistics analysis module", e);
            }
        }
    }

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
        Object element = sel.getFirstElement();
        if (element instanceof SegmentStoreStatisticsEntry && !(element instanceof HiddenTreeViewerEntry)) {
            final SegmentStoreStatisticsEntry segment = (SegmentStoreStatisticsEntry)((Object)element);
            Action gotoStartTime = new Action(Messages.SegmentStoreStatisticsViewer_GotoMinAction){

                public void run() {
                    ISegment minObject = (ISegment)segment.getEntry().getMinObject();
                    long start = minObject == null ? 0L : minObject.getStart();
                    long end = minObject == null ? 0L : minObject.getEnd();
                    AbstractSegmentsStatisticsViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentsStatisticsViewer.this, TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end), AbstractSegmentsStatisticsViewer.this.getTrace()));
                    AbstractSegmentsStatisticsViewer.this.updateContent(start, end, true);
                }
            };
            Action gotoEndTime = new Action(Messages.SegmentStoreStatisticsViewer_GotoMaxAction){

                public void run() {
                    ISegment maxObject = (ISegment)segment.getEntry().getMaxObject();
                    long start = maxObject == null ? 0L : maxObject.getStart();
                    long end = maxObject == null ? 0L : maxObject.getEnd();
                    AbstractSegmentsStatisticsViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentsStatisticsViewer.this, TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end), AbstractSegmentsStatisticsViewer.this.getTrace()));
                    AbstractSegmentsStatisticsViewer.this.updateContent(start, end, true);
                }
            };
            manager.add((IAction)gotoStartTime);
            manager.add((IAction)gotoEndTime);
        }
    }

    protected static String toFormattedString(double value) {
        String percentageString = String.format("%s", FORMATTER.format(value));
        return percentageString;
    }

    protected @Nullable ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        TmfAbstractAnalysisModule analysisModule = this.getStatisticsAnalysisModule();
        if (this.getTrace() == null || !(analysisModule instanceof AbstractSegmentStatisticsAnalysis)) {
            return null;
        }
        AbstractSegmentStatisticsAnalysis module = (AbstractSegmentStatisticsAnalysis)analysisModule;
        module.waitForCompletion();
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        List entryList = root.getChildren();
        if (isSelection) {
            this.setStats(start, end, entryList, module, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.setStats(start, end, entryList, module, false, (IProgressMonitor)new NullProgressMonitor());
        return root;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void setStats(long start, long end, List<ITmfTreeViewerEntry> entryList, AbstractSegmentStatisticsAnalysis module, boolean isSelection, IProgressMonitor monitor) {
        IStatistics entry;
        String label = isSelection ? this.getSelectionLabel() : this.getTotalLabel();
        IStatistics iStatistics = entry = isSelection ? module.getStatsForRange(start, end, monitor) : module.getStatsTotal();
        if (entry != null) {
            if (entry.getNbElements() == 0L) {
                return;
            }
            SegmentStoreStatisticsEntry child = new SegmentStoreStatisticsEntry((String)NonNullUtils.checkNotNull((Object)label), (IStatistics<ISegment>)entry);
            entryList.add((ITmfTreeViewerEntry)child);
            @NonNull Map perTypeStats = isSelection ? module.getStatsPerTypeForRange(start, end, monitor) : module.getStatsPerType();
            for (Map.Entry statsEntry : perTypeStats.entrySet()) {
                child.addChild(new SegmentStoreStatisticsEntry((String)statsEntry.getKey(), (IStatistics<ISegment>)((IStatistics)statsEntry.getValue())));
            }
        }
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
    }

    protected String getTypeLabel() {
        return (String)NonNullUtils.checkNotNull((Object)Messages.AbstractSegmentStoreStatisticsViewer_types);
    }

    protected String getTotalLabel() {
        return (String)NonNullUtils.checkNotNull((Object)Messages.AbstractSegmentStoreStatisticsViewer_total);
    }

    protected String getSelectionLabel() {
        return (String)NonNullUtils.checkNotNull((Object)Messages.AbstractSegmentStoreStatisticsViewer_selection);
    }

    protected class HiddenTreeViewerEntry
    extends SegmentStoreStatisticsEntry {
        public HiddenTreeViewerEntry(String name) {
            super(name, (IStatistics<ISegment>)new Statistics(s -> s.getLength()));
        }
    }

    protected class SegmentStoreStatisticsEntry
    extends TmfTreeViewerEntry {
        private final IStatistics<ISegment> fEntry;

        public SegmentStoreStatisticsEntry(String name, IStatistics<ISegment> entry) {
            super(name);
            this.fEntry = entry;
        }

        public IStatistics<ISegment> getEntry() {
            return this.fEntry;
        }
    }

    protected static class SegmentStoreStatisticsLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected SegmentStoreStatisticsLabelProvider() {
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            String value = "";
            if (element instanceof HiddenTreeViewerEntry) {
                if (columnIndex == 0) {
                    value = ((HiddenTreeViewerEntry)((Object)element)).getName();
                }
            } else if (element instanceof SegmentStoreStatisticsEntry) {
                SegmentStoreStatisticsEntry entry = (SegmentStoreStatisticsEntry)((Object)element);
                if (columnIndex == 0) {
                    return String.valueOf(entry.getName());
                }
                if (entry.getEntry().getNbElements() > 0L) {
                    if (columnIndex == 1) {
                        value = AbstractSegmentsStatisticsViewer.toFormattedString(entry.getEntry().getMin());
                    } else if (columnIndex == 2) {
                        value = String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(entry.getEntry().getMax()));
                    } else if (columnIndex == 3) {
                        value = String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(entry.getEntry().getMean()));
                    } else if (columnIndex == 4) {
                        value = String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(entry.getEntry().getStdDev()));
                    } else if (columnIndex == 5) {
                        value = String.valueOf(entry.getEntry().getNbElements());
                    } else if (columnIndex == 6) {
                        value = String.valueOf(AbstractSegmentsStatisticsViewer.toFormattedString(entry.getEntry().getTotal()));
                    }
                }
            }
            return (String)NonNullUtils.checkNotNull((Object)value);
        }
    }
}

