/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;

public abstract class Definition
implements IDefinition {
    private final String fFieldName;
    private final @NonNull ILexicalScope fPath;
    private final IDefinitionScope fDefinitionScope;
    private final @NonNull IDeclaration fDeclaration;

    public Definition(@NonNull IDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName) {
        this(declaration, definitionScope, fieldName, declaration.getPath(definitionScope, fieldName));
    }

    public Definition(@NonNull IDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName, @NonNull ILexicalScope scope) {
        this.fDeclaration = declaration;
        this.fDefinitionScope = definitionScope;
        this.fFieldName = fieldName;
        this.fPath = scope;
    }

    protected String getFieldName() {
        return this.fFieldName;
    }

    @Override
    public ILexicalScope getScopePath() {
        return this.fPath;
    }

    protected IDefinitionScope getDefinitionScope() {
        return this.fDefinitionScope;
    }

    @Override
    public IDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String toString() {
        return String.valueOf(this.fPath.getPath()) + '[' + Integer.toHexString(this.hashCode()) + ']';
    }
}

