/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.FollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.actions.UnfollowCpuAction;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.AggregateResourcesEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.ResourcesPresentationProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesView
extends AbstractTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.os.linux.views.resources";
    public static final @NonNull String RESOURCES_FOLLOW_CPU = "org.eclipse.tracecompass.analysis.os.linux.views.resources.FOLLOW_CPU";
    private static final String WILDCARD = "*";
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.ResourcesView_stateTypeName};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;

    public ResourcesView() {
        super(ID, (TimeGraphPresentationProvider)new ResourcesPresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new ResourcesFilterLabelProvider());
        this.setEntryComparator(new ResourcesEntryComparator());
        this.setAutoExpandLevel(1);
    }

    protected void fillTimeGraphEntryContextMenu(@NonNull IMenuManager menuManager) {
        ResourcesEntry resourcesEntry;
        IStructuredSelection sSel;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (sSel = (IStructuredSelection)selection).getFirstElement() instanceof ResourcesEntry && (resourcesEntry = (ResourcesEntry)sSel.getFirstElement()).getType().equals((Object)ResourcesEntry.Type.CPU)) {
            int cpu;
            TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
            Integer data = (Integer)ctx.getData(RESOURCES_FOLLOW_CPU);
            int n = cpu = data != null ? data : -1;
            if (cpu >= 0) {
                menuManager.add((IAction)new UnfollowCpuAction((TmfView)this, resourcesEntry.getId(), resourcesEntry.getTrace()));
            } else {
                menuManager.add((IAction)new FollowCpuAction((TmfView)this, resourcesEntry.getId(), resourcesEntry.getTrace()));
            }
        }
    }

    protected String getNextText() {
        return Messages.ResourcesView_nextResourceActionNameText;
    }

    protected String getNextTooltip() {
        return Messages.ResourcesView_nextResourceActionToolTipText;
    }

    protected String getPrevText() {
        return Messages.ResourcesView_previousResourceActionNameText;
    }

    protected String getPrevTooltip() {
        return Messages.ResourcesView_previousResourceActionToolTipText;
    }

    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        long startTime;
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (ssq == null) {
            return;
        }
        HashMap<Integer, ResourcesEntry> entryMap = new HashMap<Integer, ResourcesEntry>();
        long start = startTime = ssq.getStartTime();
        ResourcesEntry traceEntry = new ResourcesEntry(trace, trace.getName(), startTime, ssq.getCurrentEndTime() + 1L, 0);
        this.addToEntryList(parentTrace, Collections.singletonList(traceEntry));
        this.setStartTime(Long.min(this.getStartTime(), startTime));
        boolean complete = false;
        while (!(complete || monitor.isCanceled() || ssq.isCancelled())) {
            complete = ssq.waitUntilBuilt(500L);
            long end = ssq.getCurrentEndTime();
            if (start == end && !complete) continue;
            long endTime = end + 1L;
            this.setEndTime(Long.max(this.getEndTime(), end));
            traceEntry.updateEndTime(endTime);
            List cpuQuarks = ssq.getQuarks(new String[]{"CPUs", WILDCARD});
            ResourcesView.createCpuEntriesWithQuark(trace, ssq, entryMap, traceEntry, startTime, endTime, cpuQuarks);
            long resolution = Long.max(1L, (end - ssq.getStartTime()) / (long)this.getDisplayWidth());
            Iterable entries = Iterables.transform(entryMap.values(), e -> e);
            this.zoomEntries(entries, ssq.getStartTime(), end, resolution, monitor);
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            start = end;
        }
    }

    private static void createCpuEntriesWithQuark(@NonNull ITmfTrace trace, ITmfStateSystem ssq, Map<Integer, ResourcesEntry> entryMap, TimeGraphEntry traceEntry, long startTime, long endTime, List<Integer> cpuQuarks) {
        for (Integer cpuQuark : cpuQuarks) {
            @NonNull String cpuName = ssq.getAttributeName(cpuQuark.intValue());
            int cpu = Integer.parseInt(cpuName);
            ResourcesEntry cpuEntry = entryMap.get(cpuQuark);
            if (cpuEntry == null) {
                cpuEntry = new ResourcesEntry(cpuQuark, trace, startTime, endTime, ResourcesEntry.Type.CPU, cpu);
                entryMap.put(cpuQuark, cpuEntry);
                traceEntry.addChild((TimeGraphEntry)cpuEntry);
            } else {
                cpuEntry.updateEndTime(endTime);
            }
            List irqQuarks = ssq.getQuarks(new String[]{"CPUs", cpuName, "IRQs", WILDCARD});
            ResourcesView.createCpuInterruptEntryWithQuark(trace, ssq, entryMap, startTime, endTime, traceEntry, cpuEntry, irqQuarks, ResourcesEntry.Type.IRQ);
            List softIrqQuarks = ssq.getQuarks(new String[]{"CPUs", cpuName, "Soft_IRQs", WILDCARD});
            ResourcesView.createCpuInterruptEntryWithQuark(trace, ssq, entryMap, startTime, endTime, traceEntry, cpuEntry, softIrqQuarks, ResourcesEntry.Type.SOFT_IRQ);
        }
    }

    private static void createCpuInterruptEntryWithQuark(@NonNull ITmfTrace trace, ITmfStateSystem ssq, Map<Integer, ResourcesEntry> entryMap, long startTime, long endTime, TimeGraphEntry traceEntry, ResourcesEntry cpuEntry, List<Integer> childrenQuarks, ResourcesEntry.Type type) {
        for (Integer quark : childrenQuarks) {
            @NonNull String resourceName = ssq.getAttributeName(quark.intValue());
            int resourceId = Integer.parseInt(resourceName);
            ResourcesEntry interruptEntry = entryMap.get(quark);
            if (interruptEntry == null) {
                interruptEntry = new ResourcesEntry(quark, trace, startTime, endTime, type, resourceId);
                entryMap.put(quark, interruptEntry);
                cpuEntry.addChild(interruptEntry);
                boolean found = false;
                for (ITimeGraphEntry rootElem : traceEntry.getChildren()) {
                    AggregateResourcesEntry aggregateInterruptEntry;
                    if (!(rootElem instanceof AggregateResourcesEntry) || (aggregateInterruptEntry = (AggregateResourcesEntry)rootElem).getId() != resourceId || !aggregateInterruptEntry.getType().equals((Object)type)) continue;
                    found = true;
                    aggregateInterruptEntry.addContributor((ITimeGraphEntry)interruptEntry);
                    AggregateResourcesEntry irqCpuEntry = new AggregateResourcesEntry(trace, cpuEntry.getName(), startTime, endTime, type, cpuEntry.getId());
                    irqCpuEntry.addContributor((ITimeGraphEntry)interruptEntry);
                    aggregateInterruptEntry.addChild(irqCpuEntry);
                    break;
                }
                if (found) continue;
                AggregateResourcesEntry aggregateInterruptEntry = new AggregateResourcesEntry(trace, startTime, endTime, type, resourceId);
                aggregateInterruptEntry.addContributor((ITimeGraphEntry)interruptEntry);
                AggregateResourcesEntry irqCpuEntry = new AggregateResourcesEntry(trace, cpuEntry.getName(), startTime, endTime, type, cpuEntry.getId());
                irqCpuEntry.addContributor((ITimeGraphEntry)interruptEntry);
                aggregateInterruptEntry.addChild(irqCpuEntry);
                traceEntry.addChild((TimeGraphEntry)aggregateInterruptEntry);
                continue;
            }
            interruptEntry.updateEndTime(endTime);
        }
    }

    /*
     * Exception decompiling
     */
    protected void zoomEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Table<ITmfStateSystem, Integer, ResourcesEntry> filterGroupEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime) {
        HashBasedTable quarksToEntries = HashBasedTable.create();
        for (ResourcesEntry tge : Iterables.filter(visible, ResourcesEntry.class)) {
            ITmfStateSystem ss;
            if (zoomStartTime > tge.getEndTime() || zoomEndTime < tge.getStartTime() || tge.getQuark() < 0 || (ss = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)tge.getTrace(), (String)"org.eclipse.tracecompass.analysis.os.linux.kernel")) == null) continue;
            quarksToEntries.put((Object)ss, (Object)tge.getQuark(), (Object)tge);
        }
        return quarksToEntries;
    }

    private void addTimeEvents(@Nullable ResourcesEntry resourceEntry, Collection<ITmfStateInterval> value, boolean isZoomThread) {
        if (resourceEntry == null) {
            return;
        }
        ArrayList<TimeEvent> events = new ArrayList<TimeEvent>(value.size());
        TimeEvent prev = null;
        for (ITmfStateInterval interval : value) {
            long prevEnd;
            TimeEvent event = ResourcesView.createTimeEvent(interval, resourceEntry);
            if (prev != null && (prevEnd = prev.getTime() + prev.getDuration()) < event.getTime()) {
                events.add(new TimeEvent((ITimeGraphEntry)resourceEntry, prevEnd, event.getTime() - prevEnd));
            }
            prev = event;
            events.add(event);
        }
        if (isZoomThread) {
            this.applyResults(() -> resourceEntry.setZoomedEventList(events));
        } else {
            resourceEntry.setEventList(events);
        }
    }

    private static TimeEvent createTimeEvent(ITmfStateInterval interval, ResourcesEntry resourceEntry) {
        long startTime = interval.getStartTime();
        long duration = interval.getEndTime() - startTime + 1L;
        Object status = interval.getValue();
        if (status instanceof Integer) {
            return new TimeEvent((ITimeGraphEntry)resourceEntry, startTime, duration, ((Integer)status).intValue());
        }
        return new NullTimeEvent((ITimeGraphEntry)resourceEntry, startTime, duration);
    }

    @TmfSignalHandler
    public void listenToCpu(TmfCpuSelectedSignal signal) {
        int data = signal.getCore() >= 0 ? signal.getCore() : -1;
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setData(RESOURCES_FOLLOW_CPU, (Object)data));
    }

    private static class ResourcesEntryComparator
    implements Comparator<ITimeGraphEntry> {
        private ResourcesEntryComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            ResourcesEntry entry1 = (ResourcesEntry)o1;
            ResourcesEntry entry2 = (ResourcesEntry)o2;
            if (entry1.getType() == ResourcesEntry.Type.NULL && entry2.getType() == ResourcesEntry.Type.NULL) {
                return entry1.getName().compareTo(entry2.getName());
            }
            return entry1.compareTo((ITimeGraphEntry)entry2);
        }
    }

    private static class ResourcesFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private ResourcesFilterLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ResourcesEntry entry = (ResourcesEntry)element;
            if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }
    }
}

