/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IXYPresentationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.RGBColor;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.XYPresentationProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartTooltipProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public abstract class TmfCommonXAxisChartViewer
extends TmfXYChartViewer {
    private static final String DIRTY_UNDERFLOW_ERROR = "Dirty underflow error";
    private static final double DEFAULT_MAXY = Double.MIN_VALUE;
    private static final double DEFAULT_MINY = Double.MAX_VALUE;
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfCommonXAxisChartViewer.class);
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private final double fResolution;
    private final AtomicInteger fDirty = new AtomicInteger();
    private final Map<ITmfTrace, IXYPresentationProvider> fXYPresentationProvider;
    private UpdateThread fUpdateThread;
    private int fOverrideNbPoints = 0;
    private final ITmfXYDataProvider[] fXYDataProvider = new ITmfXYDataProvider[1];

    public TmfCommonXAxisChartViewer(Composite parent, TmfXYChartSettings settings) {
        super(parent, settings.getTitle(), settings.getXLabel(), settings.getYLabel());
        this.getSwtChart().getTitle().setVisible(false);
        this.getSwtChart().getLegend().setPosition(1024);
        this.getSwtChart().getAxisSet().getXAxes()[0].getTitle().setVisible(false);
        this.fResolution = settings.getResolution();
        this.setTooltipProvider(new TmfCommonXLineChartTooltipProvider(this));
        this.fXYPresentationProvider = new HashMap<ITmfTrace, IXYPresentationProvider>();
    }

    @Override
    public void loadTrace(ITmfTrace trace) {
        super.loadTrace(trace);
        this.fXYPresentationProvider.putIfAbsent(trace, (IXYPresentationProvider)new XYPresentationProvider());
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.fDirty.get() != 0;
    }

    public synchronized void setNbPoints(int nbPoints) {
        if (nbPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative");
        }
        this.fOverrideNbPoints = nbPoints;
        this.updateContent();
    }

    protected abstract void initializeDataProvider();

    protected IXYPresentationProvider getPresentationProvider() {
        return Objects.requireNonNull(this.fXYPresentationProvider.get(this.getTrace()));
    }

    protected void setDataProvider(ITmfXYDataProvider dataProvider) {
        this.fXYDataProvider[0] = dataProvider;
    }

    protected @NonNull TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new TimeQueryFilter(start, end, nb);
    }

    public @NonNull IYAppearance getSeriesAppearance(@NonNull String seriesName) {
        return this.getPresentationProvider().getAppearance(seriesName, "line", 1);
    }

    protected synchronized void cancelUpdate() {
        if (this.fUpdateThread != null) {
            this.fUpdateThread.cancel();
        }
    }

    @Override
    protected void updateContent() {
        this.cancelUpdate();
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.FlowScopeLog parentScope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:ContentUpdateRequested", new Object[0]).setCategory(this.getViewerId()).build();){
            this.fDirty.incrementAndGet();
            TmfCommonXAxisChartViewer.getDisplay().asyncExec(() -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:CreatingUpdateThread", new Object[0]).setParentScope(parentScope).build();){
                    this.newUpdateThread(scope);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void clearContent() {
        this.getSwtChart().getAxisSet().getXAxis(0).getTick().setFormat(null);
        super.clearContent();
    }

    private @NonNull String getViewerId() {
        return this.getClass().getName();
    }

    private synchronized void newUpdateThread(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull TraceCompassLogUtils.FlowScopeLog fScope) {
        if (this.getSwtChart().isDisposed()) {
            return;
        }
        int numRequests = this.fOverrideNbPoints != 0 ? this.fOverrideNbPoints : (int)Math.min(this.getWindowEndTime() - this.getWindowStartTime() + 1L, (long)((double)this.getSwtChart().getPlotArea().getBounds().width * this.fResolution));
        this.fUpdateThread = new UpdateThread(numRequests, fScope);
        this.fUpdateThread.start();
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        this.cancelUpdate();
        super.traceClosed(signal);
        this.setDataProvider(null);
        if (signal != null) {
            this.fXYPresentationProvider.remove(signal.getTrace());
        }
    }

    private class UpdateThread
    extends Thread {
        private final IProgressMonitor fMonitor;
        private final int fNumRequests;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull TraceCompassLogUtils.FlowScopeLog fScope;

        public UpdateThread(@NonNull int numRequests, TraceCompassLogUtils.FlowScopeLog log) {
            super("Line chart update");
            this.fNumRequests = numRequests;
            this.fMonitor = new NullProgressMonitor();
            this.fScope = log;
        }

        @Override
        public void run() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:UpdateThread", new Object[]{"numRequests=", this.fNumRequests}).setParentScope(this.fScope).build();){
                Throwable throwable2 = null;
                Object var5_8 = null;
                try (TraceCompassLogUtils.FlowScopeLog scopeDp = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "CommonXLineChart:InitializeDataProvider", new Object[0]).setParentScope(this.fScope).build();){
                    TmfCommonXAxisChartViewer.this.initializeDataProvider();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                try {
                    TimeQueryFilter filter = TmfCommonXAxisChartViewer.this.createQueryFilter(TmfCommonXAxisChartViewer.this.getWindowStartTime(), TmfCommonXAxisChartViewer.this.getWindowEndTime(), this.fNumRequests);
                    this.updateData(filter, this.fMonitor);
                }
                finally {
                    if (TmfCommonXAxisChartViewer.this.fDirty.decrementAndGet() < 0) {
                        Activator.getDefault().logError(TmfCommonXAxisChartViewer.DIRTY_UNDERFLOW_ERROR, new Throwable());
                    }
                }
                this.updateThreadFinished(this);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }

        public void cancel() {
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"CommonXLineChart:UpdateThreadCanceled", (Object[])new Object[0]);
            this.fMonitor.setCanceled(true);
        }

        private void updateData(@NonNull TimeQueryFilter filters, IProgressMonitor monitor) {
            ITmfXYDataProvider dataProvider = TmfCommonXAxisChartViewer.this.fXYDataProvider[0];
            if (dataProvider == null) {
                TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Data provider for this viewer is not available", (Object[])new Object[0]);
                return;
            }
            boolean isComplete = false;
            do {
                ITmfResponse.Status status;
                TmfModelResponse response;
                ITmfCommonXAxisModel model;
                if ((model = (ITmfCommonXAxisModel)(response = dataProvider.fetchXY(filters, monitor)).getModel()) != null) {
                    this.updateDisplay(model, monitor);
                }
                if ((status = response.getStatus()) == ITmfResponse.Status.COMPLETED) {
                    isComplete = true;
                    continue;
                }
                if (status == ITmfResponse.Status.FAILED || status == ITmfResponse.Status.CANCELLED) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)response.getStatusMessage(), (Object[])new Object[0]);
                    isComplete = true;
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)e.getMessage(), (Object[])new Object[0]);
                }
            } while (!isComplete);
        }

        private void updateDisplay(ITmfCommonXAxisModel model, IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "TmfCommonXAxisChart:UpdateDisplayRequested", new Object[0]).setCategory(TmfCommonXAxisChartViewer.this.getViewerId()).build();){
                ITmfCommonXAxisModel seriesValues = model;
                TmfCommonXAxisChartViewer.this.fDirty.incrementAndGet();
                Display.getDefault().asyncExec(() -> this.lambda$0(scope, monitor, seriesValues));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private double[] extractXValuesToDisplay(ITmfCommonXAxisModel model) {
            long[] xValuesRequested = model.getXAxis();
            double[] xValuesToDisplay = new double[xValuesRequested.length];
            long offset = TmfCommonXAxisChartViewer.this.getTimeOffset();
            int i = 0;
            while (i < xValuesRequested.length) {
                xValuesToDisplay[i] = xValuesRequested[i] - offset;
                ++i;
            }
            return xValuesToDisplay;
        }

        private @NonNull ISeries createSWTSeriesFromModel(IYModel yModel) {
            ISeriesSet seriesSet = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet();
            String seriesName = yModel.getName();
            IYAppearance appearance = TmfCommonXAxisChartViewer.this.getSeriesAppearance(seriesName);
            String type = appearance.getType();
            RGBColor rgb = appearance.getColor();
            Color color = new Color((Device)Display.getDefault(), rgb.getRed(), rgb.getGreen(), rgb.getBlue());
            if (type.equals("bar")) {
                IBarSeries barSeries = (IBarSeries)seriesSet.createSeries(ISeries.SeriesType.BAR, seriesName);
                barSeries.enableStack(true);
                barSeries.setBarColor(color);
                barSeries.setBarPadding(0);
                barSeries.setVisible(true);
                return barSeries;
            }
            ILineSeries lineSeries = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, seriesName);
            boolean isScatter = "scatter".equals(type);
            lineSeries.enableArea("area".equals(type));
            lineSeries.setLineStyle(LineStyle.valueOf((String)appearance.getStyle()));
            lineSeries.setSymbolType(isScatter ? ILineSeries.PlotSymbolType.DIAMOND : ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(color);
            lineSeries.setVisible(true);
            lineSeries.setLineWidth(appearance.getWidth());
            return lineSeries;
        }

        private synchronized void updateThreadFinished(UpdateThread thread) {
            if (thread == TmfCommonXAxisChartViewer.this.fUpdateThread) {
                TmfCommonXAxisChartViewer.this.fUpdateThread = null;
            }
        }

        /*
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$0(TraceCompassLogUtils.FlowScopeLog var1_1, IProgressMonitor var2_2, ITmfCommonXAxisModel var3_3) {
            tmfChartTimeStampFormat = new TmfChartTimeStampFormat(TmfCommonXAxisChartViewer.this.getTimeOffset());
            try {
                var5_5 = null;
                var6_7 = null;
                try {
                    log = new TraceCompassLogUtils.FlowScopeLogBuilder(TmfCommonXAxisChartViewer.access$0(), Level.FINE, "TmfCommonXAxisChart:UpdateDisplay", new Object[0]).setParentScope(var1_1).build();
                    try {
                        if (TmfCommonXAxisChartViewer.this.getSwtChart().isDisposed()) {
                            while (true) {
                                if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() < 0) {
                                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                                }
                                return;
                            }
                        }
                        if (var2_2 != null && var2_2.isCanceled()) {
                            if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() < 0) {
                                Activator.getDefault().logError("Dirty underflow error", new Throwable());
                            }
                            return;
                        }
                        maxy = 4.9E-324;
                        miny = 1.7976931348623157E308;
                        delta = TmfCommonXAxisChartViewer.this.getWindowEndTime() - TmfCommonXAxisChartViewer.this.getWindowStartTime();
                        if (delta > 0L) {
                            for (IYModel entry : var3_3.getYData().values()) {
                                series = TmfCommonXAxisChartViewer.this.getSwtChart().getSeriesSet().getSeries(entry.getName());
                                if (series == null) {
                                    series = this.createSWTSeriesFromModel(entry);
                                }
                                series.setXSeries(this.extractXValuesToDisplay(var3_3));
                                var21_22 = entry.getData();
                                var20_20 = var21_22.length;
                                var19_19 = 0;
                                while (var19_19 < var20_20) {
                                    value = var21_22[var19_19];
                                    maxy = Math.max(maxy, value);
                                    miny = Math.min(miny, value);
                                    ++var19_19;
                                }
                                series.setYSeries(entry.getData());
                            }
                            maxy = maxy == 4.9E-324 ? 1.0 : maxy;
                        } else {
                            TmfCommonXAxisChartViewer.this.clearContent();
                            delta = 1L;
                        }
                        xTick = TmfCommonXAxisChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).getTick();
                        xTick.setFormat((Format)tmfChartTimeStampFormat);
                        start = 1.0;
                        TmfCommonXAxisChartViewer.this.getSwtChart().getAxisSet().getXAxis(0).setRange(new Range(1.0, 1.0 + (double)delta));
                        TmfCommonXAxisChartViewer.this.getSwtChart().getAxisSet().getYAxis(0).adjustRange();
                        TmfCommonXAxisChartViewer.this.getSwtChart().redraw();
                        if (TmfCommonXAxisChartViewer.this.isSendTimeAlignSignals()) {
                            viewPos = TmfCommonXAxisChartViewer.this.getParent().getParent().toDisplay(0, 0);
                            axisPos = TmfCommonXAxisChartViewer.this.getSwtChart().toDisplay((int)0, (int)0).x + TmfCommonXAxisChartViewer.this.getPointAreaOffset();
                            timeAxisOffset = axisPos - viewPos.x;
                            timeAlignmentInfo = new TmfTimeViewAlignmentInfo(TmfCommonXAxisChartViewer.this.getControl().getShell(), viewPos, timeAxisOffset);
                            TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(TmfCommonXAxisChartViewer.this, timeAlignmentInfo, true));
                        }
                    }
                    finally {
                        if (log == null) ** continue;
                        log.close();
                    }
                }
                catch (Throwable var6_8) {
                    if (var5_5 == null) {
                        var5_5 = var6_8;
                    } else if (var5_5 != var6_8) {
                        var5_5.addSuppressed(var6_8);
                    }
                    throw var5_5;
                }
            }
            finally {
                if (TmfCommonXAxisChartViewer.access$1(TmfCommonXAxisChartViewer.this).decrementAndGet() < 0) {
                    Activator.getDefault().logError("Dirty underflow error", new Throwable());
                }
            }
        }
    }
}

