/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.swtchart.Chart;

public class TmfFilteredXYChartViewer
extends TmfCommonXAxisChartViewer
implements ICheckboxTreeViewerListener {
    private static final int DEFAULT_SERIES_WIDTH = 2;
    private @NonNull Collection<@NonNull Long> fSelectedIds = Collections.emptyList();
    private final String fId;

    public TmfFilteredXYChartViewer(Composite parent, TmfXYChartSettings settings, String id) {
        super(parent, settings);
        Chart chart = this.getSwtChart();
        chart.getLegend().setVisible(false);
        chart.setBackground(Display.getDefault().getSystemColor(22));
        this.fId = id;
    }

    @Override
    public void handleCheckStateChangedEvent(Collection<ITmfTreeViewerEntry> entries) {
        this.cancelUpdate();
        this.clearContent();
        Iterable counterEntries = Iterables.filter(entries, TmfGenericTreeEntry.class);
        this.fSelectedIds = Lists.newArrayList((Iterable)Iterables.transform((Iterable)counterEntries, e -> e.getModel().getId()));
        this.updateContent();
    }

    @Override
    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        this.clearContent();
        this.fSelectedIds.clear();
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        if (signal != null && signal.getTrace().equals(this.getTrace())) {
            this.fSelectedIds.clear();
        }
        super.traceClosed(signal);
    }

    @Override
    protected TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new SelectionTimeQueryFilter(start, end, nb, this.fSelectedIds);
    }

    public @NonNull Collection<@NonNull Long> getSelected() {
        return this.fSelectedIds;
    }

    @Override
    public @NonNull IYAppearance getSeriesAppearance(@NonNull String seriesName) {
        return this.getPresentationProvider().getAppearance(seriesName, "line", 2);
    }

    @Override
    protected void initializeDataProvider() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        ITmfTreeXYDataProvider provider = (ITmfTreeXYDataProvider)DataProviderManager.getInstance().getDataProvider(trace, this.fId, ITmfTreeXYDataProvider.class);
        this.setDataProvider((ITmfXYDataProvider)provider);
    }
}

