/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.tests.view.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources.AggregateEventIterator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.junit.Assert;
import org.junit.Test;

@NonNullByDefault
public class AggregateIteratorTest {
    private final ITimeGraphEntry t1 = new StubTimeGraphEntry((Iterable<ITimeEvent>)ImmutableList.of((Object)new NullTimeEvent(null, 0L, 10L), (Object)new TimeEvent(null, 10L, 1L, 1), (Object)new NullTimeEvent(null, 11L, 9L)));
    private final ITimeGraphEntry t2 = new StubTimeGraphEntry((Iterable<ITimeEvent>)ImmutableList.of((Object)new NullTimeEvent(null, 0L, 12L), (Object)new TimeEvent(null, 12L, 1L, 1), (Object)new NullTimeEvent(null, 13L, 7L)));
    private final ITimeGraphEntry t3 = new StubTimeGraphEntry((Iterable<ITimeEvent>)ImmutableList.of((Object)new NullTimeEvent(null, 0L, 9L), (Object)new TimeEvent(null, 9L, 1L, 1), (Object)new NullTimeEvent(null, 10L, 10L)));
    private final ITimeGraphEntry t4 = new StubTimeGraphEntry((Iterable<ITimeEvent>)ImmutableList.of((Object)new NullTimeEvent(null, 0L, 9L), (Object)new TimeEvent(null, 9L, 3L, 1), (Object)new NullTimeEvent(null, 12L, 8L)));
    private final ITimeGraphEntry t5 = new StubTimeGraphEntry((Iterable<ITimeEvent>)ImmutableList.of((Object)new NullTimeEvent(null, 0L, 10L), (Object)new TimeEvent(null, 10L, 3L, 1), (Object)new NullTimeEvent(null, 13L, 7L)));
    private final ITimeGraphEntry t6 = new StubTimeGraphEntry((Iterable<ITimeEvent>)ImmutableList.of((Object)new NullTimeEvent(null, 0L, 10L), (Object)new TimeEvent(null, 10L, 3L, 1), (Object)new NullTimeEvent(null, 13L, 7L)));
    private final ITimeGraphEntry t7 = new StubTimeGraphEntry((Iterable<ITimeEvent>)ImmutableList.of((Object)new TimeEvent(null, 0L, 20L, 1)));
    private static final Comparator<ITimeEvent> COMPARATOR = new Comparator<ITimeEvent>(){

        @Override
        public int compare(ITimeEvent o1, ITimeEvent o2) {
            return Integer.compare(this.getValue(o2), this.getValue(o1));
        }

        private int getValue(ITimeEvent element) {
            return element instanceof TimeEvent ? ((TimeEvent)element).getValue() : Integer.MIN_VALUE;
        }
    };

    @Test
    public void testNoOverlap() {
        ImmutableList expected = ImmutableList.of((Object)new NullTimeEvent(null, 0L, 9L), (Object)new TimeEvent(null, 9L, 1L, 1), (Object)new TimeEvent(null, 10L, 1L, 1), (Object)new NullTimeEvent(null, 11L, 1L), (Object)new TimeEvent(null, 12L, 1L, 1), (Object)new NullTimeEvent(null, 13L, 7L));
        AggregateEventIterator fixture = new AggregateEventIterator((List)ImmutableList.of((Object)this.t1, (Object)this.t2, (Object)this.t3), COMPARATOR);
        AggregateIteratorTest.runTest((List<ITimeEvent>)expected, fixture);
    }

    @Test
    public void testPartialOverlap() {
        ImmutableList expected = ImmutableList.of((Object)new NullTimeEvent(null, 0L, 9L), (Object)new TimeEvent(null, 9L, 1L, 1), (Object)new TimeEvent(null, 10L, 2L, 1), (Object)new TimeEvent(null, 12L, 1L, 1), (Object)new NullTimeEvent(null, 13L, 7L));
        AggregateEventIterator fixture = new AggregateEventIterator((List)ImmutableList.of((Object)this.t4, (Object)this.t5), COMPARATOR);
        AggregateIteratorTest.runTest((List<ITimeEvent>)expected, fixture);
    }

    @Test
    public void testFullOverlap() {
        ImmutableList expected = ImmutableList.of((Object)new NullTimeEvent(null, 0L, 10L), (Object)new TimeEvent(null, 10L, 3L, 1), (Object)new NullTimeEvent(null, 13L, 7L));
        AggregateEventIterator fixture = new AggregateEventIterator((List)ImmutableList.of((Object)this.t6, (Object)this.t5), COMPARATOR);
        AggregateIteratorTest.runTest((List<ITimeEvent>)expected, fixture);
    }

    @Test
    public void testSameStartOverlap() {
        ImmutableList expected = ImmutableList.of((Object)new NullTimeEvent(null, 0L, 9L), (Object)new TimeEvent(null, 9L, 1L, 1), (Object)new TimeEvent(null, 10L, 2L, 1), (Object)new NullTimeEvent(null, 12L, 8L));
        AggregateEventIterator fixture = new AggregateEventIterator((List)ImmutableList.of((Object)this.t3, (Object)this.t4), COMPARATOR);
        AggregateIteratorTest.runTest((List<ITimeEvent>)expected, fixture);
    }

    @Test
    public void testSameEndOverlap() {
        ImmutableList expected = ImmutableList.of((Object)new NullTimeEvent(null, 0L, 10L), (Object)new TimeEvent(null, 10L, 2L, 1), (Object)new TimeEvent(null, 12L, 1L, 1), (Object)new NullTimeEvent(null, 13L, 7L));
        AggregateEventIterator fixture = new AggregateEventIterator((List)ImmutableList.of((Object)this.t5, (Object)this.t2), COMPARATOR);
        AggregateIteratorTest.runTest((List<ITimeEvent>)expected, fixture);
    }

    @Test
    public void testOverlapEnglobing() {
        ImmutableList expected = ImmutableList.of((Object)new TimeEvent(null, 0L, 10L, 1), (Object)new TimeEvent(null, 10L, 1L, 1), (Object)new TimeEvent(null, 11L, 9L, 1));
        AggregateEventIterator fixture = new AggregateEventIterator((List)ImmutableList.of((Object)this.t1, (Object)this.t7), COMPARATOR);
        AggregateIteratorTest.runTest((List<ITimeEvent>)expected, fixture);
    }

    private static void runTest(List<ITimeEvent> expected, AggregateEventIterator fixture) {
        ArrayList results = new ArrayList();
        Iterators.addAll(results, (Iterator)fixture);
        Assert.assertEquals((long)expected.size(), (long)results.size());
        int i = 0;
        while (i < expected.size()) {
            @NonNull TimeEvent actual = (TimeEvent)results.get(i);
            @NonNull TimeEvent expected2 = (TimeEvent)expected.get(i);
            @NonNull String name = Integer.toString(i);
            Assert.assertEquals((String)name, expected2.getClass(), actual.getClass());
            Assert.assertEquals((String)name, (long)expected2.getDuration(), (long)actual.getDuration());
            Assert.assertEquals((String)name, (long)expected2.getTime(), (long)actual.getTime());
            Assert.assertEquals((String)name, (Object)expected2.getEntry(), (Object)actual.getEntry());
            Assert.assertEquals((String)name, (long)expected2.getValue(), (long)actual.getValue());
            ++i;
        }
    }

    static class StubTimeGraphEntry
    extends TimeGraphEntry {
        private final Iterable<@NonNull ITimeEvent> fEvents;

        public StubTimeGraphEntry(Iterable<ITimeEvent> events) {
            super("stub", Long.MIN_VALUE, Long.MAX_VALUE);
            this.fEvents = events;
        }

        public boolean hasTimeEvents() {
            return !Iterables.isEmpty(this.fEvents);
        }

        public Iterator<@NonNull ITimeEvent> getTimeEventsIterator() {
            return this.fEvents.iterator();
        }

        public Iterator<@NonNull ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
            if (startTime != Long.MIN_VALUE || stopTime != Long.MAX_VALUE) {
                throw new IllegalArgumentException("startTime must be Long.MIN_VALUE, stopTime must be Long.MAX_VALUE");
            }
            return this.getTimeEventsIterator();
        }
    }
}

