/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.tests.io.Util;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ArrayDeclaration2Test {
    private ArrayDeclaration fixture;

    @Before
    public void setUp() {
        this.fixture = new ArrayDeclaration(1, (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
    }

    @Test
    public void testArrayDeclaration() {
        int length = 1;
        StringDeclaration elemType = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        ArrayDeclaration result = new ArrayDeclaration(length, (IDeclaration)elemType);
        Assert.assertNotNull((Object)result);
        String left = "[declaration] array[";
        String right = result.toString().substring(0, left.length());
        Assert.assertEquals((Object)left, (Object)right);
        Assert.assertEquals((long)1L, (long)result.getLength());
    }

    @Test
    public void testCreateDefinition() throws CTFException {
        String fieldName = "";
        IDefinitionScope definitionScope = null;
        byte[] byArray = new byte[10];
        byArray[0] = 116;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 116;
        byArray[5] = 116;
        byArray[6] = 104;
        byArray[7] = 105;
        byArray[8] = 115;
        byte[] array = byArray;
        BitBuffer bb = new BitBuffer(Util.testMemory(ByteBuffer.wrap(array)));
        AbstractArrayDefinition result = this.fixture.createDefinition(definitionScope, fieldName, bb);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetElementType() {
        IDeclaration result = this.fixture.getElementType();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetLength() {
        int result = this.fixture.getLength();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testIsString_ownDefs() {
        Assert.assertFalse((boolean)this.fixture.isString());
    }

    @Test
    public void testIsString_complex() {
        IntegerDeclaration id = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)16, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.UTF8, (String)"", (long)8L);
        ArrayDeclaration ad = new ArrayDeclaration(0, (IDeclaration)id);
        boolean result = ad.isString();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        String left = "[declaration] array[";
        String right = result.substring(0, left.length());
        Assert.assertEquals((Object)left, (Object)right);
    }

    @Test
    public void hashcodeTest() {
        Assert.assertEquals((long)2016L, (long)this.fixture.hashCode());
        Assert.assertEquals((long)new ArrayDeclaration(1, (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8)).hashCode(), (long)this.fixture.hashCode());
    }

    @Test
    public void equalsTest() {
        ArrayDeclaration a = new ArrayDeclaration(1, (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        ArrayDeclaration b = new ArrayDeclaration(2, (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        ArrayDeclaration c = new ArrayDeclaration(1, (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        ArrayDeclaration d = new ArrayDeclaration(1, (IDeclaration)IntegerDeclaration.INT_32B_DECL);
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertEquals((Object)a, (Object)d);
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertEquals((Object)d, (Object)a);
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)b));
        Assert.assertFalse((boolean)b.isBinaryEquivalent((IDeclaration)a));
        Assert.assertFalse((boolean)a.isBinaryEquivalent((IDeclaration)c));
        Assert.assertFalse((boolean)c.isBinaryEquivalent((IDeclaration)a));
        Assert.assertTrue((boolean)a.isBinaryEquivalent((IDeclaration)d));
        Assert.assertTrue((boolean)d.isBinaryEquivalent((IDeclaration)a));
        Assert.assertTrue((boolean)a.isBinaryEquivalent((IDeclaration)a));
    }
}

