/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer.TestDirectoryStructureUtil;
import org.eclipse.tracecompass.integration.swtbot.tests.projectexplorer.TestTraceInfo;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.wizards.SWTBotImportWizardUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IEditorReference;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ProjectExplorerTraceActionsTest {
    private static @NonNull TestTraceInfo CUSTOM_TEXT_LOG = new TestTraceInfo("ExampleCustomTxt.log", "Custom Text : TmfGeneric", 10L, "29:52.034");
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String TRACE_NAME = CUSTOM_TEXT_LOG.getTraceName();
    private static final String RENAMED_TRACE_NAME = String.valueOf(TRACE_NAME) + 2;
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;
    private static final File TEST_TRACES_PATH;

    static {
        fLogger = Logger.getRootLogger();
        TEST_TRACES_PATH = new File(new Path(TmfTraceManager.getTemporaryDirPath()).append("testtraces").toOSString());
    }

    private static String getPath(String relativePath) {
        return new Path(TEST_TRACES_PATH.getAbsolutePath()).append(relativePath).toOSString();
    }

    @BeforeClass
    public static void init() throws IOException {
        TestDirectoryStructureUtil.generateTraceStructure(TEST_TRACES_PATH);
        SWTBotUtils.initialize();
        CustomTxtTraceDefinition[] txtDefinitions = CustomTxtTraceDefinition.loadAll((String)ProjectExplorerTraceActionsTest.getPath("customParsers/ExampleCustomTxtParser.xml"));
        txtDefinitions[0].save();
        fTestFile = new File(ProjectExplorerTraceActionsTest.getPath(new Path("import").append(CUSTOM_TEXT_LOG.getTracePath()).toString()));
        Assert.assertTrue((boolean)fTestFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"Welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
    }

    @AfterClass
    public static void tearDown() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    @After
    public void afterTest() {
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    @Test
    public void test4_01ContextMenuPresence() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        ImmutableList EXPECTED_MENU_LABELS = ImmutableList.of((Object)"Open", (Object)"Open As Experiment...", (Object)"Open With", (Object)"", (Object)"Copy...", (Object)"Rename...", (Object)"Delete", (Object)"", (Object)"Delete Supplementary Files...", (Object)"", (Object)"Export Trace Package...", (Object)"", (Object[])new String[]{"Select Trace Type...", "", "Apply Time Offset...", "Clear Time Offset", "", "Refresh"});
        List menuItems = traceItem.contextMenu().menuItems();
        Assert.assertEquals((Object)EXPECTED_MENU_LABELS, (Object)menuItems);
        fBot.closeAllEditors();
    }

    @Test
    public void test4_02Open() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testStatisticsView();
        fBot.closeAllEditors();
    }

    @Test
    public void test4_03Copy() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        ProjectExplorerTraceActionsTest.createCopy(traceItem);
        fBot.closeAllEditors();
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        copiedItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        fBot.closeAllEditors();
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
    }

    @Test
    public void test4_04Rename() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Rename..."}).click();
        String RENAME_TRACE_DIALOG_TITLE = "Rename Trace";
        fBot.waitUntil(Conditions.shellIsActive((String)"Rename Trace"));
        SWTBotShell shell = fBot.shell("Rename Trace");
        SWTBotText text = shell.bot().textWithLabel("New Trace name:");
        text.setText(RENAMED_TRACE_NAME);
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        copiedItem.contextMenu().menu(new String[]{"Open"}).click();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)RENAMED_TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        fBot.closeAllEditors();
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
    }

    @Test
    public void test4_05Delete() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.contextMenu().menu(new String[]{"Delete"}).click();
        String DELETE_TRACE_DIALOG_TITLE = "Confirm Delete";
        fBot.waitUntil(Conditions.shellIsActive((String)"Confirm Delete"));
        SWTBotShell shell = fBot.shell("Confirm Delete");
        shell.bot().button("Yes").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        fBot.waitUntil((ICondition)new TraceDeletedCondition());
    }

    @Test
    public void test4_06OpenKeyboard() throws WidgetNotFoundException {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.select();
        fBot.activeShell().pressShortcut(new KeyStroke[]{Keystrokes.CR});
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testStatisticsView();
        fBot.closeAllEditors();
    }

    @Test
    public void test4_07DeleteKeyboard() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.select();
        fBot.activeShell().pressShortcut(new KeyStroke[]{Keystrokes.DELETE});
        String DELETE_TRACE_DIALOG_TITLE = "Confirm Delete";
        fBot.waitUntil(Conditions.shellIsActive((String)"Confirm Delete"));
        SWTBotShell shell = fBot.shell("Confirm Delete");
        shell.bot().button("Yes").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        fBot.waitWhile((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, null));
        fBot.waitUntil((ICondition)new TraceDeletedCondition());
    }

    @Test
    public void test4_08OpenDoubleClick() throws WidgetNotFoundException {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.doubleClick();
        SWTBotImportWizardUtils.testEventsTable((SWTWorkbenchBot)fBot, (String)TRACE_NAME, (long)CUSTOM_TEXT_LOG.getNbEvents(), (String)CUSTOM_TEXT_LOG.getFirstEventTimestamp());
        ProjectExplorerTraceActionsTest.testStatisticsView();
        fBot.closeAllEditors();
    }

    @Test
    public void test4_09BringToTop() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)fTestFile.getAbsolutePath(), (String)CUSTOM_TEXT_LOG.getTraceType());
        SWTBotTreeItem traceItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)TRACE_NAME);
        traceItem.doubleClick();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        IEditorReference originalEditor = (IEditorReference)fBot.activeEditor().getReference();
        ProjectExplorerTraceActionsTest.createCopy(traceItem);
        SWTBotTreeItem copiedItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME), (String)RENAMED_TRACE_NAME);
        copiedItem.doubleClick();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, RENAMED_TRACE_NAME));
        SWTBotUtils.delay((long)1000L);
        traceItem.doubleClick();
        fBot.waitUntil((ICondition)new ConditionHelpers.ActiveEventsEditor(fBot, TRACE_NAME));
        Assert.assertTrue((originalEditor == fBot.activeEditor().getReference() ? 1 : 0) != 0);
        fBot.closeAllEditors();
        SWTBotUtils.clearTracesFolderUI((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
    }

    private static void createCopy(SWTBotTreeItem traceItem) {
        traceItem.contextMenu().menu(new String[]{"Copy..."}).click();
        String COPY_TRACE_DIALOG_TITLE = "Copy Trace";
        fBot.waitUntil(Conditions.shellIsActive((String)"Copy Trace"));
        SWTBotShell shell = fBot.shell("Copy Trace");
        SWTBotText text = shell.bot().textWithLabel("New Trace name:");
        text.setText(RENAMED_TRACE_NAME);
        shell.bot().button("OK").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
    }

    private static void testStatisticsView() {
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.tmf.ui.views.statistics");
        SWTBotView view = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.statistics");
        Assert.assertTrue((boolean)view.bot().tree().hasItems());
        view.bot().tree().cell(0, 1).equals(Long.toString(CUSTOM_TEXT_LOG.getNbEvents()));
    }

    private final class TraceDeletedCondition
    extends DefaultCondition {
        private TraceDeletedCondition() {
        }

        public boolean test() throws Exception {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(ProjectExplorerTraceActionsTest.TRACE_PROJECT_NAME).findMember((IPath)new Path("Traces/" + TRACE_NAME)) == null;
        }

        public String getFailureMessage() {
            return String.valueOf(TRACE_NAME) + " was not deleted successfully.";
        }
    }
}

