/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeColumn;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTestBase;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimePreferences;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlFlowViewSortingTest
extends KernelTestBase {
    private static final String TRACE_NAME = "scp_dest";
    private static final String FILTER_ACTION = "Show View Filters";
    private static final String FILTER_DIALOG_TITLE = "Filter";
    private static final String UNCHECK_ALL = "Uncheck all";
    private static final String CHECK_SUBTREE = "Check subtree";
    private static final String OK_BUTTON = "OK";
    private static final String PROCESS_COLUMN = "Process";
    private static final int PROCESS_COLUMN_ID = 0;
    private static final String TID_COLUMN = "TID";
    private static final int TID_COLUMN_ID = 1;
    private static final String PTID_COLUMN = "PTID";
    private static final String BIRTH_COLUMN = "Birth time";
    private static final int BIRTH_COLUMN_ID = 3;
    private static final String SYSTEMD_PROCESS_NAME = "systemd";
    private static final long SYSTEMD_BIRTHTIME = 1361214078967531336L;
    private static final String SYSTEMD_TID = "1";
    private static final String KTHREAD_PROCESS_NAME = "kthreadd";
    private static final long KTHREAD_BIRTHTIME = 1361214078967533536L;
    private static final String KTHREAD_TID = "2";
    private static final String LTTNG_CONSUMER_PROCESS_NAME = "lttng-consumerd";
    private static final long LTTNG_CONSUMER_BIRTHTIME = 1361214078963717040L;
    private static final String LTTNG_CONSUMER_TID = "4034";
    private static final @NonNull ITmfTimestamp TRACE_START_TIME = TmfTimestamp.create((long)1361214078963711320L, (int)-9);
    private SWTBotView fViewBot;

    @Override
    @Before
    public void before() {
        try {
            IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
            defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", "GMT-05:00");
            TmfTimestampFormat.updateDefaultFormats();
            String tracePath = Paths.get(FileLocator.toFileURL((URL)CtfTestTrace.SYNC_DEST.getTraceURL()).toURI()).toString();
            SWTBotUtils.openTrace((String)"test", (String)tracePath, (String)"org.eclipse.linuxtools.lttng2.kernel.tracetype");
            this.fViewBot = fBot.viewByTitle("Control Flow");
            this.fViewBot.show();
            this.fViewBot.setFocus();
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail();
        }
    }

    @Override
    public void after() {
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone", (String)TmfTimePreferences.getDefaultPreferenceMap().get("org.eclipse.linuxtools.tmf.core.prefs.time.format.timezone"));
        TmfTimestampFormat.updateDefaultFormats();
        super.after();
    }

    @Test
    public void testColumnSorting() {
        fBot.waitUntil(ConditionHelpers.timeGraphIsReadyCondition((AbstractTimeGraphView)((AbstractTimeGraphView)this.fViewBot.getViewReference().getPart(false)), (TmfTimeRange)new TmfTimeRange(TRACE_START_TIME, TRACE_START_TIME), (ITmfTimestamp)TRACE_START_TIME));
        this.applyFilter();
        SWTBotTree tree = this.fViewBot.bot().tree();
        SWTBotTimeGraph timeGraph = new SWTBotTimeGraph(this.fViewBot.bot());
        SWTBotTimeGraphEntry timeGraphEntry = timeGraph.getEntry(new String[]{TRACE_NAME, SYSTEMD_PROCESS_NAME});
        timeGraphEntry.select();
        ControlFlowViewSortingTest.testProcessSorting(tree, timeGraph);
        ControlFlowViewSortingTest.testTidSorting(tree, timeGraph);
        ControlFlowViewSortingTest.testPidSorting(tree, timeGraph);
        ControlFlowViewSortingTest.testBirthtimeSorting(tree, timeGraph);
    }

    private void applyFilter() {
        SWTBotToolbarButton filterButton = this.fViewBot.toolbarButton(FILTER_ACTION);
        filterButton.click();
        SWTBotShell shell = fBot.shell(FILTER_DIALOG_TITLE).activate();
        SWTBot bot = shell.bot();
        SWTBotTree treeBot = bot.tree();
        bot.button(UNCHECK_ALL).click();
        int checked = SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
        Assert.assertEquals((String)"default", (long)0L, (long)checked);
        ControlFlowViewSortingTest.checkFilterTreeItems(bot, treeBot, SYSTEMD_PROCESS_NAME);
        ControlFlowViewSortingTest.checkFilterTreeItems(bot, treeBot, KTHREAD_PROCESS_NAME);
        ControlFlowViewSortingTest.checkFilterTreeItems(bot, treeBot, LTTNG_CONSUMER_PROCESS_NAME);
        bot.button(OK_BUTTON).click();
    }

    private static void checkFilterTreeItems(SWTBot bot, SWTBotTree treeBot, String process) {
        SWTBotTreeItem item = SWTBotUtils.getTreeItem((SWTBot)bot, (SWTBotTree)treeBot, (String[])new String[]{TRACE_NAME, process});
        item.select();
        bot.button(CHECK_SUBTREE).click();
        SWTBotUtils.getTreeCheckedItemCount((SWTBotTree)treeBot);
    }

    private static void testProcessSorting(SWTBotTree tree, SWTBotTimeGraph timeGraph) {
        SWTBotTreeColumn column = tree.header(PROCESS_COLUMN);
        String[] expected = new String[]{KTHREAD_PROCESS_NAME, LTTNG_CONSUMER_PROCESS_NAME, SYSTEMD_PROCESS_NAME};
        ConditionHelpers.SWTBotTestCondition condition = ControlFlowViewSortingTest.getSortCondition(PROCESS_COLUMN, 0, expected, timeGraph, false);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
        condition = ControlFlowViewSortingTest.getSortCondition(PROCESS_COLUMN, 0, expected, timeGraph, true);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
    }

    private static void testTidSorting(SWTBotTree tree, SWTBotTimeGraph timeGraph) {
        String[] expected = new String[]{SYSTEMD_TID, KTHREAD_TID, LTTNG_CONSUMER_TID};
        SWTBotTreeColumn column = tree.header(TID_COLUMN);
        ConditionHelpers.SWTBotTestCondition condition = ControlFlowViewSortingTest.getSortCondition(TID_COLUMN, 1, expected, timeGraph, false);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
        condition = ControlFlowViewSortingTest.getSortCondition(TID_COLUMN, 1, expected, timeGraph, true);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
    }

    private static void testPidSorting(SWTBotTree tree, SWTBotTimeGraph timeGraph) {
        SWTBotTreeColumn column = tree.header(PTID_COLUMN);
        String[] expected = new String[]{LTTNG_CONSUMER_PROCESS_NAME, SYSTEMD_PROCESS_NAME, KTHREAD_PROCESS_NAME};
        ConditionHelpers.SWTBotTestCondition condition = ControlFlowViewSortingTest.getSortCondition(PTID_COLUMN, 0, expected, timeGraph, false);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
        String[] expected2 = new String[]{SYSTEMD_PROCESS_NAME, KTHREAD_PROCESS_NAME, LTTNG_CONSUMER_PROCESS_NAME};
        condition = ControlFlowViewSortingTest.getSortCondition(PTID_COLUMN, 0, expected2, timeGraph, false);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
    }

    private static void testBirthtimeSorting(SWTBotTree tree, SWTBotTimeGraph timeGraph) {
        SWTBotTreeColumn column = tree.header(BIRTH_COLUMN);
        String[] expected = new String[]{Utils.formatTime((long)1361214078963717040L, (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC), Utils.formatTime((long)1361214078967531336L, (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC), Utils.formatTime((long)1361214078967533536L, (Utils.TimeFormat)Utils.TimeFormat.CALENDAR, (Utils.Resolution)Utils.Resolution.NANOSEC)};
        ConditionHelpers.SWTBotTestCondition condition = ControlFlowViewSortingTest.getSortCondition(BIRTH_COLUMN, 3, expected, timeGraph, false);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
        condition = ControlFlowViewSortingTest.getSortCondition(BIRTH_COLUMN, 3, expected, timeGraph, true);
        ControlFlowViewSortingTest.clickColumn(tree, column, condition);
    }

    private static void clickColumn(SWTBotTree tree, SWTBotTreeColumn processColumn, ConditionHelpers.SWTBotTestCondition condition) {
        processColumn.click();
        fBot.waitUntil((ICondition)condition);
    }

    private static ConditionHelpers.SWTBotTestCondition getSortCondition(final String testCase, final int column, final String[] expected, final SWTBotTimeGraph timeGraph, final boolean reverse) {
        return new ConditionHelpers.SWTBotTestCondition(){

            public boolean test() throws Exception {
                SWTBotTimeGraphEntry[] entries = timeGraph.getEntry(new String[]{ControlFlowViewSortingTest.TRACE_NAME}).getEntries();
                if (reverse) {
                    int i = expected.length - 1;
                    while (i > 0) {
                        if (!expected[i].equals(entries[expected.length - (i + 1)].getText(column))) {
                            return false;
                        }
                        --i;
                    }
                } else {
                    int i = 0;
                    while (i < expected.length) {
                        if (!expected[i].equals(entries[i].getText(column))) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }

            public String getFailureMessage() {
                return NLS.bind((String)"Test Case: {0} failed!", (Object)testCase);
            }
        };
    }
}

